#ifndef DPMACS_H_INCLUDED
#define DPMACS_H_INCLUDED

#define	DIM(x)	    (sizeof(x)/sizeof(x[0]))

#ifndef MIN
#define	MIN(a, b)   (((a) < (b)) ? (a) : (b))
#endif

#ifndef MAX
#define	MAX(a, b)   (((a) > (b)) ? (a) : (b))
#endif


/* determine the offset of a field within a structure */
#define field_offset(f, t)	((char*)(&(((t*)0)->f)) - (char*)0)

#define	num_units(bytes, unit_size) (((bytes)+(unit_size)-1)/(unit_size))

#define	num_units_shift(bytes, unit_shift) \
    (((bytes)+(1<<(unit_shift))-1)>>unit_shift)

#define	round_np2(size, np2)	(((size)+((np2)-1)) & ~((np2)-1))
#define	round_p2(size, p2)	round_np2(size, (1<<(p2)))

#define	long_round(l)	round_np2(l, sizeof(long))

#endif
