#include <stdio.h>
#include <setjmp.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>

static int  eprintf_stiflef = 0;
int	    eprintf_jump_on_exit_code = 0;
jmp_buf	    eprintf_error_vector;

static FILE*	ep_log = NULL;

/*
************************************************************************
*
* 
* 
************************************************************************
*/
int
eprintf_stifle(
    int	newval)
{
    int	old = eprintf_stiflef;

    eprintf_stiflef = newval;

    return (old);
}

/*
************************************************************************
*
* 
* 
************************************************************************
*/
void
eprint_str(
    char*   str)
{
    if (ep_log) {
	fprintf(ep_log, "%s%s", eprintf_stiflef ? "[Q]: " : "", str);
	fflush(ep_log);
    }
    
    if (eprintf_stiflef)
	return;
    fprintf(stderr, "%s", str);
    fflush(stderr);
}
    
/*
************************************************************************
*
* 
* 
************************************************************************
*/
void
eprintf(
    int		exit_code,
    int		err,
    char*	fmt,
    ...)
{
    va_list ap;  // for variable args
    char    buf[1024];
    int	    len;
    extern  char*   progname;

    if (progname)
	len = sprintf(buf, "%s: ", progname);
    else
	len = 0;
    
    if (err)
	len += sprintf(buf+len, "%s: ", strerror(err));
    
    va_start(ap, fmt); // init specifying last non-var arg
    len = vsnprintf(buf+len, sizeof(buf)-2-len, fmt, ap);
    va_end(ap); // end var args

    eprint_str(buf);
    if (len < 0 || len > (int)sizeof(buf)) {
	eprint_str(" (error msg truncated)");
    }

    if (exit_code) {
	if (eprintf_jump_on_exit_code)
	    longjmp(eprintf_error_vector, exit_code);
	else 
	    exit(exit_code);
    }
}
/*
************************************************************************
*
* 
* 
************************************************************************
*/
int
rprintf(
    char*   fmt,
    ...)
{
    va_list ap;  // for variable args
    int	    rc;
    
    if (eprintf_stiflef)
	return (-1);

    va_start(ap, fmt); // init specifying last non-var arg
    rc = vprintf(fmt, ap);
    fflush(stdout);
    return (rc);
}

/*
************************************************************************
*
* 
* 
************************************************************************
*/
int
eprintf_openlog(
    char*   logfile)
{
    if ((ep_log = fopen(logfile, "a")) == NULL) {
	eprintf(0, errno, "Cannot open error log file >%s<.\n", logfile);
	return (-1);
    }

    return (0);
}

/*
************************************************************************
*
* 
* 
************************************************************************
*/
int
eprintf_closelog(
    void)
{
    if (ep_log && (fclose(ep_log) != 0)) {
	eprintf(0, errno, "Cannot close error log file\n");
	return (-1);
    }

    return (0);
}

