#ifndef EPRINTF_H_INCLUDED
#define EPRINTF_H_INCLUDED

#define	set_error_vector(v)  {			\
    (v) = setjmp(error_vector);			\
    jump_on_exit_code = 1;			\
}

#define unset_error_vector() {			\
    jump_on_exit_code = 0;			\
}

#define	error_vector_setq()	(jump_on_exit_code != 0)

extern int
eprintf_stifle(
    int	newval);

extern void
eprintf(
    int		exit_code,
    int		err,
    char*	fmt,
    ...);

extern int
rprintf(
    char*   fmt,
    ...);

extern int
eprintf_openlog(
    char*   logfile);

extern int
eprintf_closelog(
    void);

#endif
