#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#include "eprintf.h"
/*
************************************************************************
*
* 
* 
************************************************************************
*/
char*
basee(
    const char*	name)
{
    const char*	progname;
    
    progname = name + strlen(name);
    while (progname >= name && *progname != '/')
	progname--;
    ++progname;
    return ((char*)progname);
}

/*
************************************************************************
*
* read n bytes into a buffer.
* 
************************************************************************
*/
int
fillbuf_fd(
    int		read_fd,
    char*	buf,
    ssize_t	desired,
    int		till_eof, /* read till eof, no target size */
    ssize_t*	num_readp)
{
    ssize_t	num_read;
    ssize_t	total_read = 0;
    ssize_t	resid = desired;

    /* using desired here allows a zero byte read to succeed */
    while (desired) {
	num_read = read(read_fd, buf, resid);
    
	/* all errors are fatal */
	if (num_read < 0) {
	    eprintf(0, errno, "read failed.\n");
	    return (-1);
	}

	total_read += num_read;
	resid -= num_read;
	buf += num_read;

	/* did we satsify our read ??? */
	if (resid == 0) {
	    if (!till_eof)
		break;
	    /*
	     * we've read all we were asked to.
	     * If till_eof is set, then desired is really the max
	     * that we can fit into our buffer.
	     * If resid is zero, that means we've hit the limit
	     * we can hold.  If there is more to read then we have
	     * a problem.  So we probe for EOF by reading one more.
	     */
	    num_read = read(read_fd, buf, 1);
	    if (num_read == 0) { /* EOF */
		break;
	    }
	
	    eprintf(0, 0, "end of buffer hit with more data present. "
		    "num_read: %d\n", num_read);
	    return (-1);
	}
	
	if (num_read == 0) {
	    /* till eof means eof is OK */
	    if (till_eof)
		break;
	
	    /*
	     * not in till_eof mode, this is an error since we didn't
	     * read everything we were asked to.
	     */
	    eprintf(0, 0, "premature EOF, read %d of %d bytes.\n",
		    total_read, desired);
	    return (-1);
	}
    }

    *num_readp = total_read;
    return (0);
}
