#include <stdio.h>		/* need NULL */
#include <string.h>

#if 0
#define debug(fmt...)	printf(fmt)
#else
#define debug(fmt...)
#endif

/*
************************************************************************
*
* 
* 
************************************************************************
*/
char*
option_peek(
    int	    argc,
    char*   argv[],
    char*   options,
    char*   target)
{
    int	    i;
    char*   p;
    char*   ret;
    int	    next_arg = 0;

    for (i = 1; i < argc; i++) {
	debug("op, i: %d, argc: %d\n", i, argc);
	
	if (argv[i][0] != '-')
	    return (NULL);

	/* look at this argv element, char by char */
	for (p = &argv[i][1]; p && *p; ) {
	    char    optchar = *p;
	    char*   optp;

	    debug("p>%s<\n", p);
	    
	    if ((optp = strchr(options, optchar)) == NULL) {
		/*
		 * found a bogus option, return no match and let
		 * main argv loop catch the error
		 */
		return (NULL);
	    }
	    /* see if this option has an arg */
	    if (optp[1] == ':') {
		/* we have an arg */
		
		/* is it in this argv element? */
		++p;
		if (*p)
		    ret = p;
		else if (i + 1 >= argc)
		    /* no more args, let main arg loop catch error */
		    return (NULL);
		else 
		    ret = argv[++i];

		/*
		 * we have an arg. this consumes either the rest
		 * of this argv[i] or all of the next one.
		 * */
		next_arg = 1;
	    }
	    else {
		next_arg = p[1] == 0;
		ret = target;	/* non-null return value for simple flags */
	    }
	    
	    debug("optchar>%c<, target>%s<\n", optchar, target);
	    if (optchar == target[0]) {
		/* we've found our farget */
		return (ret);
	    }
	    
	    /* not what we're looking for */
	    if (next_arg) {
		/*
		 * we had an arg, so we need to look at the next
		 * argv element
		 */
		break;
	    }
	    else
		++p;
	}
    }

    return (NULL);
}
