#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "eprintf.h"

int safe_zalloc_exit = 99;

#define	MALLOC_TRACK	1
#ifdef	MALLOC_TRACK

#define	LOG_PTR(p, ctxt, caller)    tmd_log_ptr(p, ctxt, caller)

typedef struct tal_malloc_debug_info_s
{
    char*   context;
    void*   ptr;
}
tal_malloc_debug_info_t;

#define	TAL_MALLOC_DEBUG_NUM_ENTRIES	50000

tal_malloc_debug_info_t	tal_malloc_debug_entries[TAL_MALLOC_DEBUG_NUM_ENTRIES];

void
tmd_check_list(
    void)
{
    int	i;
    
    for (i = 0; i < TAL_MALLOC_DEBUG_NUM_ENTRIES; i++) {
	if (tal_malloc_debug_entries[i].ptr != NULL) {
	    printf("unfreed pointer: %p, context>%s<\n",
		   tal_malloc_debug_entries[i].ptr,
		   tal_malloc_debug_entries[i].context);
	}
    }
}

tal_malloc_debug_info_t*
tmd_find_by_ptr(
    void*   ptr)
{
    int	i;

    for (i = 0; i < TAL_MALLOC_DEBUG_NUM_ENTRIES; i++) {
	if (tal_malloc_debug_entries[i].ptr == ptr)
	    return (&tal_malloc_debug_entries[i]);
    }

    return (NULL);
}

void
tmd_ch_ptr(
    tal_malloc_debug_info_t*	info,
    void*   ptr,
    char*   context)
{
    info->ptr = ptr;
    info->context = context;
}


void
tmd_log_ptr(
    void*   ptr,
    char*   context,
    char*   caller)
{
    tal_malloc_debug_info_t*	info;

    info = tmd_find_by_ptr(NULL);

    if (info == NULL) {
	printf("tmd_log_ptr(%p, %s, %s): no more dbg entries\n",
	       ptr, context, caller);
    }
    else {
	tmd_ch_ptr(info, ptr, context);
    }
}

tal_malloc_debug_info_t*
tmd_ck_ptr(
    void*   ptr,
    char*   context,
    char*   caller)
{
    tal_malloc_debug_info_t*	info;

    info = tmd_find_by_ptr(ptr);

    if (info == NULL)
	printf("tmd_ck_ptr(%p, %s, %s): ptr not in table\n",
	       ptr, context, caller);

    return (info);
}

void
tmd_rm_ptr(
    tal_malloc_debug_info_t*	info)
{
    info->ptr = NULL;
}
#else

#define	LOG_PTR(p, ctxt, caller)

#endif

void*
safe_zalloc(
    size_t  size,
    char*   label)
{
    void*   ret;
    
    if ((ret = malloc(size)) != NULL) {
	memset(ret, 0x00, size);
	LOG_PTR(ret, label, "safe_zalloc()");
	return (ret);
    }

    if (label && *label) {
	eprintf(safe_zalloc_exit, 0, "safe_zalloc() failed for '%s'\n", label);
    }

    return (ret);
}

void
safe_free(
    void*   ptr,
    char*   context)
{
#ifdef	MALLOC_TRACK
    tal_malloc_debug_info_t*	info;
    info = tmd_ck_ptr(ptr, context, "safe_free");
#endif

    free(ptr);			/* this free is OK (inside safe_free) */

#ifdef	MALLOC_TRACK
    if (info)
	tmd_rm_ptr(info);
#endif
}

void*
safe_realloc(
    void*   ptr,
    size_t  new_size,
    char*   context)
{
    void*   ret;
#ifdef	MALLOC_TRACK
    tal_malloc_debug_info_t*	info = NULL;

    if (ptr)
	info = tmd_ck_ptr(ptr, context, "realloc");
#endif    
    
    ret = realloc(ptr, new_size);

#ifdef	MALLOC_TRACK
    if (ret != NULL) {
	if (info)
	    tmd_ch_ptr(info, ret, context);
	else
	    tmd_log_ptr(ret, context, "realloc");
    }
#endif

    return (ret);
}
    
void
tmd_mem_check(void)
{
#ifdef	MALLOC_TRACK
    tmd_check_list();
#endif
}
