#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>

#include "eprintf.h"

unsigned long
getsizeX(
    char*   arg,
    int	    fatal,
    ...)
{
    unsigned long   tlen;
    char*	    p;

    if (arg[0] >= '0' && arg[0] <= '9') {
	tlen = strtoul(arg, &p, 0);
	switch (*p) {
	    case 'k':
	    case 'K':
		tlen <<= 10;
		break;
		
	    case 'm':
	    case 'M':
		tlen <<= 20;
		break;

	    case '\0':
		break;
		
	    default:
	    {
		char*		suffixes;
		unsigned long	mult;
		va_list		ap;
		
		/* unknown suffix, search additional params for it */
		va_start(ap, fatal); // init specifying last non-var arg
		suffixes = va_arg(ap, char*);
		while (suffixes) {
		    mult = va_arg(ap, unsigned long);
		    if (strchr(suffixes, *p))
			return (tlen * mult);
		    suffixes = va_arg(ap, char*);
		}
		eprintf(fatal, 0, "Unknown suffix on number>%s<\n", arg);
		break;
	    }
	}
    }
    else {
	/*
	 * compiler doens't know eprintf won't return in this case.
	 */
	tlen = 0;
	eprintf(fatal, 0, "Badly formed number>%s<\n", arg);
    }

    return (tlen);
}
