#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>

#include "dplib/dpmacs.h"
#include "dplib/eprintf.h"
#include "dplib/dl_list.h"
#include "dplib/fs-helpers.h"
#include "dplib/cmdproc.h"
#include "dplib/malloc-helpers.h"
#include "dplib/numio.h"
#include "dplib/mach.h"

#include "bootldr/partition.h"
#include "dplib/bl_params.h"

char*		progname;
blp_params_t	params;
blp_params_t*	paramsp = &params;

/*
************************************************************************
*
* 
* 
************************************************************************
*/
int
main(
    int	    argc,
    char*   argv[])
{
    char*	options = "s:i:";
    int		opt;
    char*	infile;
    blp_part_t*	item;
    
    extern char*    optarg;
    extern int	    optind;
    extern int	    opterr;

    if (sizeof(long) != 4)
	eprintf(2, 0, "This program assumes longs are 4 bytes.  Sorry.\n"
		"You'll need to port it.\n");

    if (!is_little_endian())
	eprintf(2, 0, "This program assumes the processor is little endian.  "
		"Sorry.\n"
		"You'll need to port it.\n");
    
    infile = "params.bin";
    memset((char*)&params, 0x00, sizeof(params));
    dl_list_init(&params.partition_list);
    dl_list_init(&params.variable_list);
    
    opterr = 1;

    blp_set_sector_size_s(&params, "0x40000");

    progname = basename(argv[0]);

    while ((opt = getopt(argc, argv, options)) != EOF) {
	switch (opt) {
	    case 'i':
		infile = optarg;
		break;
		
	    case 's':
		blp_set_sector_size_s(&params, optarg);
		break;
		
	    default:
		eprintf(2, 0, "Illegal option.\n");
		exit(2);
	}
    }

    blp_get_partition_table(infile, &params);
    
    /*
     * example of traversing the table.
     */
    {
	dl_iter_t	iter;
	size_t		pt_len = sizeof(BootldrFlashPartitionTable);

	rprintf("Partition Table:\n");
	
	for (item = BLP_PARAM_FIRST_PART(paramsp, &iter);
	     item;
	     item = BLP_PARAM_NEXT_PART(&iter)) {
	    blp_display_part(item);
	    pt_len += sizeof(item->part);
	}
	rprintf("part table len: %d\n", pt_len);
    }

    /*
     * now,  dump the requested parts
     */
    
    while (optind < argc) {
	char*	name = argv[optind++];
	
	if ((item = blp_find_part_by_name(paramsp, name)) == NULL)
	    rprintf("No part named >%s<\n", name);
	else {
	    rprintf("Part >%s<, size: 0x%x, base: 0x%x, flags: 0x%x\n",
		    name,
		    BLP_PART_SIZE(item),
		    BLP_PART_BASE(item),
		    BLP_PART_FLAGS(item));
	}
    }

    blp_free_all(paramsp);

    tmd_mem_check();
    
    return (0);
}
