.PHONY:		clean

PATH		:= /skiff/local/bin:/bin:${PATH}

AS		:= $(CROSS_COMPILE)${AS}
LD		:= $(CROSS_COMPILE)${LD}
CC		:= $(CROSS_COMPILE)gcc
AR		:= $(CROSS_COMPILE)${AR}

xOBJS  := ${SRCS}
xOBJS	:= $(subst .cxx,.o,$(xOBJS))
xOBJS	:= $(subst .c,.o,$(xOBJS))
xOBJS	:= $(subst .s,.o,$(xOBJS))
xOBJS	:= $(subst .S,.o,$(xOBJS))
#
# non ':' assignment allows us to refer to additional objs defined later in
# this or the including makefile
xFULL_PATH_OBJS := $(foreach obj,$(xOBJS),$(OBJ_DIR)/$(obj))
OBJS	= $(xFULL_PATH_OBJS)

IFLAGS	:= ${IFLAGS} ${DEFS}

CFLAGS	+= -Wall  -Wstrict-prototypes

CFLAGS 	+= ${IFLAGS} $(OPTIM)

ifeq ($(CROSS_COMPILE), arm-linux-)
CFLAGS		+= -fno-strict-aliasing
CFLAGS		+= -pipe -mapcs-32
CFLAGS		+= -march=armv4
CFLAGS		+= -mtune=strongarm110
CFLAGS		+= -mshort-load-bytes
CFLAGS		+= -msoft-float
endif

ifeq ($(CLEAN_FILES),)
CLEAN_FILES := *.o *.a *~ core* .depend*
endif

clean:
	rm -f ${CLEAN_DIRS_TOO} ${CLEAN_FILES}

depend .depend dep: ${SRCS}
	$(CC) $(IFLAGS) -M $(SRCS) > .depend

ifeq (.depend,$(wildcard .depend))
include .depend
endif
