/*
 * Atmel EEPROM programming software for iPAQ H3600
 *
 * Copyright 2001 Compaq Computer Corporation.
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 * Author: Andrew Christian 
 *         <andrew.christian@compaq.com>
 *         October 2001
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#include <stdio.h>
#include <unistd.h>
#include <getopt.h>
#include <stdlib.h>

#include <linux/h3600_ts.h>

#define CHUNK 8  /* Bytes to read at one time */

void fill_buffer( int fd, char *buf, int len )
{
	int i;
	struct h3600_eeprom_read_request request;

	for ( i = 0 ; i < len; i += CHUNK ) {
		request.len = CHUNK / 2;
		request.addr = i / 2;
		if ( ioctl( fd, READ_EEPROM, &request ) ) {
			perror("Problem reading EEPROM from Atmel\n");
			exit(-1);
		}
		memcpy( buf + i, request.buff, CHUNK );
	}
}

void write_buffer( int fd, char *buf, int len )
{
	int bytes_written = 0;
	int result;
	
	while ( bytes_written < len ) {
		result = write( fd, buf + bytes_written, len - bytes_written );
		if ( result <= 0 ) {
			perror("Unable to write to buffer\n");
			exit(-1);
		}
		bytes_written += result;
	}
}

void usage( void )
{
	fprintf(stderr,"Usage: eegrab\n");
	exit(1);
}

#define BUFFER_SIZE  512

int main( int argc, char **argv )
{
	int  fd = 0;
	unsigned char buf[ BUFFER_SIZE ];

	if ( argc != 1 )
		usage();

	fd = open("/dev/h3600_ts", O_RDONLY);
	if ( fd < 0 ) {
		perror("Unable to open the touchscreen driver\n");
		exit(-1);
	}

	fill_buffer( fd, (unsigned char *) buf, BUFFER_SIZE );
	write_buffer( 1, (unsigned char *) buf, BUFFER_SIZE );

	close(fd);
	return 0;
}

