/*
 * EEPROM programming software for iPAQ H3600
 *
 * Copyright 2001 Compaq Computer Corporation.
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 * Author: Andrew Christian 
 *         <andrew.christian@compaq.com>
 *         22 June 2001
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#include <stdio.h>
#include <unistd.h>
#include <getopt.h>
#include <stdlib.h>

#include <linux/h3600_ts.h>

#define CHUNK 4

void fill_buffer( int fd, char *buf, int len )
{
	int i;
	struct h3600_spi_read_request request;

	for ( i = 0 ; i < len ; i += CHUNK ) {
		request.len = CHUNK;
		request.addr = i;
		if ( ioctl( fd, READ_SPI, &request ) ) {
			perror("Problem reading SPI\n");
			exit(-1);
		}
		memcpy( buf + i, request.buff, CHUNK );
	}
}

void write_buffer( int fd, char *buf, int len )
{
	int bytes_written = 0;
	int result;
	
	while ( bytes_written < len ) {
		result = write( fd, buf + bytes_written, len - bytes_written );
		if ( result <= 0 ) {
			perror("Unable to write to buffer\n");
			exit(-1);
		}
		bytes_written += result;
	}
}

void usage( void )
{
	fprintf(stderr,"Usage: eegrab\n");
	exit(1);
}

#define BUFFER_SIZE  256

int main( int argc, char **argv )
{
	int  fd = 0;
	char buf[ BUFFER_SIZE ];
	int  len;

	if ( argc != 1 )
		usage();

	fd = open("/dev/h3600_ts", O_RDONLY);
	if ( fd < 0 ) {
		perror("Unable to open the touchscreen driver\n");
		exit(-1);
	}

	fill_buffer( fd, buf, BUFFER_SIZE );
	len = buf[1] + 256 * buf[2] + 1;
	if ( len > BUFFER_SIZE )
		len = BUFFER_SIZE;
	write_buffer( 1, buf, len );

	close(fd);
	return 0;
}

