/*
 * EEPROM programming software for iPAQ H3600
 *
 * Copyright 2001 Compaq Computer Corporation.
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 * Author: Andrew Christian 
 *         <andrew.christian@compaq.com>
 *         22 June 2001
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#include <stdio.h>
#include <unistd.h>
#include <getopt.h>
#include <stdlib.h>

#include <linux/h3600_ts.h>

int fill_buffer( int fd, char *buf, int max_len )
{
	int bytes_read = 0;
	
	while ( bytes_read < max_len ) {
		int result = read( fd, buf, max_len - bytes_read );
		if ( result == 0 )
			return bytes_read;
		
		if ( result < 0 ) {
			perror("Unable to read from file");
			return result;
		}
		buf += result;
		bytes_read += result;
	}
	fprintf(stderr,"Ran out of buffer space\n");
	return -1;
}


	
void usage( void )
{
	fprintf(stderr,"Usage: eeprogram [FILENAME]\n");
	fprintf(stderr,"Programs the EEPROM on a iPAQ sleeve.  If FILENAME is omitted,\n");
	fprintf(stderr,"program data is read from stdin.\n\n");
	exit(1);
}

#define BUFFER_SIZE  2048

#define CHUNK 4

int main( int argc, char **argv )
{
	int  fd = 0;
	char buf[BUFFER_SIZE];
	int  len = 4;
	int i, j;
	int addr = strtoul(argv[1], 0, 0);
	*(long *)&buf[0] = strtoul(argv[2], 0, 0);

	/* Program the device */
	if ( (fd = open("/dev/h3600_ts", O_WRONLY)) < 0 ) {
		perror("Unable to open the touchscreen driver");
		return 1;
	}

	for ( i = 0 ; i < len ; i += CHUNK ) {
		struct h3600_spi_write_request request;
		request.len = ( len - i > CHUNK ? CHUNK : len - i );
		request.addr = addr;
		memcpy( request.buff, &buf[i], request.len );
		printf("Writing to EEPROM address 0x%04x: ", request.addr);
		for ( j = 0 ; j < request.len ; j++ )
			printf(" %02x", request.buff[j]);
		printf("\n");
		       
		if ( ioctl( fd, WRITE_SPI, &request ) ) {
			perror("Failed to write!\n");
			return 1;
		}
	}

	close(fd);
	printf("Wrote %d bytes\n", len );
	return 1;
}

