/*
 * Itsy Utility Routines
 * Simple Resizable Array
 *
 * Copyright (c) Compaq Computer Corporation, 1996,1997,1998,1999
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 */

/*
 * Itsy Utility Routines
 * Simple Resizable Array
 *
 * Modified version of DCPI "util/array.h", Revision 1.6.
 * Original code written by Sanjay Ghemawat.
 *
 * $Log: array.h,v $
 * Revision 1.1.1.1  2000/11/28 16:46:34  kerr
 * Compaq Profiling Infrastructure
 *
 * Revision 1.3  1999/08/13  23:09:12  caw
 * Updated header comments.
 *
 * Revision 1.2  1998/10/29 18:41:31  caw
 * Updated comments with explicit credit for Sanjay.
 *
 * Revision 1.1  1998/10/28  02:22:46  kerr
 * Made utility directory, libraries, include, etc and changed apps to use it.
 *
 * Revision 1.1  1998/03/07  03:54:23  caw
 * Initial revision.
 *
 */

/* A very simple generic and dynamically resizable array */

#ifndef _ARRAY_H
#define _ARRAY_H

/* Example usage:
	typedef ARRAY(int) intlist;

	intlist b;
	int i = b.length;
	int* x = b.list;
	array_init(&b, 100);
	array_enlarge(&b, n);
	array_append(&b, x);
	array_shrink(&b, b.length);
	array_destroy(&b);
*/

/* extern void array_init(ARRAY(T)* array, int n);
   requires	"n" >= 0
   modifies	"*array"
   effects	Initializes "*array" to point to an array that
		has current length 0, and allocated space at least
		for "n" elements. */

/* extern void array_destroy(ARRAY(T)* array);
   requires	"array" has been initialized
   modifies	"*array"
   effects	Releases all resources occupied by the specified array. */

/* extern void array_enlarge(ARRAY(T)* array, int n);
   requires	"n >= 0"
   effects	Enlarges the current length of the array by "n".
		(Increases the allocated space if necessary.) */

/* extern void array_append(ARRAY(T)* array, T element);
   effects	Enlarges the current length of the array by 1,
		and stores "element" in the new slot.
		(Increases the allocated space if necessary.) */

/* extern void array_shrink(ARRAY(T*) array, int n);
   requires	"0 <= n <= array->length"
   effects	Reduces the current length of the array by "n". */

#define ARRAY(T) struct { int length, alloc; T* list; }
typedef ARRAY(void) _array;

extern void _array_init(_array* x, int init, size_t esize);
extern void _array_destroy(_array* x);
extern void _array_enlarge(_array* x, int n, size_t esize);

/* Implementation */

#define array_init(x,n) _array_init((_array*)(x),(n),sizeof((x)->list[0]))
#define array_destroy(x) _array_destroy((_array*)(x));

#define array_enlarge(x,n)					\
do {								\
    _array* _base = (_array*)(x);				\
    int _n = (n);						\
    if ((_base->length + _n) > _base->alloc) {			\
	_array_enlarge(_base, _n, sizeof((x)->list[0]));	\
    }								\
    _base->length += _n;					\
} while (0)

#define array_append(x,v)			\
do {						\
    array_enlarge((x), 1);			\
    (x)->list[(x)->length-1] = (v);		\
} while(0)

#define array_shrink(x,n) ((x)->length -= (n))

/* remove element at index i, replace with last element */
#define array_swap_last_shrink(a, i)			\
do {							\
  (a)->list[(i)] = (a)->list[(a)->length - 1];		\
  array_shrink((a), 1);					\
} while(0)

#endif /* _ARRAY_H */
