/*
 * Itsy Utility Routines
 * Generic Sorting Code
 *
 * Copyright (c) Compaq Computer Corporation, 1998,1999
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 */

/*
 * Itsy Utility Routines
 * Generic Sorting Code
 *
 * Modified version of DCPI "util/gensort.h", Revision 1.2.
 * Original code written by Sanjay Ghemawat.
 *
 * $Log: gensort.h,v $
 * Revision 1.1.1.1  2000/11/28 16:46:34  kerr
 * Compaq Profiling Infrastructure
 *
 * Revision 1.1  1999/08/13  23:07:24  caw
 * Initial revision (from DCPI sources).
 *
 */

/* Generic sorting code

Include this file after defining the following macros

	SORTER		Name of sorting procedure
	ELEMENT		Element type
	SORTER_PRIVATE	Define iff routine should be static
	ELEMENT_LT	Returns true iff 1st arg < 2nd arg

This file will generate a sorting routine named "SORTER" with the
following signature:

    void SORTER(ELEMENT*, unsigned long)

The routine is static iff SORTER_PRIVATE is defined.
*/

#ifndef SORTER
#error SORTER macro not defined before including gensort.h
#endif

#ifndef ELEMENT
#error ELEMENT macro not defined before including gensort.h
#endif

#ifndef ELEMENT_LT
#error ELEMENT_LT macro not defined before including gensort.h
#endif

#define SFUNC(x)	SFUNC_aux1(SORTER,x)
#define SFUNC_aux1(a,b)	SFUNC_aux2(a,b)
#define SFUNC_aux2(a,b)	a##_##b

/* Insertion sort */
static void SFUNC(insertion_sort)(ELEMENT* v, unsigned long n) {
    unsigned long i, j;
    for (i = 1; i < n; i++) {
	ELEMENT item = v[i];
	for (j = i; (j > 0) && ELEMENT_LT(item, v[j-1]); j--) {
	    v[j] = v[j-1];
	}
	v[j] = item;
    }
}

/* Quick sort (this code has been cribbed from CLR.) */

static unsigned long SFUNC(median)(ELEMENT* v,
				   unsigned long first,
				   unsigned long mid,
				   unsigned long last)
{
    unsigned long c1, c2, c3;
    
    /* Pick median of first, last, mid elements */
    c1 = ELEMENT_LT(v[first], v[mid]);
    c2 = ELEMENT_LT(v[mid], v[last]);
    if (c1 == c2) return mid;
    c3 = ELEMENT_LT(v[first], v[last]);
    if (c1 == c3) return last;
    return first;
}

static unsigned long SFUNC(pick_pivot)(ELEMENT* v,
				       unsigned long first, unsigned long last)
{
    unsigned long n = last - first + 1;
    unsigned long mid = (first + last) >> 1;
    if (n > 40) {
	/* Pick median of medians */
        unsigned long s = n / 8;
	unsigned long m1 = SFUNC(median)(v, first, first+s, first+2*s);
	unsigned long m2 = SFUNC(median)(v, mid-s, mid, mid+s);
	unsigned long m3 = SFUNC(median)(v, last-2*s, last-s, last);
	return SFUNC(median)(v, m1, m2, m3);
    } else {
	return SFUNC(median)(v, first, mid, last);
    }
}

static unsigned long SFUNC(partition)(ELEMENT* v,
				      unsigned long first, unsigned long last)
{
    unsigned long pivot, i, j;
    ELEMENT p;
    ELEMENT tmp;

    /* Pick pivot element and swap with first element */
    pivot = SFUNC(pick_pivot)(v, first, last);
    tmp = v[first]; v[first] = v[pivot]; v[pivot] = tmp;

    p = v[first];
    i = first - 1;
    j = last + 1;
    while (1) {
	do { j--; } while (ELEMENT_LT(p, v[j]));
	do { i++; } while (ELEMENT_LT(v[i], p));
	if (i >= j) return j;
	tmp = v[i]; v[i] = v[j]; v[j] = tmp;
    }
}

static void SFUNC(inner)(ELEMENT* v, unsigned long first, unsigned long last) {
    /* 1. Switch to insertion sort for small arrays
       2. Recurse on smaller sub-array to guarantee lg(n) stack use */
    while ((last - first) > 16) {
	unsigned long q = SFUNC(partition)(v, first, last);
	if ((q - first + 1) < (last - q)) {
	    SFUNC(inner)(v, first, q);
	    first = q + 1;
	} else {
	    SFUNC(inner)(v, q + 1, last);
	    last = q;
	}
    }
    SFUNC(insertion_sort)(v + first, last - first + 1);
}

#ifdef SORTER_PRIVATE
static
#endif
void SORTER(ELEMENT* v, unsigned long n) {
    if (n > 0) {
	SFUNC(inner)(v, 0, n-1);
    }
}

#undef SORTER
#undef ELEMENT
#undef ELEMENT_LT
#undef SFUNC
#undef SORTER_PRIVATE

/* Undef for backwards compatibility */
#undef PICK_MEDIAN
