/*
 * Itsy Utility Routines
 * Generic Hash Table Header
 *
 * Copyright (c) Compaq Computer Corporation, 1996,1997,1998,1999
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 */

/*
 * Itsy Utility Routines
 * Generic Hash Table Header
 *
 * Modified version of DCPI "util/htable.h", Revision 1.8.
 * Original code written by Sanjay Ghemawat and Carl Waldspurger.
 *
 * $Log: htable.h,v $
 * Revision 1.1.1.1  2000/11/28 16:46:34  kerr
 * Compaq Profiling Infrastructure
 *
 * Revision 1.1  1999/08/13  23:26:57  caw
 * Initial revision (from DCPI sources).
 *
 */

/*
 * ensure template instantiation macros defined
 *
 */

/* mandatory */
#ifndef	HTABLE
#error instantiation requires undefined macro HTABLE
#endif	/* HTABLE */
#ifndef	ELEMENT
#error instantiation requires undefined macro ELEMENT
#endif	/* ELEMENT */
#ifndef ELEMENT_MARK_EMPTY
#error instantiation requires undefined macro ELEMENT_MARK_EMPTY
#endif	/* ELEMENT_MARK_EMPTY */
#ifndef ELEMENT_IS_EMPTY
#error instantiation requires undefined macro ELEMENT_IS_EMPTY
#endif	/* ELEMENT_IS_EMPTY */
#ifndef ELEMENT_MARK_DELETED
#error instantiation requires undefined macro ELEMENT_MARK_EMPTY
#endif	/* ELEMENT_MARK_DELETED */
#ifndef ELEMENT_IS_DELETED
#error instantiation requires undefined macro ELEMENT_IS_EMPTY
#endif	/* ELEMENT_IS_DELETED */

/* optional: ELEMENT_HASH, ELEMENT_KEY_EQUAL */

/*
 * derived template instantiation macros
 *
 */

#ifndef	HCONCAT
#define	HCONCAT_PRIM(x, y)	x ## y
#define	HCONCAT(x, y)		HCONCAT_PRIM(x, y)

#define	HFUN(op)		HCONCAT(HTABLE, HCONCAT(_, op))
#define	HTYPE(t)		HCONCAT(HTABLE, HCONCAT(_, t))
#define	HTABLEGEN		HCONCAT(HTABLE, _gen)
#define	HGENFUN(op)		HCONCAT(HTABLE, HCONCAT(_gen_, op))
#endif	/* HCONCAT */


/*
Hash table:

A hash table is an associative collection of ELEMENTs.

Two ELEMENT routines may be supplied as macros or at creation time:
    1. ELEMENT_HASH      or  unsigned int (*hasher)(ELEMENT) 
    2. ELEMENT_KEY_EQUAL or int (*equal)(ELEMENT, ELEMENT)
*/

typedef /*@abstract@*/ struct HTABLE HTABLE;
typedef unsigned int (*HTYPE(hasher))(ELEMENT);
typedef int (*HTYPE(comparer))(ELEMENT, ELEMENT);

extern void HFUN(init)(HTABLE* h
#ifndef	ELEMENT_HASH
		       , HTYPE(hasher) hash
#endif	/* ELEMENT_HASH */
#ifndef	ELEMENT_KEY_EQUAL
		       , HTYPE(comparer) key_equal
#endif	/* ELEMENT_KEY_EQUAL */
);
/* modifies	"h"
   effects	Initializes "h" to an empty hash table. */

extern void HFUN(destroy)(HTABLE* h);
/* effects	Removes all storage associated with the table. */

extern void HFUN(copy)(HTABLE* dst, HTABLE* src);
extern void HFUN(clear)(HTABLE* h);
extern int  HFUN(size)(HTABLE* h);

extern ELEMENT HFUN(find)(HTABLE* h, ELEMENT key);
/* effects	If "h" contains an entry that matches "key", return
		that entry.  Else return NULL. */

extern ELEMENT HFUN(try_insert)(HTABLE* h, ELEMENT key);
/* effects	If "h" contains an entry that matches "key", return
		that entry.  Else insert "key" into "h" and return "key". */

extern ELEMENT HFUN(insert)(HTABLE* h, ELEMENT key);
/* effects	Insert "key" into "h".  If "h" already contained
		an entry that matched "key", return that old
		entry, else return NULL. */

extern ELEMENT HFUN(remove)(HTABLE* h, ELEMENT key);
/* effects	If "h" contains an entry that matches "key", remove and
		return that entry.  Else return NULL. */

extern void HFUN(predict)(HTABLE* h, int n);
/* effects	Resizes the table to an appropriate size for "n"
		elements.  The contents of the table are not changed.
		If "h" contains more than "n" elements, no elements
		will be lost. */

extern void HFUN(shrink)(HTABLE* h);
/* effects	Resizes hash table h to an appropriate size for 
		the current number of elements that it contains.  */

extern void HFUN(reset)(HTABLE* h);
/* effects	Resets h to an empty hash table, discarding any
		existing elements that it contains. */

/* Hash table element generator.  Any modification to the underlying
   hash table (except via the generator methods) invalidates the
   generator state. */

typedef /*@abstract@*/ struct HTABLEGEN HTABLEGEN;

extern void HGENFUN(init)(HTABLEGEN* g, HTABLE* h);
/* effects	Initializes "g" to generate all of the elements of "h". */

extern ELEMENT HGENFUN(next)(HTABLEGEN* g);
/* effects	Returns the next element.  Returns EMPTY element if at end. */

extern void HGENFUN(remove_element)(HTABLEGEN* g);
/* requires	An element was yielded and has not been removed.
   effects	Removes the element from the hash table. */

extern void HGENFUN(replace_element)(HTABLEGEN* g, ELEMENT x);
/* requires	An element was yielded and has not been removed.
		"x" is equal to this yielded element and has the
		same hash value.
   effects	Replaces the yielded value with "x" in the hash table. */

extern void HFUN(check)(HTABLE*);
extern void HFUN(stats)(HTABLE*, char* msg);

/* The following structures are exposed to allow stack allocation.
   None of the fields of these structures should be accessed by
   any client code. */

struct HTABLE {
#ifndef	ELEMENT_HASH
  HTYPE(hasher) hash;		/* hash function (if not macro) */
#endif	/* ELEMENT_HASH */
#ifndef	ELEMENT_KEY_EQUAL
  HTYPE(comparer) key_equal;	/* key equality (if not macro) */
#endif	/* ELEMENT_KEY_EQUAL */
  
  ELEMENT*     table;		/* List of entries */
  unsigned int tsize;		/* Table size (power of two) */
  unsigned int slot_bits;	/* lg(tsize) */
  unsigned int count;		/* Number of present entries */
  unsigned int delcount;	/* Number of deleted entries */
  unsigned int enlarge_size;	/* Enlarge threshold */

#ifndef NDEBUG
  /* stats */
  unsigned int probes;		/* Total probes in table */
  unsigned int searches;	/* Total searches */
#endif	/* NDEBUG */
};

struct HTABLEGEN {
  HTABLE* h;
  int index;
};

/*
 * remove template instantiation macros
 *
 */

#ifndef	HTABLE_INSTANTIATE_IMPL
#undef	HTABLE
#undef	ELEMENT
#undef	ELEMENT_MARK_EMPTY
#undef	ELEMENT_IS_EMPTY
#undef	ELEMENT_MARK_DELETED
#undef	ELEMENT_IS_DELETED
#undef	ELEMENT_HASH
#undef	ELEMENT_KEY_EQUAL
#endif	/* HTABLE_INSTANTIATE_IMPL */
