/*
 * Itsy Utility Routines
 * Generic Hash Table of Pointers Header
 *
 * Copyright (c) Compaq Computer Corporation, 1996,1997,1998,1999
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 */

/*
 * Itsy Utility Routines
 * Generic Hash Table of Pointers Header
 *
 * Modified version of DCPI "util/htable_generic.h", Revision 1.3.
 * Original code written by Sanjay Ghemawat and Carl Waldspurger.
 *
 * $Log: htable_generic.h,v $
 * Revision 1.1.1.1  2000/11/28 16:46:34  kerr
 * Compaq Profiling Infrastructure
 *
 * Revision 1.1  1999/08/13  23:38:57  caw
 * Initial revision (from DCPI sources).
 *
 */

/* 
 * template parameters for instantiating a
 *   hash table of generic pointers (void*)
 *
 */

#ifndef	_HTABLE_GENERIC_H
#define	_HTABLE_GENERIC_H

#define	HTABLE	htable_generic
#define	ELEMENT	void*

#define	ELEMENT_IS_EMPTY(h, elt)	((elt) == NULL)
#define	ELEMENT_MARK_EMPTY(h, eltp)	(*(eltp) = NULL)

#define	ELEMENT_IS_DELETED(h, elt)	((elt) == ((void*) (h)))
#define	ELEMENT_MARK_DELETED(h, eltp)	(*(eltp) = ((void*) (h)))

#include <util/htable.h>

#endif	/* _HTABLE_GENERIC_H */
