/*
 * Itsy Utility Routines
 * Linked list utilities. Derived from itsy_util.h
 *
 * Copyright (c) Compaq Computer Corporation, 1999
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 */

/*
 * Author: Carl Waldspurger
 *
 * $Log: list.h,v $
 * Revision 1.1.1.1  2000/11/28 16:46:34  kerr
 * Compaq Profiling Infrastructure
 *
 * Revision 1.2  1999/05/12  18:09:01  caw
 * Included changes from itsy_sessions branch.
 *
 * Revision 1.1.2.2  1999/04/30  20:51:41  brakmo
 * Fixed missing ')' in OBJ_ALLOC.
 *
 * Revision 1.1.2.1  1999/04/28 20:19:06  brakmo
 * Functions to manipulate lists (copied from Carl).
 *
 *
 */

#ifndef	ITSY_LIST_H
#define	ITSY_LIST_H

/*
 * useful macros
 *
 */

#ifndef	MIN
#define MIN(a,b)                (((a)<(b))?(a):(b))
#define MAX(a,b)                (((a)>(b))?(a):(b))
#endif

#ifndef OBJ_ALLOC
#define	OBJ_ALLOC(obj)		((obj *) malloc(sizeof(obj)))
#define	OBJ_INIT(x, obj)	(memset((void *) (x), 0, sizeof(obj)))
#define	OBJ_DEALLOC(x, obj)	(free((void *) x))
#endif

#ifndef SAFE_STRING
#define	SAFE_STRING(s)		(((s) != NULL) ? (s) : "")
#endif

/*
 * generic list operation macros 
 *
 */

#define	INSTANTIATE_LIST_LOOKUP(ELT)			\
static ELT * ELT ## _lookup(ELT *head, int id)		\
{							\
  ELT *e;						\
							\
  /* search element list for matching id */		\
  for (e = head; e != NULL; e = e->next)		\
    if (e->id == id)					\
      return(e);					\
							\
  /* not found */					\
  return(NULL);						\
}

#define	INSTANTIATE_LIST_INSERT(ELT)			\
static void ELT ## _insert(ELT **head, ELT *e)		\
{							\
  ELT *h = *head;					\
							\
  /* add element to head of list */			\
  e->next = h;						\
  if (h != NULL)					\
    h->prev = e;					\
  *head = e;						\
  e->prev = NULL;					\
}

#define	INSTANTIATE_LIST_REMOVE(ELT)			\
static void ELT ## _remove(ELT **head, ELT *e)		\
{							\
  /* splice element out of list */		  	\
  if (e->prev != NULL)					\
    e->prev->next = e->next;				\
  else							\
    *head = e->next;					\
  if (e->next != NULL)					\
    e->next->prev = e->prev;				\
}

#endif	/* ITSY_LIST_H */
