/*
 * Itsy Utility Routines
 * Simple Logging Operations Header
 *
 * Copyright (c) Compaq Computer Corporation, 1999
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 */
/*
 * Author: Carl Waldspurger
 *
 * $Log: log.h,v $
 * Revision 1.1.1.1  2000/11/28 16:46:34  kerr
 * Compaq Profiling Infrastructure
 *
 * Revision 1.2  1999/02/26  20:05:46  caw
 * Defined log_set_stream() prototype.
 *
 * Revision 1.1  1999/01/22  22:55:20  caw
 * Initial revision.
 *
 */

#ifndef	_LOG_H
#define	_LOG_H

/*
 * operations
 *
 */

extern void log_set_name(const char *name);
extern void log_set_verbose(int enable);
extern void log_set_stream(FILE *stream);

extern void fatal(const char *format, ...);
extern void warning(const char *format, ...);
extern void log_verbose(const char *format, ...);

#endif	/* _LOG_H */
