/*
 * Itsy Utility Routines
 * Utility Header File
 *
 * Copyright (c) Compaq Computer Corporation, 1998
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 */
/*
 * Utility Header File
 * Author: Carl Waldspurger
 *
 * $Log: util.h,v $
 * Revision 1.1.1.1  2000/11/28 16:46:34  kerr
 * Compaq Profiling Infrastructure
 *
 * Revision 1.1  1998/10/28 02:22:46  kerr
 * Made utiltily directory, libraries, include, etc and changed apps to use it.
 *
 * Revision 2.0  1998/06/24  21:32:10  kramer
 * Major Bump: Move all version numbers up to 2.0 for external release.
 * -drew
 *
 * Revision 1.4  1998/06/16  19:18:52  kramer
 * Added copyright information
 *
 * Revision 1.3  1998/03/09  00:35:27  caw
 * Added storage allocation macros.
 *
 * Revision 1.2  1998/02/24  23:04:00  caw
 * Added MIN/MAX macros.
 *
 * Revision 1.1  1998/02/18  03:08:55  caw
 * Initial revision.
 *
 */

#ifndef	_UTIL_H
#define	_UTIL_H

/*
 * includes
 *
 */

#include <string.h>

/*
 * constants
 *
 */

#define	SUCCESS			(0)
#define	FAILURE			(-1)

/*
 * macros
 *
 */

/* numbers */
#ifndef MIN
#define MIN(a,b)                (((a)<(b))?(a):(b))
#define MAX(a,b)                (((a)>(b))?(a):(b))
#endif

/* storage allocation */
#define ALLOC_NEW(obj)		((obj *) malloc(sizeof(obj)))
#define	ALLOC_ARRAY(obj,n)	((obj *) malloc((n) * sizeof(obj)))

/* strings */
#define	STRING_EQUAL(s1,s2)	(strcmp((s1),(s2)) == 0)
#define	STRING_MATCH(s1,s2)	(strcasecmp((s1),(s2)) == 0)
#define	STRING_PREFIX(s1,s2)	(strncasecmp((s1),(s2),strlen(s2)) == 0)
#define	STRING_LENGTH(s)	(strlen(s))
#define	STRING_COPY(s1,s2)	(strcpy((s1),(s2)))
#define	STRING_EMPTY(s)		(((s) == NULL) || ((*s) == '\0'))

#endif	/* _UTIL_H */
