#!/usr/local/bin/python2.1

import MySQLdb

profiles_by_id = {}
profiles = {}

class profile:
    def __init__(self, userid, login_name, realname):
        global profiles, profiles_by_id
        self.userid = userid
        self.login_name = login_name
        self.realname = realname
        profiles[login_name] = self
        profiles_by_id[userid] = self
        return

products = {}
components = {}
versions = {}

class product:
    def __init__(self, name, description):
        self.name = name
        self.description = description
        products[name] = self
        return

class component:
    def __init__(self, name, product, initialowner, initialqacontact, description):
        global components
        self.name = name
        self.product = product
        self.initialowner = initialowner
        self.initialqacontact = initialqacontact
        self.description = description
        components[name] = self
        return

class version:
    def __init__(self, number, product):
        self.version = number
        self.product = product
        return

class Bugzilladb:
    def __init__(self):
        return

    def connect(self, host, port, passwd):
        self.db = MySQLdb.connect(db='bugs', host=host, port=port, user='bugs', passwd=passwd)
        self.cursor = self.db.cursor()
        return

    def connect_unix(self, passwd):
        self.db = MySQLdb.connect(db='bugs', user='bugs', passwd=passwd)
        self.cursor = self.db.cursor()
        return

    def lookup_profile(self, email):
        if profiles.has_key(email):
            return profiles[email]
        else:
            self.cursor.execute("select userid, login_name, realname from profiles where login_name='%s'" % (email, ))
            result = self.cursor.fetchone()
            if result:
                return profile(result[0], result[1], result[2])
            else:
                return None

    def lookup_profile_by_id(self, id):
        if profiles_by_id.has_key(id):
            return profiles_by_id[id]
        else:
            self.cursor.execute("select userid, login_name, realname from profiles where userid='%s'" % (id, ))
            result = self.cursor.fetchone()
            if result:
                return profile(result[0], result[1], result[2])
            else:
                return None

    def lookup_product(self, name):
        if products.has_key(name):
            return products[name]
        else:
            self.cursor.execute("select * from products where product='%s'" % (name,))
            result = self.cursor.fetchone()
            if result:
                return product(result[0], result[1])
            else:
                return None

    def lookup_component(self, product, name):
        if components.has_key(name):
            return components[name]
        else:
            self.cursor.execute("select * from components where value='%s'" % (name,))
            result = self.cursor.fetchone()
            if result:
                name = result[0]
                program = result[1]
                initialownerid = result[2]
                initialqacontact = result[3]
                description = result[4]
                return component(name, program, self.lookup_profile_by_id(initialownerid), self.lookup_profile_by_id(initialqacontact), description)
            else:
                return None

    def add_component(self, product, name, initialowneremail, description):
        initialowner = self.lookup_profile(initialowneremail)
        initialownerid = initialowner.userid
        print 'add_component product=%s name=%s initialownerid=%s' % (product, name, initialownerid)
        sql = "insert into components (value, program, initialowner, description) values ('%s', '%s', '%s', '%s')" \
                            % (name, product, initialownerid, description)
        r = self.cursor.execute(sql)
        return

    def update_component_product(self, component, product):
        oldproduct = component.product
        # move the component into the right product
        sql = ("update components set program='%s' where value='%s'" % (product, component.name))
        r = self.cursor.execute(sql)
        # fixup all the bugs on this component
        sql = ("update bugs set product='%s' where product='%s' and component='%s'" % (product, oldproduct, component.name))  
        r = self.cursor.execute(sql)
        component.product = product


    def lookup_version(self, product, number):
        self.cursor.execute("select * from versions where program='%s' and value='%s'" % (product, number,))
        result = self.cursor.fetchone()
        if result:
            return version(result[0], result[1])
        else:
            return None

    def add_version(self, product, number):
        self.cursor.execute("insert into versions (value, program) values ('%s', '%s')" % (number, product))
        return

if (__name__ == '__main__'):
    bugs = Bugzilladb()
    print bugs
    print bugs.lookup_profile('jamey@handhelds.org')
    print bugs.lookup_product('kernel') 
    print bugs.lookup_component('kernel', 'pcmcia') 
    print bugs.lookup_version('kernel', '2.4.16-rmk1') 
