#!/usr/bin/python

import sys
import ipkg
import MySQLdb
import bugzilla
import re

maintainer_email_re = re.compile("(.*)<(.*)>")
maintainer_email_alt_re = re.compile("(.*)\((.*)\)")

oneline_re = re.compile("([^\n]+)\n")
kernel_re = re.compile("(.*)-modules-(2[.]4.*)")
quote_re = re.compile("'")

maintainer_aliases = {}
maintainer_aliases['a7r@handhelds.org'] = 'a7r@andern.org' 
maintainer_aliases['bflong@handhelds.org'] = 'bflong@longbros.com'
maintainer_aliases['bflong@seseco.com'] = 'bflong@longbros.com'
maintainer_aliases['cworth@handhelds.org'] = 'cworth@east.isi.edu' 
maintainer_aliases['dctanner@magenet.com'] = 'dctanner@xoasis.com' 
maintainer_aliases['jamey.hicks@compaq.com'] = 'jamey@handhelds.org' 
maintainer_aliases['nelson@crynwr.com'] = 'nelson@handhelds.org' 
maintainer_aliases['steven.ayer@compaq.com'] = 'ayer@crl.dec.com' 
maintainer_aliases['David McNab, david@rebirthing.co.nz'] = 'david@rebirthing.co.nz' 
maintainer_aliases['Familiar User'] = 'jrb@cs.pdx.edu'

def maintainer_email(maintainer):
    m = maintainer_email_re.match(maintainer)
    if not m:
        m = maintainer_email_alt_re.match(maintainer)
    if m:
        maintainer = m.group(2)
    if maintainer_aliases.has_key(maintainer):
        maintainer = maintainer_aliases[maintainer]
    return maintainer

def fixup_description(long_description):
    description = long_description
    m = oneline_re.match(pkg.description)
    if m:
        description = m.group(0)
    description = re.sub("'", "", description)
    return description

if (__name__ == '__main__'):
    password = sys.argv[1]
    bugs = bugzilla.Bugzilladb()
    bugs.connect_unix(password)
    for pkgfile in sys.argv[2:]:
        pkg = ipkg.Package(pkgfile)
        # print "%s ========================" % (pkgfile,)
        if not pkg.section:
            print "no section for pkg " + pkgfile
        if not pkg.package:
            print "no name for pkg " + pkgfile
            continue
        product = bugs.lookup_product(pkg.section)
        if not product:
            print "no product section in database for " + pkg.section
            continue
        pkgname = pkg.package
	pkgversion = pkg.version
        m = kernel_re.match(pkgname)
        if m:
            pkgname = m.group(1)
            pkgversion = m.group(2)
            # print "\t %s is kernel package (%s, %s)" % (pkg.package, pkgname, pkgversion)

        maintainer = pkg.maintainer
        email = maintainer_email(maintainer)
        if not email: 
            print "could not find email for " + pkgname + " maintainer=" + pkg.maintainer
            continue
        profile = bugs.lookup_profile(email)
        if not profile:
            print "could not find profile for " + email + " for package " + pkgfile
            continue
        component = bugs.lookup_component(pkg.section, pkgname)
        description = fixup_description(pkg.description)
        if not component:
            print "adding component %s" % (pkgname,)
            bugs.add_component(pkg.section, pkgname, email, description)
        else:
            if pkg.section and component.product != pkg.section:
                print "need to update component=" + component.name + ' from section=' + component.product + ' to section=' + pkg.section 
                bugs.update_component_product(component, pkg.section)
	version = bugs.lookup_version(pkg.section, pkgversion)
        if not version:
            bugs.add_version(pkg.section, pkgversion)

