#!/usr/local/bin/python

import sys, os, cgi, commands, time
import re
import posixfile
import ConfigParser

config = '/etc/packman.conf'


feeds_base = '/home/jamey/feeds'
feeds_base = '/home/ftp/feeds'
cgi.logfile = '/tmp/upload'
tmp_dir = '/tmp'
update_package_list = 0
cp = ConfigParser.ConfigParser()
cp.read(config)
try:
    if cp.has_option('config', 'feeds_base'):
        feeds_base = cp.get('config', 'feeds_base')
    if cp.has_option('config', 'logfile'):
        cgi.logfile = cp.get('config', 'logfile')
    if cp.has_option('config', 'tmp_dir'):
        tmp_dir = cp.get('config', 'tmp_dir')
    if cp.has_option('config', 'update_index'):
        update_package_list = cp.get('config', 'update_index')
except:
    pass
cp = None

logprefix = time.strftime('%c') + ' -- '
try:
     for k in ['REMOTE_ADDR']:
          if (os.environ.has_key(k)):
               logprefix = logprefix + ('%s' % (os.environ[k],))
except:
     pass

def log(string):
     cgi.log(logprefix + ': ' + string)

def filename_is_valid(filename):
     if re.match(r'^[-._A-Za-z0-9]+$', filename): return 1
     return 0

def copy(srcfilename, dstfilename):
    srcfile = open(srcfilename, 'r')
    dstfile = open(dstfilename, 'w')
    while (1):
        str = srcfile.read(512)
        if (str):
            nbytes = dstfile.write(str)
        else:
            break
    dstfile.close()
    srcfile.close()

def make_index(feed_dir):
    os.chdir(feed_dir)
    f = posixfile.open(tmp_dir + "/Packages.lck", 'w')
    f.lock('w|')
    (rc, outtext) = commands.getstatusoutput('/usr/local/bin/ipkg-make-index . > /tmp/Packages')
    if (rc != 0):
        print ('<b>Failed to create Packages file with error=%s and output=%s</b>' % (rc,outtext)) 
    else:
        commands.getstatusoutput('mv /tmp/Packages Packages')
    f.lock('u')
    f.close()
    print '<b>Updated Packages</b>'	
    return

def update_index(feed_dir, pkgfilename):
    f = posixfile.open(tmp_dir + "/Packages.lck", 'w')
    f.lock('w|')
    (rc, outtext) = commands.getstatusoutput('ipkg-update-index %s %s' % (feed_dir, pkgfilename) )
    if (rc != 0):
        print ('<b>Failed to update Packages file with error=%s and output=%s</b>' % (rc,outtext)) 
    f.lock('u')
    f.close()
    print ('<b>added %s to Packages</b>' % (pkgfilename,))
    return

def handle_upload(feeditem, fileitem, sigfileitem, srcfileitem):
     global logprefix
     global update_package_list	
     
     feedname    = feeditem.value
     filename    = fileitem.filename
     sigfilename = sigfileitem.filename
     srcfilename = srcfileitem.filename

     if not filename_is_valid(feedname):
          print ('<b>%s</b> is an invalid filename\n' % (feedname,))
          log('invalid feedname %s' % (feedname,))
          return 0
     if not filename_is_valid(filename):
          print ('<b>%s</b> is an invalid filename\n' % (filename,))
          log('invalid filename %s' % (filename,))
          return 0
     if not filename_is_valid(sigfilename):
          print ('<b>%s</b> is an invalid filename\n' % (sigfilename,))
          log('invalid sigfilename %s' % (sigfilename,))
          return 0
     if srcfilename and not filename_is_valid(srcfilename):
          print ('<b>%s</b> is an invalid filename\n' % (srcfilename,))
	  log('invalid srcfilename %s' % (srcfilename,))
	  return 0
     if (filename == 'keyring.gpg' or sigfilename == 'keyring.gpg'):
         print '<b>not allowed to overwrite keyring</b>'
         return 0

     feed_dir = feeds_base + '/' + feedname + '/'
     tmp_dir = "/tmp/"
     file = open(tmp_dir + filename, 'w')
     file.write(fileitem.value)
     file.close()
     sigfile = open(tmp_dir + sigfilename, 'w')
     sigfile.write(sigfileitem.value)
     sigfile.close()
     
     if srcfilename:
          srcfile= open(tmp_dir + srcfilename, 'w')
          file.write(srcfileitem.value)
          file.close()
     keyringfile = feed_dir + 'keyring.gpg'
     try:
          (exitstatus, outtext) = commands.getstatusoutput("gpgv --keyring %s %s" % (keyringfile, tmp_dir + sigfilename))
     except:
          cgi.log('caught an exception')
          pass
     print '<pre>' + outtext + '</pre>'
     if (exitstatus != 0):
          log('gpgv %s %s exitstatus=%d' % (filename, sigfilename, exitstatus,)) 
          log('  ' + outtext)
     rc = exitstatus
     if (rc != 0):
         return 0
     rc = copy(tmp_dir + filename, feed_dir + filename)
     if (rc != 0):
         print ('<p>error %s copying %s to %s' % (rc, tmp_dir + filename, feed_dir + filename))
     os.unlink(tmp_dir + filename)
         
     rc = copy(tmp_dir + sigfilename, feed_dir + sigfilename)
     if (rc != 0):
         print ('<p>error %s copying %s to %s' % (rc, tmp_dir + sigfilename, feed_dir + sigfilename))
     os.unlink(tmp_dir + sigfilename)
     cgi.logfile = feed_dir + 'upload.log'	
     log('uploaded %s the package %s %s' % (feedname, filename, sigfilename))
     if srcfilename:
         rc = copy(tmp_dir + srcfilename, feed_dir + srcfilename)
         if (rc != 0):
             print ('<p>error %s copying %s to %s' % (rc, tmp_dir + sigfilename, feed_dir + sigfilename))
         os.unlink(tmp_dir + srcfilename)
         log('uploaded %s the source file %s' % (feedname, srcfilename))

     print "<p>Packages file now updated every 10 minutes by cron job</p>\n"
     # remove the tmp files
     return 1

def main():
    global update_package_list
    print "Content-type: text/html\n"
    form = cgi.FieldStorage()
    print '<html>'
    print '<head><title>Handhelds.Org Package Manager -- upload</title></head>'
    print '<body><h1>Handhelds.Org Package Manager -- upload</h1>'
    if form and form.has_key("filename") and form.has_key("signaturefilename") and form.has_key("sourcefilename"):
	 print '<ul>'
	 print '<li>'
	 print form["feedname"].value
	 print '<li>'
	 print form["filename"].filename
	 print '<li>'
         print form["signaturefilename"].filename
	 print '<li>'
         print form["sourcefilename"].filename
         print '</ul>'
         if form.has_key('update_index'):
             update_package_list = form["update_index"]
         if handle_upload(form["feedname"], form["filename"], form["signaturefilename"],form["sourcefilename"]):
              print '<p><b>Upload completed successfully</b>'
              print ('<p><a href="/feeds/%s/Packages">Updated Packages File</a>' % (form["feedname"].value, ))
         else:
              print '<p><b>Upload failed</b>'
    elif form and form.has_key("feedname") and form.has_key("update_index"):
       # feed_dir = feeds_base + '/' + form["feedname"].value + '/'
       # make_index(feed_dir)	
       print "Packages file now updated hourly by cron job at 11 after the hour\n"
    else:
       print """
       <h1>Signing Packages</h1>
       The following command will generate the file foo.ipk.asc, containing
       an ASCII signature of the package foo.ipk:
       <pre>
           gpg -sb --armor foo.ipk
       </pre>
       <p>

       See <a
       href="/pipermail/familiar/2001-December/003953.html">Jamey's
       announcement of this package upload utility</a> for some more
       details.

       <h1>Package to Upload</h1>
       <form action="/cgi-bin/upload-package.cgi" method="POST" enctype="multipart/form-data">
       <table>
       <tr><td>Feed Name <td><select name="feedname"><option selected>unstable</select></tr>
       <tr><td>Filename <td><input type="file" name="filename"></tr>
       <tr><td>OpenPGP Signature Filename <td> <input type="file" name="signaturefilename"></tr>
       <tr><td>Sources Filename - Optional <td> <input type="file" name="sourcefilename"></tr>
       </table> <input type="submit">
       </form>
"""
    print '</body>'
    print '</html>'

main()


