/*
 * Itsy SA1100 Profiling Applications
 *
 * Copyright (c) Compaq Computer Corporation, 1999
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 */

/* 
 * template parameters for instantiating a
 *   hash table of profd_sample
 *
 */

#ifndef	_HTABLE_SAMPLE_H
#define	_HTABLE_SAMPLE_H

#define	HTABLE	htable_sample
#define	ELEMENT	profd_sample

#define	HTABLE_SAMPLE_ELEMENT_IS_EMPTY(elt)		\
        (((elt).count == 0) && ((elt).offset == 0))
#define	HTABLE_SAMPLE_ELEMENT_MARK_EMPTY(eltp)		\
        ((eltp)->count = 0, (eltp)->offset = 0) 

#define	HTABLE_SAMPLE_ELEMENT_IS_DELETED(elt)		\
        (((elt).count == 0) && ((elt).offset == 1))
#define	HTABLE_SAMPLE_ELEMENT_MARK_DELETED(eltp)	\
        ((eltp)->count = 0, (eltp)->offset = 1) 

#define	HTABLE_SAMPLE_ELEMENT_HASH(elt)			\
        ((elt).offset)
#define	HTABLE_SAMPLE_ELEMENT_KEY_EQUAL(elt1, elt2)	\
	((elt1).offset == (elt2).offset)

#define	ELEMENT_IS_EMPTY(h, elt)	HTABLE_SAMPLE_ELEMENT_IS_EMPTY(elt)
#define	ELEMENT_MARK_EMPTY(h, eltp)	HTABLE_SAMPLE_ELEMENT_MARK_EMPTY(eltp)
#define	ELEMENT_IS_DELETED(h, elt)	HTABLE_SAMPLE_ELEMENT_IS_DELETED(elt)
#define	ELEMENT_MARK_DELETED(h, eltp)	HTABLE_SAMPLE_ELEMENT_MARK_DELETED(eltp)
#define	ELEMENT_HASH			HTABLE_SAMPLE_ELEMENT_HASH
#define	ELEMENT_KEY_EQUAL		HTABLE_SAMPLE_ELEMENT_KEY_EQUAL

#include <util/htable.h>

#endif	/* _HTABLE_SAMPLE_H */
