/*
 * Itsy SA1100 Profiling Applications: Image Id
 *
 * Copyright (c) Compaq Computer Corporation, 1999
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 */

/*
 * Author: Carl Waldspurger
 *
 * $Log: imageid.c,v $
 * Revision 1.1.1.1  2000/11/28 16:46:34  kerr
 * Compaq Profiling Infrastructure
 *
 * Revision 1.3  1999/08/24 22:07:22  caw
 * Report "INVALID" instead of "XBAD" or "BAD".
 *
 * Revision 1.2  1999/08/23 16:41:21  kerr
 * Added an 'X' so 'BAD' isn't interpreted as a legal hex number.
 *
 * Revision 1.1  1999/08/20  01:30:19  caw
 * Initial revision.
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>

#include <util/util.h>
#include "ihash.h"

/*
 * main program
 *
 */

static void usage(const char *program)
{
  (void) fprintf(stderr, "usage: %s <image>...\n", program);
  exit(EXIT_FAILURE);
}

int main(int argc, char **argv)
{
  int i;

  if (argc < 2)
    usage(argv[0]);

  for (i = 1; i < argc; i++)
    {
      char *name = argv[i];
      int hash;

      if (image_file_hash(name, &hash) != SUCCESS)
	(void) printf("%s: INVALID\n", name);
      else
	(void) printf("%s: %08x\n", name, hash);
    }

  /* everything OK */
  return(EXIT_SUCCESS);
}
