/*
 * Itsy SA1100 Profiling Applications: Itsy ARM Binaries
 *
 * Copyright (c) Compaq Computer Corporation, 1999
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 */

/*
 * This file is intended for building on ARM, x86, and Alpha platforms.
 * Definitions for extracting header information from ARM binaries.
 * Copied from Itsy Linux <linux/elf.h> and <linux/a.out.h>.
 *
 * $Log: itsyhdr.h,v $
 * Revision 1.1.1.1  2000/11/28 16:46:34  kerr
 * Compaq Profiling Infrastructure
 *
 * Revision 1.5  1999/08/27 17:35:15  caw
 * Updated documentation.
 *
 * Revision 1.4  1999/08/27 17:34:00  caw
 * Initial revision.
 *
 */

#ifndef	_ITSYHDR_H

/*
 * Integer types
 *
 */

#ifdef	__alpha
/* Alpha (64 bit native) */
typedef unsigned long u64;
typedef long i64;
typedef unsigned int u32;
typedef int i32;
typedef unsigned short u16;
typedef short i16;
#else
/* ARM or x86 (32 bit native) */
typedef unsigned long long u64;
typedef long long i64;
typedef unsigned int u32;
typedef int i32;
typedef unsigned short u16;
typedef short i16;
#endif	/* __alpha */

/*
 * ARM ELF header
 *
 */

typedef u32 Elf32_Addr;
typedef u16 Elf32_Half;
typedef u32 Elf32_Off;
typedef i32 Elf32_Sword;
typedef u32 Elf32_Word;

#define EI_NIDENT       16

typedef struct elf32_hdr{
  unsigned char	e_ident[EI_NIDENT];
  Elf32_Half	e_type;
  Elf32_Half	e_machine;
  Elf32_Word	e_version;
  Elf32_Addr	e_entry;  /* Entry point */
  Elf32_Off	e_phoff;
  Elf32_Off	e_shoff;
  Elf32_Word	e_flags;
  Elf32_Half	e_ehsize;
  Elf32_Half	e_phentsize;
  Elf32_Half	e_phnum;
  Elf32_Half	e_shentsize;
  Elf32_Half	e_shnum;
  Elf32_Half	e_shstrndx;
} Elf32_Ehdr;

typedef struct elf32_phdr{
  Elf32_Word	p_type;
  Elf32_Off	p_offset;
  Elf32_Addr	p_vaddr;
  Elf32_Addr	p_paddr;
  Elf32_Word	p_filesz;
  Elf32_Word	p_memsz;
  Elf32_Word	p_flags;
  Elf32_Word	p_align;
} Elf32_Phdr;

typedef struct {
  Elf32_Word    sh_name;
  Elf32_Word    sh_type;
  Elf32_Word    sh_flags;
  Elf32_Addr    sh_addr;
  Elf32_Off     sh_offset;
  Elf32_Word    sh_size;
  Elf32_Word    sh_link;
  Elf32_Word    sh_info;
  Elf32_Word    sh_addralign;
  Elf32_Word    sh_entsize;
} Elf32_Shdr;

/*
 * ARM a.out header
 *
 */

struct exec
{
  u32 a_info;	/* Use macros N_MAGIC, etc for access */
  u32 a_text;	/* length of text, in bytes */
  u32 a_data;	/* length of data, in bytes */
  u32 a_bss;	/* length of uninitialized data area for file, in bytes */
  u32 a_syms;	/* length of symbol table data in file, in bytes */
  u32 a_entry;  /* start address */
  u32 a_trsize; /* length of relocation info for text, in bytes */
  u32 a_drsize; /* length of relocation info for data, in bytes */
};

#define N_MAGIC(exec) ((exec).a_info & 0xffff)
#define OMAGIC 0407
#define NMAGIC 0410
#define ZMAGIC 0413
#define QMAGIC 0314

#define N_BADMAG(x)	  (N_MAGIC(x) != OMAGIC		\
			&& N_MAGIC(x) != NMAGIC		\
  			&& N_MAGIC(x) != ZMAGIC 	\
		        && N_MAGIC(x) != QMAGIC)

#endif	/* _ITSYHDR_H */
