/*
 * Itsy Profiler Test Driver
 *
 * Copyright (c) Compaq Computer Corporation, 1999
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 */

/*
 * Author: Carl Waldspurger
 *
 * $Log: testprof.c,v $
 * Revision 1.1.1.1  2000/11/28 16:46:34  kerr
 * Compaq Profiling Infrastructure
 *
 * Revision 1.3  1999/08/11  21:27:19  caw
 * Eliminated compiler warning.
 *
 * Revision 1.2  1999/08/11 18:07:34  caw
 * Reduced logging rate, improved output format.
 *
 * Revision 1.1  1999/08/11 17:53:43  caw
 * Initial revision.
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>

#include <linux/profiler.h>

#include <util/util.h>
#include <util/log.h>

/*
 * main program
 *
 */

#define	log	log_verbose

static void log_sample(const profiler_sample *s, const char *msg)
{
  log("%s %5d %04x:%05d %8lx %2x",
      (msg == NULL) ? "" : msg,
      s->pid, s->device, s->inode, s->offset, s->mode);
}

static void read_samples(int fd, const char *msg)
{
  profiler_sample samples[64];
  int nbytes, nsamples;

  nbytes   = read(fd, (void *) samples, sizeof(samples));
  nsamples = nbytes / sizeof(profiler_sample);
  if ((nsamples * sizeof(profiler_sample)) != nbytes)
    warning("read_samples: partial sample (nbytes=%d)", nbytes);

  /* log first sample in batch */
  log_sample(&samples[0], msg);

#if	0
  {
    int i;
    for (i = 0; i < nsamples; i++)
      log_sample(&samples[i], msg);
  }
#endif
}

int main(int argc, char **argv)
{
  int fd;

  /* enable verbose logging */
  log_set_name("testprof");
  log_set_verbose(1);

  /* open profiling device */
  if ((fd = open("/dev/prof", O_RDONLY)) < 0)
    fatal("unable to open /dev/prof");

  for (;;)
    read_samples(fd, NULL);

  /* cleanup */
  (void) close(fd);

  /* everything OK */
  return(EXIT_SUCCESS);
}
