#include "reflash.h"
#include "map.h"

static cmd_to_name_map_t   cmd_to_name_map[] =
{
    {FR_CMD_WRITE, "write segment", CMDF_RESTRICTED},
    {FR_CMD_RESET, "clear commands", 0},
    {FR_CMD_ERASE, "erase segment", CMDF_RESTRICTED},
    {FR_CMD_VERIFY, "verify segment", 0},
    {FR_CMD_UNPROTECT, "unprotect segment", 0},
    {FR_CMD_PROTECT, "protect segment", 0},
    {FR_CMD_RESTORE, "execute the command list", 0}
};

#ifdef DIM
#undef DIM
#endif

#define	DIM(x)	(sizeof(x)/sizeof(x[0]))

#ifndef NULL
#define	NULL	((void*)0)
#endif

cmd_to_name_map_t*
map_cmd_to_info(
    int	cmd)
{
    int	    i;

    for (i = 0; i < DIM(cmd_to_name_map); i++) {
	if (cmd_to_name_map[i].cmd == cmd)
	    return (&cmd_to_name_map[i]);
    }

    return (NULL);
}

char*
map_cmd_to_name(
    int	cmd)
{
    cmd_to_name_map_t*	info;

    if ((info = map_cmd_to_info(cmd)) != NULL)
	return (info->name);
    else
	return (NULL);
}

int
cmd_restrictedq(
    int	    cmd)
{
    cmd_to_name_map_t*	info;

    if ((info = map_cmd_to_info(cmd)) != NULL)
	return (info->flags & CMDF_RESTRICTED);
    else
	return (-1);
    
}
