#ifndef REFLASH_H_INCLUDED
#define REFLASH_H_INCLUDED

/* preserve the bootldr unless speciffically overridden */
#define	RESTRICTED_BASE	(0x40000)

#ifndef NO_ULONG_TYPEDEF
typedef unsigned long ulong_t;
#endif

#define	REFLASH_IF_VERSION  (1)

/*
 * Commands passed via the /proc/sys/flash_restore file.
 * We send a series of segment commands (1 or more) and finally
 * we send a restore command.
 * This begins the restore operation which should end with a software
 * reset.
 */

enum
{
    FR_CMD_WRITE = 1,		/* write a segment */
    FR_CMD_RESET = 2,		/* reset index into command list to 0 */
    FR_CMD_ERASE = 3,		/* erase a segment */
    FR_CMD_VERIFY = 4,		/* verify a segment */
    FR_CMD_UNPROTECT = 5,	/* unprotect a sector */
    FR_CMD_PROTECT = 6,		/* protect a sector */
    FR_CMD_RESTORE = 999	/* execute the command list */
};

typedef struct flash_restore_params_s
{
    int		command;
    unsigned	version;
    unsigned	size;
    
    ulong_t buffer_vaddr;
    ulong_t buffer_len;
    ulong_t flash_offset;
}
flash_restore_params_t;

/*
 * needed to allow us to share definitions between C and shell scripts
 */

#define C_and_sh_def

#endif
