#ifndef STATE_H_INCLUDED
#define STATE_H_INCLUDED


typedef struct reflash_state_s
{
    int	    offset_restricted;
    size_t  data_offset;
    int	    test_base ;
    char*   main_buf;
    size_t  main_buf_size;
    unsigned long   offset;
    unsigned long   word_mask;
   int	    auto_erase;
    int	    auto_verify;
    int	    dont_reset;
    size_t  len;
    size_t  sec_size;
}
reflash_state_t;

#define	rs_set_offset_restricted(rsp, v)  (rsp)->offset_restricted = (v)
#define	rs_clr_offset_restricted(rsp)  (rsp)->offset_restricted = (0)
#define	rs_set_data_offset(rsp, v)  (rsp)->data_offset = (v)
#define	rs_set_test_base(rsp, v)    (rsp)->test_base = (v)
#define	rs_set_buf(rsp, v)	    (rsp)->main_buf = (v)
#define	rs_set_buf_size(rsp, v)	    (rsp)->main_buf_size = (v)
#define	rs_set_offset(rsp, v)	    (rsp)->offset = (v)
#define	rs_set_auto_erase(rsp, v)   (rsp)->auto_erase = (v)
#define	rs_set_auto_verify(rsp, v)  (rsp)->auto_verify = (v)
#define	rs_set_dont_reset(rsp, v)   (rsp)->dont_reset = (v)
#define	rs_set_len(rsp, v)	    (rsp)->len = (v)
#define	rs_set_sec_size(rsp, v)	    (rsp)->sec_size = (v)
#define	rs_set_word_mask(rsp, v)    (rsp)->word_mask = (v)

#define	rs_offset_restrictedq(rsp)  ((rsp)->offset_restricted != 0)
#define	rs_get_data_offset(rsp)	((rsp)->data_offset)
#define	rs_data_offset_inc(rsp)	((rsp)->data_offset++)

#define	rs_get_test_base(rsp)	((rsp)->test_base)
#define	rs_get_buf(rsp)		((rsp)->main_buf)
#define	rs_get_buf_size(rsp)	((rsp)->main_buf_size)
#define	rs_get_offset(rsp)	((rsp)->offset)
#define	rs_get_auto_erase(rsp)	((rsp)->auto_erase)
#define	rs_auto_eraseq(rsp)	(rs_get_auto_erase(rsp) != 0)
#define	rs_get_auto_verify(rsp)	((rsp)->auto_verify)
#define	rs_auto_verifyq(rsp)	(rs_get_auto_verify(rsp) != 0)
#define	rs_get_len(rsp)		((rsp)->len)
#define	rs_get_sec_size(rsp)	((rsp)->sec_size)
#define	rs_get_word_mask(rsp)   ((rsp)->word_mask)
#define	rs_offset_restrictedq(rsp)  ((rsp)->offset_restricted != 0)

#define	rs_get_cur_bufp(rsp)	((rsp)->main_buf+(rsp)->offset)
#define	rs_get_data_bufp(rsp)	(rs_get_cur_bufp(rsp)+(rsp)->data_offset)

#define	rs_get_resid(rsp)	(rs_get_buf_size(rsp) - rs_get_offset(rsp))

#define	rs_resetq(rsp)		((rsp)->dont_reset == 0)

#define	rs_init(rsp)		memset(rsp, 0x00, sizeof(reflash_state_t))

#endif
