/*
 * Itsy Utility Routines
 * Simple Resizable Array
 *
 * Copyright (c) Compaq Computer Corporation, 1998
 *
 * Use consistent with the GNU GPL is permitted,
 * provided that this copyright notice is
 * preserved in its entirety in all copies and derived works.
 *
 * COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR IMPLIED,
 * AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR ITS
 * FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 */

/*
 * Itsy Utility Routines
 * Simple Resizable Array
 *
 * $Log: array.c,v $
 * Revision 1.1.1.1  2000/11/28 16:46:34  kerr
 * Compaq Profiling Infrastructure
 *
 * Revision 1.2  1998/10/29  18:39:21  caw
 * Updated comments with explicit credit for Sanjay.
 *
 * Revision 1.1  1998/10/28  02:22:30  kerr
 * Made utiltily directory, libraries, include, etc and changed apps to use it.
 *
 * Revision 2.0  1998/06/24  21:32:03  kramer
 * Major Bump: Move all version numbers up to 2.0 for external release.
 * -drew
 *
 * Revision 1.2  1998/06/16  19:18:46  kramer
 * Added copyright information
 *
 * Revision 1.1  1998/03/07  03:54:25  caw
 * Initial revision.
 *
 */

/*
 * Unmodified version of DCPI "util/array.c", Revision 1.1.
 * Original code written by Sanjay Ghemawat.
 *
 */

#include <assert.h>
#include <stdlib.h>
#include <util/util.h>
#include <util/array.h>

void _array_init(_array* x, int init, size_t esize) {
    assert(init >= 0);
    if (init == 0) {
	init = 1;
    }

    x->length	= 0;
    x->alloc	= init;
    x->list	= malloc(esize * init);
}

void _array_destroy(_array* x) {
    free(x->list);
    x->length = x->alloc = 0;
    x->list = NULL;
}

void _array_enlarge(_array* x, int n, size_t esize) {
    void* copy;
    int newalloc;

    assert(x->length >= 0);
    assert(x->length <= x->alloc);
    assert(x->alloc > 0);
    newalloc = x->alloc;
    while ((x->length + n) > newalloc) {
	newalloc *= 2;
    }

    copy = malloc(esize * newalloc);
    memcpy(copy, x->list, esize * x->length);
    free(x->list);
    x->alloc = newalloc;
    x->list = copy;
}
