/*
 *
 * Philips UDA1380 mixer device driver
 *
 * Copyright (c) 2002 Hewlett-Packard Company
 *
 * Copyright (c) 2000 Nicolas Pitre <nico@cam.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License.
 */

#include <sound/core.h>
#include <sound/control.h>
#include <sound/initval.h>
#include <sound/info.h>

#define UDA1380_NAME "uda1380"

struct uda1380_cfg {
	unsigned int fs:16;
	unsigned int format:3;
	unsigned int pll;
};

#define FMT_I2S		0
#define FMT_LSB16	1
#define FMT_LSB18	2
#define FMT_LSB20	3
#define FMT_MSB		5

#define I2C_UDA1380_CONFIGURE	0x13800001
#define I2C_UDA1380_OPEN	0x13800002
#define I2C_UDA1380_CLOSE	0x13800003

struct i2c_gain {
	unsigned int	left:8;
	unsigned int	right:8;
};

#define I2C_SET_VOLUME		0x13800010
#define I2C_SET_TREBLE		0x13800011
#define I2C_SET_BASS		0x13800012
#define I2C_SET_LINE_GAIN	0x13800013
#define I2C_SET_MIC_GAIN	0x13800014
#define I2C_SET_CAP_VOLUME	0x13800015
#define I2C_SET_MIC_SW	        0x13800016
#define I2C_SET_STR		0x13800018
#define I2C_SET_DEEMP		0x13800019

struct i2c_agc {
	unsigned int	level:8;
	unsigned int	enable:1;
	unsigned int	attack:7;
	unsigned int	decay:8;
	unsigned int	channel:8;
};

#define I2C_SET_AGC		0x1380017

/*
 * UDA1380 I2C address and command types
 */
#define UDA1380_I2CADDR		1
#define UDA1380_DATA0		(UDA1380_I2CADDR << 2 | 0)
#if !defined(CONFIG_UDA1344) && !defined(CONFIG_UDA1345)
#define UDA1380_DATA1		(UDA1380_I2CADDR << 2 | 1)
#endif
#define UDA1380_STATUS		(UDA1380_I2CADDR << 2 | 2)

#define REG_MAX 0x24

#define REG0				0x00

#define REG0_EN_ADC			(1 << 11)
#define REG0_EN_DEC			(1 << 10)
#define REG0_EN_DAC			(1 <<  9)
#define REG0_EN_INT			(1 <<  8)
#define REG0_ADC_USE_WSPLL		(1 <<  5)
#define REG0_ADC_USE_SYSCLK		(0 <<  5)
#define REG0_DAC_USE_WSPLL		(1 <<  4)
#define REG0_DAC_USE_SYSCLK		(0 <<  4)
#define REG0_SC_MASK			(3 << 2)
#define REG0_SC_768FS			(3 << 2)
#define REG0_SC_512FS			(2 << 2)
#define REG0_SC_384FS			(1 << 2)
#define REG0_SC_256FS			(0 << 2)
#define REG0_PLL_MASK			(3 << 0)
#define REG0_PLL_6TO12			(0 << 0)
#define REG0_PLL_12TO25			(1 << 0)
#define REG0_PLL_25TO50			(2 << 0)
#define REG0_PLL_50TO100		(3 << 0)

#define I2S_REG				0x01

#define I2S_REG_SFORO_MASK		(7 << 0)
#define I2S_REG_SFORO_SHIFT		0
#define I2S_REG_SFORI_MASK		(7 << 8)
#define I2S_REG_SFORI_SHIFT		8
#define I2S_REG_SEL_DECIMATOR		(1 << 6)
#define I2S_REG_SEL_MIXER		(1 << 6)
#define I2S_REG_SIM_SLAVE		(0 << 4)
#define I2S_REG_SIM_MASTER		(1 << 4)

#define PWR_REG				0x02

#define PWR_REG_PON_PLL			(1 << 15)
#define PWR_REG_PON_HP			(1 << 13)
#define PWR_REG_PON_DAC			(1 << 10)
#define PWR_REG_PON_BIAS		(1 << 8)
#define PWR_REG_EN_ADC			(1 << 7) /* NOTE: typo .... ADC -> AVC */
#define PWR_REG_PON_ADC			(1 << 6)
#define PWR_REG_PON_LNA			(1 << 4)
#define PWR_REG_PON_PGAL		(1 << 3)
#define PWR_REG_PON_ADCL		(1 << 2)
#define PWR_REG_PON_PGAR		(1 << 1)
#define PWR_REG_PON_ADCR		(1 << 0)

/* analog mixer */
#define AMIX_REG			0x03

/*
 * the analog mixer enables line-input to be played on speaker or
 * headphones without running it through the digital section.
 * We do not use it on the iPAQ.
 *
 * iPAQ h3900:
 *   - line-input is not connected
 *   - built-in microphone connected to mic-in.  No microphone jack.
 *   - line-output mixed together at speaker amplifier.
 *   - headphone amp goes to head-phone jack.  earphone detect is on asic2.
 */

#define AMIX_AVCL(x)	(((x) & 0x1f) << 8)
#define AMIX_AVCL_MASK	(0x1f << 8)
#define AMIX_AVCR(x)	(((x) & 0x1f) << 0)
#define AMIX_AVCR_MASK	(0x1f << 0)

/* digital master volume control register */
#define MASTER_VOL_REG			0x10

#define MASTER_VCL(x)	(((x) & 0xff) << 8)
#define MASTER_VCL_MASK	(0xff << 8)
#define MASTER_VCR(x)	(((x) & 0xff) << 0)
#define MASTER_VCR_MASK	(0xff << 0)

/* digital mixer control register */
#define MIXER_VOL_REG			0x11

#define MIXER_VCL(x)	(((x) & 0xff) << 8)
#define MIXER_VCL_MASK	(0xff << 8)
#define MIXER_VCR(x)	(((x) & 0xff) << 0)
#define MIXER_VCR_MASK	(0xff << 0)

/* mode, bass boost, treble */
#define MBT_REG				0x12
#define MBT_MODE_MASK			(3 << 14)
#define MBT_MODE_FLAT			(0 << 14)
#define MBT_MODE_MIN			(1 << 14)
#define MBT_MODE_MAX			(3 << 14)
#define MBT_MODE_SHIFT			(14)
#define MBT_TRL_WIDTH			2
#define MBT_TRL_MASK			(3 << 12)
#define MBT_TRL(x)			((x) << 12)
#define MBT_TRR_MASK			(3 << 4)
#define MBT_TRR(x)			((x) << 4)
#define MBT_BBL_WIDTH			4
#define MBT_BBL_MASK			(0xf << 8)
#define MBT_BBL(x)			((x) << 8)
#define MBT_BBR_MASK			(0xf << 0)
#define MBT_BBR(x)			((x) << 0)

/* channel2 is from decimation filter */
/* channel1 is from digital data from I2S */

#define MMCDM_REG			0x13
#define MMCDM_MASTER_MUTE		(1 << 14)
#define MMCDM_CHANNEL2_MUTE		(1 << 11)
#define MMCDM_CHANNEL2_DEEMPHASIS_OFF	(0 << 8)
#define MMCDM_CHANNEL2_DEEMPHASIS_32KHZ	(1 << 8)
#define MMCDM_CHANNEL2_DEEMPHASIS_44KHZ	(2 << 8)
#define MMCDM_CHANNEL2_DEEMPHASIS_48KHZ	(3 << 8)
#define MMCDM_CHANNEL2_DEEMPHASIS_96KHZ	(4 << 8)
#define MMCDM_CHANNEL2_DEEMPHASIS_MASK	(7 << 8)
#define MMCDM_CHANNEL2_DEEMPHASIS_SHIFT	(8)
#define MMCDM_CHANNEL1_MUTE		(1 << 3)
#define MMCDM_CHANNEL1_DEEMPHASIS_32KHZ	(1 << 0)
#define MMCDM_CHANNEL1_DEEMPHASIS_44KHZ	(2 << 0)
#define MMCDM_CHANNEL1_DEEMPHASIS_48KHZ	(3 << 0)
#define MMCDM_CHANNEL1_DEEMPHASIS_96KHZ	(4 << 0)
#define MMCDM_CHANNEL1_DEEMPHASIS_MASK	(7 << 0)
#define MMCDM_CHANNEL1_DEEMPHASIS_SHIFT	(0)

#define MIXER_CTL_REG			0x14

#define MIXER_CTL_DAC_POLARITY_INVERT	(1 << 15)
#define MIXER_CTL_SEL_5TH_ORDER_NS	(1 << 14)
#define MIXER_CTL_MIX_POS	        (1 << 13)
#define MIXER_CTL_MIX		        (1 << 12)
#define MIXER_CTL_SILENCE	        (1 << 7)
#define MIXER_CTL_SDET_ON	        (1 << 6)
#define MIXER_CTL_SDET_VALUE_MASK       (3 << 4)
#define MIXER_CTL_SDET_VALUE_SHIFT	4
#define MIXER_CTL_OVERSAMPLING_MASK     (3 << 0)
#define MIXER_CTL_OVERSAMPLING_SHIFT    0

#define DEC_VOL_REG			0x20

#define DEC_VCL(x)	(((x) & 0xff) << 8)
#define DEC_VCL_MASK	(0xff << 8)
#define DEC_VCR(x)	(((x) & 0xff) << 0)
#define DEC_VCR_MASK	(0xff << 0)

#define DPM_REG				0x21

#define DPM_MUTE_ADC	(1 << 15)
#define DPM_GAINL(x)	(((x) & 0xf) << 8)
#define DPM_GAINL_MASK	(0xf << 8)
#define DPM_GAINR(x)	(((x) & 0xf) << 0)
#define DPM_GAINR_MASK	(0xf << 0)

#define DEC_ADC_REG			0x22

#define DEC_ADC_POL_INV			(1 << 12)
#define DEC_ADC_VGA_CTRL(x)		((x) << 8)
#define DEC_ADC_VGA_CTRL_MASK		(0xf << 8)
#define DEC_ADC_SEL_LNA			(1 << 3)
#define DEC_ADC_SEL_MIC			(1 << 2)
#define DEC_ADC_SKIP_DCFIL		(1 << 1)
#define DEC_ADC_EN_DCFIL		(1 << 0)

#define DEC_AGC_REG			0x23

#define DEC_AGC_EN			(1 << 0)

int uda1380_command(struct i2c_client *clnt, unsigned int cmd, void *arg);
int snd_chip_uda1380_mixer_new(snd_card_t *card, struct i2c_client **clnt);
void snd_chip_uda1380_mixer_del(snd_card_t *card);
int uda1380_mute(struct i2c_client *clnt, int mute);
