#!/usr/bin/env python

# $Id: account.py,v 1.2 2002/04/21 10:22:33 cvsd Exp $

from gtk import *
import string, re, os, time,XmlParse
class Accounts:
    def __init__(self, parent):
        self.parent = parent
        self.config = self.parent.config
        self.bankpath = self.parent.bankpath
        self.window = self.parent.window
        self.cmap = self.window.get_colormap()
    
    
        frame=GtkFrame()
        frame.set_usize(-1, -1)
        frame.set_shadow_type("GTK_SHADOW_ETCHED_IN")
        frame.set_label("Accounts")
        frame.set_label_align(0, -1)
    
        vpaned = GtkVPaned()
        frame.add(vpaned)
        vpaned.show()
    
        vbox = GtkVBox()
        vpaned.pack1(vbox)
        vbox.show()
    
        # make the toobar
        toolbar = GtkToolbar(ORIENTATION_HORIZONTAL, TOOLBAR_ICONS)
        toolbar.set_button_relief(RELIEF_NONE)
        toolbar.set_space_size(10)
        vbox.pack_start(toolbar, expand=FALSE)
        toolbar.show()
        # add the evolution pixmaps to the toolbar
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/new.xpm")
        toolbar.append_item(None, 'Create a new account', None, GtkPixmap(pix, mask), self.new_account)
    
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/edit.xpm")
        toolbar.append_item(None, 'Edit the selected account', None, GtkPixmap(pix, mask), self.edit_account)
    
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/trash.xpm")
        toolbar.append_item(None, 'Delete the selected account', None, GtkPixmap(pix, mask), self.delete_account)
    
        cscroll = GtkScrolledWindow()
        cscroll.set_policy(POLICY_AUTOMATIC, POLICY_AUTOMATIC)
        vbox.pack_start(cscroll)
        cscroll.show()
    
        clist=GtkCList(2)
        cscroll.add(clist)
        clist.connect("select_row" , self.select_account)
        clist.set_flags(CAN_FOCUS)
        clist.set_usize(-1, 87)
        clist.set_column_title(0, "Name")
        clist.set_column_title(1, "Description")
        clist.set_column_width(0, 150)
        clist.set_column_width(1, 80)
        clist.set_selection_mode(SELECTION_SINGLE)
        clist.column_titles_show()
        clist.show()
        self.clist=clist
        frame.show()
        self.frame=frame
    
        scroll = GtkScrolledWindow()
        scroll.set_policy(POLICY_NEVER, POLICY_ALWAYS)
        self.scroll = scroll
        vpaned.pack2(scroll)
        scroll.show()
    
        text = GtkText()
        self.text = text
        text.set_editable(FALSE)
        scroll.add(text)
        text.show()
    
        xml = XmlParse.XmlParse()
        self.xml_accounts = xml.parse_xml_file(self.bankpath + '/data/accounts.xml', 'account')
    
        self.account = []
        for xml_account in self.xml_accounts:
            self.account.append([xml.xml_get_text(xml_account, "name"), xml.xml_get_text(xml_account, "description"), xml.xml_get_text(xml_account, "type"), xml.xml_get_text(xml_account, "currency"), xml.xml_get_text(xml_account, "code"), xml.xml_get_text(xml_account, "notes")])
        self.update_list(self.clist)
    
    def update_list(self, clist):
        x = 0
        v = 0
        clist_color = self.cmap.alloc("grey87");
        self.account.sort(lambda x, y: cmp(x[0], y[0]))
        clist.clear()
        while x < len(self.account):
            headers = [self.account[x][0], self.account[x][1]]
            clist.append(headers)
            if v == 0:
                clist.set_background(x, clist_color)
                v = 1
            else:
                v = 0
            x = x + 1
    
    def select_account(self, *args):
        self.text.freeze()
        self.text.delete_text(0, -1)
        self.selected_account = args[1]
        if self.account[self.selected_account][0] != "":
            self.text.insert(None,None,None,"Name: " + self.account[self.selected_account][0] + "\n")
        if self.account[self.selected_account][1] != "":
            self.text.insert(None,None,None,"Description: " + self.account[self.selected_account][1] + "\n")
        if self.account[self.selected_account][2] != "":
            self.text.insert(None,None,None,"Type: " + self.account[self.selected_account][2] + "\n")
        if self.account[self.selected_account][3] != "":
            self.text.insert(None,None,None,"Currency: " + self.account[self.selected_account][3] + "\n")
        if self.account[self.selected_account][4] != "":
            self.text.insert(None,None,None,"Code: " + self.account[self.selected_account][4] + "\n")
        if self.account[self.selected_account][5] != "":
            self.text.insert(None,None,None,"Notes: " + self.account[self.selected_account][5] + "\n")
        vadjust = self.scroll.get_vadjustment()
        vadjust.set_value(0)
        self.text.thaw()
    
    def new_account(self, *args):
        self.do_account("new")
    
    def edit_account(self, *args):
        self.do_account("edit")
    
    def delete_account(self, *args):
        del self.account[self.selected_account]
        self.text.delete_text(0, -1)
        self.update_list(self.clist)
        self.update_xml()
    
    def save_account(self, *args):
        self.account.append([self.name_entry.get_text(), self.description_entry.get_text(), self.type_entry.get_text(), self.currency_text.get_text(), self.codes_entry.get_text(),self.notes_text.get_chars(0, -1)])
        self.update_list(self.clist)
        self.account_window.hide()
        self.update_xml()

    def get_account_name(self, *args):
        self.parent.set_selected_account(self.account[self.selected_account][0])
    
    def save_edited_account(self, *args):
        self.account[self.selected_account][0] = self.name_entry.get_text()
        self.account[self.selected_account][1] = self.description_entry.get_text()
        self.account[self.selected_account][2] = self.type_entry.get_text()
        self.account[self.selected_account][3] = self.currency_text.get_text()
        self.account[self.selected_account][4] = self.codes_entry.get_text()
        self.account[self.selected_account][5] = self.notes_text.get_chars(0, -1)
        self.update_list(self.clist)
        self.select_account(None, self.selected_account)
        self.account_window.hide()
        self.update_xml()
    
    def do_account(self, type, cname='', ccodes=''):
        # our main gtk window
        window = GtkWindow(WINDOW_TOPLEVEL)
        self.account_window = window
        window.connect("delete_event", window.hide)
        window.set_title("Bank - Account")
        window.set_usize(240, 200)
        window.show()
    
        vbox = GtkVBox()
        window.add(vbox)
        vbox.show()
    
        # make the toobar
        toolbar = GtkToolbar(ORIENTATION_HORIZONTAL, TOOLBAR_ICONS)
        toolbar.set_button_relief(RELIEF_NONE)
        toolbar.set_space_size(10)
        vbox.pack_start(toolbar, expand=FALSE)
        toolbar.show()
        # add the evolution pixmaps to the toolbar
        if type == "edit":
            pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/save.xpm")
            toolbar.append_item(None, 'Save the current account', None, GtkPixmap(pix, mask), self.save_edited_account)
        else:
            pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/save.xpm")
            toolbar.append_item(None, 'Save the current account', None, GtkPixmap(pix, mask), self.save_account)
    
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/cancel.xpm")
        toolbar.append_item(None, 'Close this window', None, GtkPixmap(pix, mask), window.hide)
    
        table1=GtkTable(8, 2)
        vbox.pack_start(table1)
        table1.set_usize(-1, -1)
        table1.set_row_spacings(0)
        table1.set_col_spacings(0)
        label3=GtkLabel()
        table1.attach(label3, 0, 1, 1, 2, FILL, 0, 0, 0)
        label3.set_usize(-1, -1)
        label3.set_text("Description")
        label3.set_justify(JUSTIFY_CENTER)
        label3.set_alignment(0, 0.5)
        label3.set_padding(0, 0)
        label3.show()
        self.label3=label3
        label4=GtkLabel()
        table1.attach(label4, 0, 1, 2, 3, FILL, 0, 0, 0)
        label4.set_usize(-1, -1)
        label4.set_text("Type")
        label4.set_justify(JUSTIFY_CENTER)
        label4.set_alignment(0, 0.5)
        label4.set_padding(0, 0)
        label4.show()
        self.label4=label4
        label7=GtkLabel()
        table1.attach(label7, 0, 1, 3, 4, FILL, 0, 0, 0)
        label7.set_usize(-1, -1)
        label7.set_text("Currency")
        label7.set_justify(JUSTIFY_CENTER)
        label7.set_alignment(0, 0.5)
        label7.set_padding(0, 0)
        label7.show()
        self.label7=label7
        label2=GtkLabel()
        table1.attach(label2, 0, 1, 4, 5, FILL, 0, 0, 0)
        label2.set_usize(-1, -1)
        label2.set_text("Code")
        label2.set_justify(JUSTIFY_CENTER)
        label2.set_alignment(0, 0.5)
        label2.set_padding(0, 0)
        label2.show()
        self.label2=label2
        label8=GtkLabel()
        table1.attach(label8, 0, 1, 5, 6, FILL, 0, 0, 0)
        label8.set_usize(-1, -1)
        label8.set_text("Notes")
        label8.set_justify(JUSTIFY_CENTER)
        label8.set_alignment(0, 0.5)
        label8.set_padding(0, 0)
        label8.show()
        self.label8=label8
        name_entry=GtkEntry()
        table1.attach(name_entry, 1, 2, 0, 1, EXPAND, 0, 0, 0)
        name_entry.set_flags(CAN_FOCUS)
        name_entry.set_usize(170, -1)
        name_entry.set_editable(TRUE)
        name_entry.set_visibility(TRUE)
        name_entry.set_max_length(0)
        if type == "edit":
            name_entry.set_text(self.account[self.selected_account][0])
        else:
            name_entry.set_text(cname)
        name_entry.show()
        self.name_entry=name_entry
        description_entry=GtkEntry()
        table1.attach(description_entry, 1, 2, 1, 2, EXPAND, 0, 0, 0)
        description_entry.set_flags(CAN_FOCUS)
        description_entry.set_usize(170, -1)
        description_entry.set_editable(TRUE)
        description_entry.set_visibility(TRUE)
        description_entry.set_max_length(0)
        if type == "edit":
            description_entry.set_text(self.account[self.selected_account][1])
        description_entry.show()
        self.description_entry=description_entry
        type_entry=GtkEntry()
        table1.attach(type_entry, 1, 2, 2, 3, EXPAND, 0, 0, 0)
        type_entry.set_flags(CAN_FOCUS)
        type_entry.set_usize(170, -1)
        type_entry.set_editable(TRUE)
        type_entry.set_visibility(TRUE)
        type_entry.set_max_length(0)
        if type == "edit":
            type_entry.set_text(self.account[self.selected_account][2])
        type_entry.show()
        self.type_entry=type_entry
        currency_text=GtkEntry()
        table1.attach(currency_text, 1, 2, 3, 4, EXPAND, 0, 0, 0)
        currency_text.set_flags(CAN_FOCUS)
        currency_text.set_usize(170, -1)
        currency_text.set_editable(TRUE)
        currency_text.set_visibility(TRUE)
        currency_text.set_max_length(0)
        if type == "edit":
            currency_text.set_text(self.account[self.selected_account][3])
        currency_text.show()
        self.currency_text=currency_text

        codes_entry=GtkEntry()
        table1.attach(codes_entry, 1, 2, 4, 5, EXPAND, 0, 0, 0)
        codes_entry.set_flags(CAN_FOCUS)
        codes_entry.set_usize(170, -1)
        codes_entry.set_editable(TRUE)
        codes_entry.set_visibility(TRUE)
        codes_entry.set_max_length(0)
        if type == "edit":
            codes_entry.set_text(self.account[self.selected_account][4])
        else:
            codes_entry.set_text(ccodes)
        codes_entry.show()
        self.codes_entry=codes_entry
        scrolledwindow2=GtkScrolledWindow()
        table1.attach(scrolledwindow2, 1, 2, 5, 6, FILL, FILL, 0, 0)
        scrolledwindow2.set_usize(170, 60)
        scrolledwindow2.set_policy(POLICY_NEVER, POLICY_AUTOMATIC)
        notes_text=GtkText()
        scrolledwindow2.add(notes_text)
        notes_text.set_flags(CAN_FOCUS)
        notes_text.set_usize(170, 60)
        notes_text.set_editable(TRUE)
        if type == "edit":
            notes_text.insert(None,None,None,self.account[self.selected_account][5])
        notes_text.show()
        self.notes_text=notes_text
        scrolledwindow2.show()
        self.scrolledwindow2=scrolledwindow2
        label1=GtkLabel()
        table1.attach(label1, 0, 1, 0, 1, FILL, 0, 0, 0)
        label1.set_usize(-1, -1)
        label1.set_text("Name")
        label1.set_justify(JUSTIFY_CENTER)
        label1.set_alignment(0, 0.5)
        label1.set_padding(0, 0)
        label1.show()
        self.label1=label1
        table1.show()
        self.table1=table1
    
    def update_xml(self):
        file = open(self.bankpath + '/data/accounts.xml', 'w')
        x = 0
        while x < len(self.account):
            file.write('<account>\n<name>' + self.account[x][0] + '</name>\n<description>' + self.account[x][1] + '</description>\n<type>' + self.account[x][2] + '</type>\n<currency>' + self.account[x][3] + '</currency>\n<code>' + self.account[x][4] + '</code>\n<notes>' + self.account[x][5] + '</notes>\n</account>\n\n')
            x = x + 1
        file.close
    
