#! /usr/bin/env python

# $Id: bank.py,v 1.7 2002/04/22 17:07:39 cvsd Exp $

from gtk import *
import os, string, re, contact, category, money, GtkExtra, time, XmlParse


class bank:
    def __init__(self):
	self.version="0.2"
        self.window = GtkWindow(WINDOW_TOPLEVEL)
        self.window.connect("delete_event",self.quit)
        self.window.set_title("Bank v"+self.version)
        wscr=screen_width()
        hscr=screen_height()
        
        if wscr>350:
            wscr=350
        if hscr>350:
            hscr=350
        self.window.set_usize(wscr,hscr)

        self.get_config()
        self.money = money.Money(self)
        self.contacts = contact.Contacts(self)
        self.categories = category.Categories(self)

        # VBox principal
        self.vbox = GtkVBox()
        self.window.add(self.vbox)
        self.vbox.show()

        # Menu Bar
    
        ag = GtkAccelGroup()
        itemf = GtkItemFactory(GtkMenuBar, "<main>", ag)
        self.window.add_accel_group(ag)
        itemf.create_items([
            ('/_File',          None,         None, 0, '<Branch>'),
            ('/_File/_Import QIF',     None, self.import_file, 1, ''),
            ('/_File/_Export QIF',    None, self.not_yet, 2, ''),
            ('/_File/sep1',     None,   None, 0, '<Separator>'),
            ('/_File/E_xit',    '<alt>F4',    self.quit, 6, ''),
            ('/_Help',          None,         None, 0, '<LastBranch>'),
            ('/_Help/_About',   '<control>A', self.show_about, 1, '')
        ])
        self.w_menubar = itemf.get_widget('<main>')
        self.vbox.pack_start(self.w_menubar, expand=FALSE)
        self.w_menubar.show()
    

        # make the toolbar
        self.toolbar = GtkToolbar(ORIENTATION_HORIZONTAL, TOOLBAR_ICONS)
        self.toolbar.set_button_relief(RELIEF_NONE)
        self.toolbar.set_space_size(10)
        self.vbox.pack_start(self.toolbar, expand=FALSE)
        self.toolbar.show()
        
        # make our notbook
        self.notebook = GtkNotebook()
        self.notebook.show()
        self.notebook.set_show_tabs(FALSE)
        self.notebook.set_show_border(FALSE)
        # add it to the vbox
        self.notebook.add(self.money.frame)
        self.notebook.add(self.contacts.frame)
        self.notebook.add(self.categories.frame)
        self.vbox.pack_start(self.notebook)
        
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/money.xpm")
        self.toolbar.append_item(None, 'Money', None, GtkPixmap(pix, mask), self.show_money)
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/evolution-contacts.xpm")
        self.toolbar.append_item(None, 'Contacts', None, GtkPixmap(pix, mask), self.show_contacts)
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/briefcase.xpm")
        self.toolbar.append_item(None, 'Categories', None, GtkPixmap(pix, mask), self.show_categories)

    def show_money(self, *args):
        self.notebook.set_page(0)

    def show_contacts(self, *args):
        self.notebook.set_page(1)

    def show_categories(self, *args):
        self.notebook.set_page(2)

    def show_about(self,*args):
        dlg=GtkExtra.message_box("About Bank",
                     "Bank v" + self.version + "\n\n" +
                     "The Bank personal finance manager\n\n"
                     "Author : Medhy Palfray \n"+
                     "Email : <medhy@palfray.com>\n\n" +
                     "(c) 2002 Medhy Palfray", ("OK",),
                     pixmap=self.bankpath + "/pixmaps/money.xpm")

    def not_yet(self,*args):
        dlg=GtkExtra.message_box("Not yet",
                     "Not implemented", ("OK",),'')

    def import_file (self,*args):
        dlg=GtkExtra._FileSelection(modal=FALSE)
        dlg.set_title("Select a QIF file")
        wscr=screen_width()
        hscr=screen_height()
        
        if wscr>550:
            wscr=550
        if hscr>400:
            hscr=400
        dlg.set_usize(wscr,hscr)
        dlg.show()
        mainloop()
        dlg=dlg.ret
        if dlg:
            isopen=1
            try:
                f=open(dlg,"rb")
            except IOError:
                print "Can't open file"
                isopen=0
            if isopen==1:

                window = GtkWindow(WINDOW_TOPLEVEL)
                self.format_window = window
                #window.connect("delete_event", window.hide)
                window.set_title("Bank - format")
                window.set_usize(240, 200)
                window.show()

                vbox = GtkVBox()
                window.add(vbox)
                vbox.show()

                label1=GtkLabel()
                vbox.pack_start(label1, expand=FALSE)
                label1.set_usize(-1, -1)
                label1.set_text("Date format :")
                label1.set_justify(JUSTIFY_CENTER)
                label1.set_alignment(0, 0.5)
                label1.set_padding(0, 0)
                label1.show()

                self.menubar = GtkMenuBar()
                self.menubar.set_shadow_type(SHADOW_NONE)
                vbox.pack_start(self.menubar, FALSE, FALSE, 2)
                self.menubar.show()

                self.current_type_menuitem = GtkMenuItem("dd/mm/yyyy (18/04/2002)")
                self.menubar.append(self.current_type_menuitem)
                self.current_type_menuitem.show()
                self.current_type="%d/%m/%Y"


                self.types_menu = GtkMenu()
                self.current_type_menuitem.set_submenu(self.types_menu)
                self.types_menu.show()

                self.type_menuitem = GtkMenuItem("dd/mm/yyyy (18/04/2002)")
                self.type_menuitem.connect("activate", self.select_type, "dd/mm/yyyy (18/04/2002)")
                self.types_menu.append(self.type_menuitem)
                self.type_menuitem.show()

                self.type_menuitem = GtkMenuItem("mm/dd/yyyy (02/18/2002)")
                self.type_menuitem.connect("activate", self.select_type, "mm/dd/yyyy (02/18/2002)")
                self.types_menu.append(self.type_menuitem)
                self.type_menuitem.show()

                
                btnok = GtkButton("Ok")
                vbox.pack_start(btnok,expand=FALSE)
                btnok.set_usize(150, -1)
                btnok.connect("clicked",self.read_qif,f)
                btnok.show()
                self.btnok = btnok

    def select_type(self, *args):
        self.type = args[1]
        self.current_type_menuitem.remove_submenu()
        self.current_type_menuitem.hide()
        self.current_type_menuitem = GtkMenuItem(self.type)
        self.menubar.append(self.current_type_menuitem)
        self.current_type_menuitem.show()
        self.current_type_menuitem.set_submenu(self.types_menu)
        if self.type=="dd/mm/yyyy (18/04/2002)":
            self.current_type="%d/%m/%Y"
        if self.type=="mm/dd/yyyy (02/18/2002)":
            self.current_type="%m/%d/%Y"

    def read_qif(self, *args):
        f=args[1]
        self.format_window.hide()
        obj=[]
        xml = XmlParse.XmlParse()
        # Creation des nouveau comptes
        xml_accounts = xml.parse_xml_file(self.bankpath + '/data/accounts.xml', 'account')
        self.account = []
        for xml_account in xml_accounts:
            self.account.append([xml.xml_get_text(xml_account, "name"), xml.xml_get_text(xml_account, "description"), xml.xml_get_text(xml_account, "type"), xml.xml_get_text(xml_account, "currency"), xml.xml_get_text(xml_account, "code"), xml.xml_get_text(xml_account, "notes")])

        
        # Cration des oprations
        xml = XmlParse.XmlParse()
        xml_operations = xml.parse_xml_file(self.bankpath + '/data/operations.xml', 'operation')
        self.operation = []
        for xml_operation in xml_operations:
            self.operation.append([xml.xml_get_text(xml_operation, "account"), xml.xml_get_text(xml_operation, "number"), xml.xml_get_text(xml_operation, "description"), xml.xml_get_text(xml_operation, "categorie"), xml.xml_get_text(xml_operation, "contact"), xml.xml_get_text(xml_operation, "type"), xml.xml_get_text(xml_operation, "date"), xml.xml_get_text(xml_operation, "value"), xml.xml_get_text(xml_operation, "notes"), xml.xml_get_text(xml_operation, "transfert")])

        # Cration des catgories
        xml = XmlParse.XmlParse()
        xml_categories = xml.parse_xml_file(self.bankpath + '/data/categories.xml', 'category')
        self.category = []
        for xml_category in xml_categories:
            self.category.append([xml.xml_get_text(xml_category, "name"), xml.xml_get_text(xml_category, "notes")])

        # Cration des contacts
        xml = XmlParse.XmlParse()
        self.xml_contacts = xml.parse_xml_file(self.bankpath + '/data/contacts.xml', 'contact')
        self.contact = []
        for xml_contact in self.xml_contacts:
            self.contact.append([xml.xml_get_text(xml_contact, "name"), xml.xml_get_text(xml_contact, "nickname"), xml.xml_get_text(xml_contact, "dob"), xml.xml_get_text(xml_contact, "address"), xml.xml_get_text(xml_contact, "email"), xml.xml_get_text(xml_contact, "website"), xml.xml_get_text(xml_contact, "phone"), xml.xml_get_text(xml_contact, "notes")])

        #Rcupration des donnes
        while TRUE:
            line= f.readline()
            if line == '':
                break
            if '\n' in line:
                line=line[:-1]
            if '\r' in line:
                line=line[:-1]
            if line[0] == "^":
                self.import_qif(obj)
                obj=[]
            else:
                obj.append(line)

        f.close()

        # Enregistrement des nouveaux comptes
        file = open(self.bankpath + '/data/accounts.xml', 'w')
        x = 0
        while x < len(self.account):
            file.write('<account>\n<name>' + self.account[x][0] + '</name>\n<description>' + self.account[x][1] + '</description>\n<type>' + self.account[x][2] + '</type>\n<currency>' + self.account[x][3] + '</currency>\n<code>' + self.account[x][4] + '</code>\n<notes>' + self.account[x][5] + '</notes>\n</account>\n\n')
            x = x + 1
        file.close
        # Enregistrement des nouvelles oprations
        file = open(self.bankpath + '/data/operations.xml', 'w')
        x = 0
        while x < len(self.operation):
            file.write('<operation>\n<account>' + self.operation[x][0] + '</account>\n<number>' + self.operation[x][1] + '</number>\n<description>' + self.operation[x][2] + '</description>\n<categorie>' + self.operation[x][3] + '</categorie>\n<contact>' + self.operation[x][4] + '</contact>\n<type>' + self.operation[x][5] + '</type>\n<date>' + self.operation[x][6] + '</date>\n<value>' + self.operation[x][7] + '</value>\n<notes>' + self.operation[x][8] + '</notes>\n<transfert>' + self.operation[x][9] + '</transfert>\n</operation>\n\n')
            x = x + 1
        file.close
        # Enregistrement des nouvelles catgories
        file = open(self.bankpath + '/data/categories.xml', 'w')
        x = 0
        while x < len(self.category):
            file.write('<category>\n<name>' + self.category[x][0] + '</name>\n<notes>' + self.category[x][1] + '</notes>\n</category>\n\n')
            x = x + 1
        file.close
        self.categories.category=self.category
        self.categories.update_list(self.categories.clist)
        # Enregistrement des nouveaux contacts
        file = open(self.bankpath + '/data/contacts.xml', 'w')
        x = 0
        while x < len(self.contact):
            file.write('<contact>\n<name>' + self.contact[x][0] + '</name>\n<nickname>' + self.contact[x][1] + '</nickname>\n<dob>' + self.contact[x][2] + '</dob>\n<address>' + self.contact[x][3] + '</address>\n<email>' + self.contact[x][4] + '</email>\n<website>' + self.contact[x][5] + '</website>\n<phone>' + self.contact[x][6] + '</phone>\n<notes>' + self.contact[x][7] + '</notes>\n</contact>\n\n')
            x = x + 1
        file.close
        self.contacts.contact=self.contact
        self.contacts.update_list(self.contacts.clist)

    def import_qif(self, obj):
        isaccount=0
        D=""
        M=""
        T=""
        N=""
        P=""
        L=""

        for line in obj:
            if line[0]=='!':
                # Ouverture de compte
                isaccount=1
            if line[0]=='D':
                D=line[1:]
            if line[0]=='M':
                M=line[1:]
            if line[0]=='T':
                T=line[1:]
            if line[0]=='N':
                N=line[1:]
            if line[0]=='P':
                P=line[1:]
            if line[0]=='L':
                L=line[1:]

        if isaccount==1:
            # C'est un compte

            accountexist=0
            self.accountname=L[1:-1]
            x=0
            while x <len(self.account):
                if self.account[x][0] == L[1:-1]:
                    accountexist=1
                x = x + 1

            if accountexist==0:
                self.account.append([self.accountname, '', P, '', '',''])
        else:
            # c'est une opration
            trans=""
            vals=string.split(T,',')
            T=string.join(vals,'')
            if T[0]=='-':
                currenttype="Debit"
                value=-float(T)
            elif T[0]!='-':
                currenttype="Deposit"
                value=float(T)

            if N != "":
                currenttype="Cheque"
            if len(L)>0:
                if L[0]=='[':
                    currenttype="Transfert"
                    trans=L[1:-1]
                    L=""
                else:
                    categoryexist=0
                    x=0
                    while x < len(self.category):
                        if self.category[x][0] == L:
                            categoryexist=1
                        x = x + 1
                    
                    if categoryexist==0:
                        self.category.append([L,''])
            if len(P)>0:
                contactexist=0
                x=0
                while x < len(self.contact):
                    if self.contact[x][0] == P:
                        contactexist=1
                    elif self.contact[x][0]+" "+self.contact[x][1] == P:
                        contactexist=1
                    x=x+1

                if contactexist==0:
                    Pbis= string.split(P,' ',1)
                    if len(Pbis)>1:
                        self.contact.append([Pbis[0], Pbis[1], '', '', '', '', '', ''])
                    else:
                        self.contact.append([P,'', '', '', '', '', '', ''])
            
            if D[-3]=="'":
                date=D[:5] +"/20"+D[-2:]
            if D[-3]=="/":
                date=D[:5] +"/19"+D[-2:]
            
            ladate = time.mktime(time.strptime(date,self.current_type))
            self.operation.append([self.accountname, N, M, L, P,currenttype,"%f" % ladate,"%f" % value,'', trans])
            


    def export_file (self,*args):
        self.not_yet()
        #dlg=GtkExtra.file_save_box(modal=FALSE)


    def get_config(self):
        # open up the bank config file
        file = open(os.environ['HOME'] + '/.bank', 'r')
        # read it
        lines = file.readlines()
        file.close()
        # assign varivles to the different lines
        self.config = []
        self.bankpath=''
        self.dateformat="%d/%m/%Y"
        for line in lines:
            line = string.strip(line)
            self.config.append(line)
            variable=''
            value=''
            if len(line)>0:
                if line[0]!='#':
                    ligne=string.split(line,'=',1)
                    if len(ligne)>1:
                        if ligne[0] == "BANKPATH":
                            self.bankpath=ligne[1]
                        if ligne[0] == "DATEFORMAT":
                            self.dateformat=ligne[1]
        if len(self.bankpath)==0:
            dlg=GtkExtra.message_box("Error in .bank",
                         "Can't find BANKPATH variable\n"+
                         "in "+os.environ['HOME']+"/.bank file", ("OK",),'')

    
    
    def mainloop(self):
        # Dmarrage de la fenetre
        self.window.show()
        mainloop()

    def quit(self,*args):
        # Fermeture de la fenetre
        mainquit()


x=bank()
x.mainloop()

