#!/usr/bin/env python

# $Id: category.py,v 1.2 2002/04/21 10:22:33 cvsd Exp $

from gtk import *
import string, rfc822, re, os,XmlParse
class Categories:
    def __init__(self, parent):
        self.parent = parent
        self.config = self.parent.config
        self.bankpath = self.parent.bankpath
        self.window = self.parent.window
        self.cmap = self.window.get_colormap()
    
        frame=GtkFrame()
        frame.set_usize(-1, -1)
        frame.set_shadow_type("GTK_SHADOW_ETCHED_IN")
        frame.set_label("Categories")
        frame.set_label_align(0, -1)
    
        vbox = GtkVBox()
        frame.add(vbox)
        vbox.show()
    
        # make the toobar
        toolbar = GtkToolbar(ORIENTATION_HORIZONTAL, TOOLBAR_ICONS)
        toolbar.set_button_relief(RELIEF_NONE)
        toolbar.set_space_size(10)
        vbox.pack_start(toolbar, expand=FALSE)
        toolbar.show()
        # add the evolution pixmaps to the toolbar
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/new.xpm")
        toolbar.append_item(None, 'Create a new category', None, GtkPixmap(pix, mask), self.new_category)
    
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/edit.xpm")
        toolbar.append_item(None, 'Edit the selected category', None, GtkPixmap(pix, mask), self.edit_category)
    
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/trash.xpm")
        toolbar.append_item(None, 'Delete the selected category', None, GtkPixmap(pix, mask), self.delete_category)
    
        cscroll = GtkScrolledWindow()
        cscroll.set_policy(POLICY_AUTOMATIC, POLICY_AUTOMATIC)
        vbox.pack_start(cscroll)
        cscroll.show()
    
        clist=GtkCList(1)
        cscroll.add(clist)
        clist.connect("select_row" , self.select_category)
        clist.set_flags(CAN_FOCUS)
        clist.set_usize(-1, 87)
        clist.set_column_title(0, "Name")
        clist.set_column_width(0, 100)
        clist.set_selection_mode(SELECTION_SINGLE)
        clist.column_titles_hide()
        clist.show()
        self.clist=clist
        frame.show()
        self.frame=frame
    
        xml = XmlParse.XmlParse()
        self.xml_categories = xml.parse_xml_file(self.bankpath + '/data/categories.xml', 'category')
    
        self.category = []
        for xml_category in self.xml_categories:
            self.category.append([xml.xml_get_text(xml_category, "name"), xml.xml_get_text(xml_category, "notes")])
        self.update_list(self.clist)
    
    def update_list(self, clist):
        x = 0
        v = 0
        clist_color = self.cmap.alloc("grey87");
        self.category.sort(lambda x, y: cmp(x[0], y[0]))
        clist.clear()
        while x < len(self.category):
            headers = [self.category[x][0]]
            clist.append(headers)
            if v == 0:
                clist.set_background(x, clist_color)
                v = 1
            else:
                v = 0
            x = x + 1
    
    def select_category(self, *args):
        self.selected_category = args[1]
    
    def new_category(self, *args):
        self.do_category("new")
    
    def edit_category(self, *args):
        self.do_category("edit")
    
    def delete_category(self, *args):
        del self.category[self.selected_category]
        self.update_list(self.clist)
        self.update_xml()

    def get_category_name(self, *args):
        self.parent.set_selected_category(self.category[self.selected_category][0])
    
    def save_category(self, *args):
        self.category.append([self.name_entry.get_text(), self.notes_text.get_chars(0, -1)])
        self.update_list(self.clist)
        self.category_window.hide()
        self.update_xml()
    
    def save_edited_category(self, *args):
        self.category[self.selected_category][0] = self.name_entry.get_text()
        self.category[self.selected_category][1] = self.notes_text.get_chars(0, -1)
        self.update_list(self.clist)
        self.select_category(None, self.selected_category)
        self.category_window.hide()
        self.update_xml()
    
    def do_category(self, type, cname='', cemail=''):
        # our main gtk window
        window = GtkWindow(WINDOW_TOPLEVEL)
        self.category_window = window
        window.connect("delete_event", window.hide)
        window.set_title("Bank - Category")
        wscr=screen_width()
        hscr=screen_height()
        
        if wscr>350:
            wscr=350
        if hscr>350:
            hscr=350
        window.set_usize(wscr,hscr)
        window.show()
    
        vbox = GtkVBox()
        window.add(vbox)
        vbox.show()
    
        # make the toobar
        toolbar = GtkToolbar(ORIENTATION_HORIZONTAL, TOOLBAR_ICONS)
        toolbar.set_button_relief(RELIEF_NONE)
        toolbar.set_space_size(10)
        vbox.pack_start(toolbar, expand=FALSE)
        toolbar.show()
        # add the evolution pixmaps to the toolbar
        if type == "edit":
            pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/save.xpm")
            toolbar.append_item(None, 'Save the current categorie', None, GtkPixmap(pix, mask), self.save_edited_category)
        else:
            pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/save.xpm")
            toolbar.append_item(None, 'Save the current categorie', None, GtkPixmap(pix, mask), self.save_category)
    
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/cancel.xpm")
        toolbar.append_item(None, 'Close this window', None, GtkPixmap(pix, mask), window.hide)
    
        table1=GtkTable(8, 2)
        vbox.pack_start(table1)
        table1.set_usize(-1, -1)
        table1.set_row_spacings(0)
        table1.set_col_spacings(0)
        label8=GtkLabel()
        table1.attach(label8, 0, 1, 7, 8, FILL, 0, 0, 0)
        label8.set_usize(-1, -1)
        label8.set_text("Notes")
        label8.set_justify(JUSTIFY_CENTER)
        label8.set_alignment(0, 0.5)
        label8.set_padding(0, 0)
        label8.show()
        self.label8=label8
        name_entry=GtkEntry()
        table1.attach(name_entry, 1, 2, 0, 1, EXPAND, 0, 0, 0)
        name_entry.set_flags(CAN_FOCUS)
        name_entry.set_usize(170, -1)
        name_entry.set_editable(TRUE)
        name_entry.set_visibility(TRUE)
        name_entry.set_max_length(0)
        if type == "edit":
            name_entry.set_text(self.category[self.selected_category][0])
        else:
            name_entry.set_text(cname)
        name_entry.show()
        self.name_entry=name_entry
        
        scrolledwindow2=GtkScrolledWindow()
        table1.attach(scrolledwindow2, 1, 2, 7, 8, FILL, FILL, 0, 0)
        scrolledwindow2.set_usize(170, 60)
        scrolledwindow2.set_policy(POLICY_NEVER, POLICY_AUTOMATIC)
        notes_text=GtkText()
        scrolledwindow2.add(notes_text)
        notes_text.set_flags(CAN_FOCUS)
        notes_text.set_usize(170, 60)
        notes_text.set_editable(TRUE)
        if type == "edit":
            notes_text.insert(None,None,None,self.category[self.selected_category][1])
        notes_text.show()
        self.notes_text=notes_text
        scrolledwindow2.show()
        self.scrolledwindow2=scrolledwindow2
        label1=GtkLabel()
        table1.attach(label1, 0, 1, 0, 1, FILL, 0, 0, 0)
        label1.set_usize(-1, -1)
        label1.set_text("Name")
        label1.set_justify(JUSTIFY_CENTER)
        label1.set_alignment(0, 0.5)
        label1.set_padding(0, 0)
        label1.show()
        self.label1=label1
        table1.show()
        self.table1=table1
    
    def update_xml(self):
        file = open(self.bankpath + '/data/categories.xml', 'w')
        x = 0
        while x < len(self.category):
            file.write('<category>\n<name>' + self.category[x][0] + '</name>\n<notes>' + self.category[x][1] + '</notes>\n</category>\n\n')
            x = x + 1
        file.close
    
