#!/usr/bin/env python

# $Id: contact.py,v 1.3 2002/04/21 10:22:33 cvsd Exp $

# Storm mini Evolution clone by Damien Tanner (dctanner@xoasis.com)

from gtk import *
import string, re, os, time,XmlParse
class Contacts:
    def __init__(self, parent):
        self.parent = parent
        self.config = self.parent.config
        self.bankpath = self.parent.bankpath
        self.window = self.parent.window
        self.cmap = self.window.get_colormap()
    
        frame=GtkFrame()
        frame.set_usize(-1, -1)
        frame.set_shadow_type("GTK_SHADOW_ETCHED_IN")
        frame.set_label("Contacts")
        frame.set_label_align(0, -1)
    
        vpaned = GtkVPaned()
        frame.add(vpaned)
        vpaned.show()
    
        vbox = GtkVBox()
        vpaned.pack1(vbox)
        vbox.show()
    
        # make the toobar
        toolbar = GtkToolbar(ORIENTATION_HORIZONTAL, TOOLBAR_ICONS)
        toolbar.set_button_relief(RELIEF_NONE)
        toolbar.set_space_size(10)
        vbox.pack_start(toolbar, expand=FALSE)
        toolbar.show()
        # add the evolution pixmaps to the toolbar
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/new.xpm")
        toolbar.append_item(None, 'Create a new contact', None, GtkPixmap(pix, mask), self.new_contact)
    
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/edit.xpm")
        toolbar.append_item(None, 'Edit the selected contact', None, GtkPixmap(pix, mask), self.edit_contact)
    
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/trash.xpm")
        toolbar.append_item(None, 'Delete the selected contact', None, GtkPixmap(pix, mask), self.delete_contact)
    
        cscroll = GtkScrolledWindow()
        cscroll.set_policy(POLICY_AUTOMATIC, POLICY_AUTOMATIC)
        vbox.pack_start(cscroll)
        cscroll.show()
    
        clist=GtkCList(2)
        cscroll.add(clist)
        clist.connect("select_row" , self.select_contact)
        clist.set_flags(CAN_FOCUS)
        clist.set_usize(-1, 87)
        clist.set_column_title(0, "Name")
        clist.set_column_title(1, "Email")
        clist.set_column_width(0, 110)
        clist.set_column_width(1, 80)
        clist.set_selection_mode(SELECTION_SINGLE)
        clist.column_titles_hide()
        clist.show()
        self.clist=clist
        frame.show()
        self.frame=frame
    
        scroll = GtkScrolledWindow()
        scroll.set_policy(POLICY_NEVER, POLICY_ALWAYS)
        self.scroll = scroll
        vpaned.pack2(scroll)
        scroll.show()
    
        text = GtkText()
        self.text = text
        text.set_editable(FALSE)
        scroll.add(text)
        text.show()
    
        xml = XmlParse.XmlParse()
        self.xml_contacts = xml.parse_xml_file(self.bankpath + '/data/contacts.xml', 'contact')
    
        self.contact = []
        for xml_contact in self.xml_contacts:
            self.contact.append([xml.xml_get_text(xml_contact, "name"), xml.xml_get_text(xml_contact, "nickname"), xml.xml_get_text(xml_contact, "dob"), xml.xml_get_text(xml_contact, "address"), xml.xml_get_text(xml_contact, "email"), xml.xml_get_text(xml_contact, "website"), xml.xml_get_text(xml_contact, "phone"), xml.xml_get_text(xml_contact, "notes")])
        self.update_list(self.clist)
    
    def update_list(self, clist):
        x = 0
        v = 0
        clist_color = self.cmap.alloc("grey87");
        self.contact.sort(lambda x, y: cmp(x[0], y[0]))
        clist.clear()
        while x < len(self.contact):
            headers = [self.contact[x][0]+" "+self.contact[x][1], self.contact[x][4]]
            clist.append(headers)
            if v == 0:
                clist.set_background(x, clist_color)
                v = 1
            else:
                v = 0
            x = x + 1
    
    def select_contact(self, *args):
        self.text.freeze()
        self.text.delete_text(0, -1)
        self.selected_contact = args[1]
        if self.contact[self.selected_contact][0] != "":
            self.text.insert(None,None,None,"Name: " + self.contact[self.selected_contact][0] + "\n")
        if self.contact[self.selected_contact][4] != "":
            self.text.insert(None,None,None,"Email: " + self.contact[self.selected_contact][4] + "\n")
        if self.contact[self.selected_contact][1] != "":
            self.text.insert(None,None,None,"Nickname: " + self.contact[self.selected_contact][1] + "\n")
        if self.contact[self.selected_contact][6] != "":
            self.text.insert(None,None,None,"Phone: " + self.contact[self.selected_contact][6] + "\n")
        if self.contact[self.selected_contact][5] != "":
            self.text.insert(None,None,None,"Website: " + self.contact[self.selected_contact][5] + "\n")
        if self.contact[self.selected_contact][2] != "":
            self.text.insert(None,None,None,"Birtday: " + self.contact[self.selected_contact][2] + "\n")
        if self.contact[self.selected_contact][3] != "":
            self.text.insert(None,None,None,"Address: " + self.contact[self.selected_contact][3] + "\n")
        if self.contact[self.selected_contact][7] != "":
            self.text.insert(None,None,None,"Notes: " + self.contact[self.selected_contact][7] + "\n")
        vadjust = self.scroll.get_vadjustment()
        vadjust.set_value(0)
        self.text.thaw()
    
    def get_contact_name(self, *args):
        self.parent.set_selected_contact(self.contact[self.selected_contact][0]+" "+self.contact[self.selected_contact][1])

    def new_contact(self, *args):
        self.do_contact("new")
    
    def edit_contact(self, *args):
        self.do_contact("edit")
    
    def delete_contact(self, *args):
        del self.contact[self.selected_contact]
        self.text.delete_text(0, -1)
        self.update_list(self.clist)
        self.update_xml()
    
    def save_contact(self, *args):
        self.contact.append([self.name_entry.get_text(), self.nickname_entry.get_text(), self.birthday_entry.get_text(), self.address_text.get_chars(0, -1), self.email_entry.get_text(), self.website_entry.get_text(), self.phone_entry.get_text(), self.notes_text.get_chars(0, -1)])
        self.update_list(self.clist)
        self.contact_window.hide()
        self.update_xml()
    
    def save_edited_contact(self, *args):
        self.contact[self.selected_contact][0] = self.name_entry.get_text()
        self.contact[self.selected_contact][1] = self.nickname_entry.get_text()
        self.contact[self.selected_contact][2] = self.birthday_entry.get_text()
        self.contact[self.selected_contact][3] = self.address_text.get_chars(0, -1)
        self.contact[self.selected_contact][4] = self.email_entry.get_text()
        self.contact[self.selected_contact][5] = self.website_entry.get_text()
        self.contact[self.selected_contact][6] = self.phone_entry.get_text()
        self.contact[self.selected_contact][7] = self.notes_text.get_chars(0, -1)
        self.update_list(self.clist)
        self.select_contact(None, self.selected_contact)
        self.contact_window.hide()
        self.update_xml()
    
    def do_contact(self, type, cname='', cemail=''):
        # our main gtk window
        window = GtkWindow(WINDOW_TOPLEVEL)
        self.contact_window = window
        window.connect("delete_event", window.hide)
        window.set_title("Bank - Storm - Contact")
        wscr=screen_width()
        hscr=screen_height()
        
        if wscr>350:
            wscr=350
        if hscr>350:
            hscr=350
        window.set_usize(wscr,hscr)
        window.show()
    
        vbox = GtkVBox()
        window.add(vbox)
        vbox.show()
    
        # make the toobar
        toolbar = GtkToolbar(ORIENTATION_HORIZONTAL, TOOLBAR_ICONS)
        toolbar.set_button_relief(RELIEF_NONE)
        toolbar.set_space_size(10)
        vbox.pack_start(toolbar, expand=FALSE)
        toolbar.show()
        # add the evolution pixmaps to the toolbar
        if type == "edit":
            pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/save.xpm")
            toolbar.append_item(None, 'Save the current contact', None, GtkPixmap(pix, mask), self.save_edited_contact)
        else:
            pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/save.xpm")
            toolbar.append_item(None, 'Save the current contact', None, GtkPixmap(pix, mask), self.save_contact)
    
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/cancel.xpm")
        toolbar.append_item(None, 'Close this window', None, GtkPixmap(pix, mask), window.hide)
    
        table1=GtkTable(8, 2)
        vbox.pack_start(table1)
        table1.set_usize(-1, -1)
        table1.set_row_spacings(0)
        table1.set_col_spacings(0)
        label2=GtkLabel()
        table1.attach(label2, 0, 1, 1, 2, FILL, 0, 0, 0)
        label2.set_usize(-1, -1)
        label2.set_text("Email")
        label2.set_justify(JUSTIFY_CENTER)
        label2.set_alignment(0, 0.5)
        label2.set_padding(0, 0)
        label2.show()
        self.label2=label2
        label3=GtkLabel()
        table1.attach(label3, 0, 1, 2, 3, FILL, 0, 0, 0)
        label3.set_usize(-1, -1)
        label3.set_text("Nickname")
        label3.set_justify(JUSTIFY_CENTER)
        label3.set_alignment(0, 0.5)
        label3.set_padding(0, 0)
        label3.show()
        self.label3=label3
        label4=GtkLabel()
        table1.attach(label4, 0, 1, 3, 4, FILL, 0, 0, 0)
        label4.set_usize(-1, -1)
        label4.set_text("Birthday")
        label4.set_justify(JUSTIFY_CENTER)
        label4.set_alignment(0, 0.5)
        label4.set_padding(0, 0)
        label4.show()
        self.label4=label4
        label5=GtkLabel()
        table1.attach(label5, 0, 1, 4, 5, FILL, 0, 0, 0)
        label5.set_usize(-1, -1)
        label5.set_text("Website")
        label5.set_justify(JUSTIFY_CENTER)
        label5.set_alignment(0, 0.5)
        label5.set_padding(0, 0)
        label5.show()
        self.label5=label5
        label6=GtkLabel()
        table1.attach(label6, 0, 1, 5, 6, FILL, 0, 0, 0)
        label6.set_usize(-1, -1)
        label6.set_text("Phone")
        label6.set_justify(JUSTIFY_CENTER)
        label6.set_alignment(0, 0.5)
        label6.set_padding(0, 0)
        label6.show()
        self.label6=label6
        label7=GtkLabel()
        table1.attach(label7, 0, 1, 6, 7, FILL, 0, 0, 0)
        label7.set_usize(-1, -1)
        label7.set_text("Address")
        label7.set_justify(JUSTIFY_CENTER)
        label7.set_alignment(0, 0.5)
        label7.set_padding(0, 0)
        label7.show()
        self.label7=label7
        label8=GtkLabel()
        table1.attach(label8, 0, 1, 7, 8, FILL, 0, 0, 0)
        label8.set_usize(-1, -1)
        label8.set_text("Notes")
        label8.set_justify(JUSTIFY_CENTER)
        label8.set_alignment(0, 0.5)
        label8.set_padding(0, 0)
        label8.show()
        self.label8=label8
        name_entry=GtkEntry()
        table1.attach(name_entry, 1, 2, 0, 1, EXPAND, 0, 0, 0)
        name_entry.set_flags(CAN_FOCUS)
        name_entry.set_usize(170, -1)
        name_entry.set_editable(TRUE)
        name_entry.set_visibility(TRUE)
        name_entry.set_max_length(0)
        if type == "edit":
            name_entry.set_text(self.contact[self.selected_contact][0])
        else:
            name_entry.set_text(cname)
        name_entry.show()
        self.name_entry=name_entry
        email_entry=GtkEntry()
        table1.attach(email_entry, 1, 2, 1, 2, EXPAND, 0, 0, 0)
        email_entry.set_flags(CAN_FOCUS)
        email_entry.set_usize(170, -1)
        email_entry.set_editable(TRUE)
        email_entry.set_visibility(TRUE)
        email_entry.set_max_length(0)
        if type == "edit":
            email_entry.set_text(self.contact[self.selected_contact][4])
        else:
            email_entry.set_text(cemail)
        email_entry.show()
        self.email_entry=email_entry
        nickname_entry=GtkEntry()
        table1.attach(nickname_entry, 1, 2, 2, 3, EXPAND, 0, 0, 0)
        nickname_entry.set_flags(CAN_FOCUS)
        nickname_entry.set_usize(170, -1)
        nickname_entry.set_editable(TRUE)
        nickname_entry.set_visibility(TRUE)
        nickname_entry.set_max_length(0)
        if type == "edit":
            nickname_entry.set_text(self.contact[self.selected_contact][1])
        nickname_entry.show()
        self.nickname_entry=nickname_entry
        birthday_entry=GtkEntry()
        table1.attach(birthday_entry, 1, 2, 3, 4, EXPAND, 0, 0, 0)
        birthday_entry.set_flags(CAN_FOCUS)
        birthday_entry.set_usize(170, -1)
        birthday_entry.set_editable(TRUE)
        birthday_entry.set_visibility(TRUE)
        birthday_entry.set_max_length(0)
        if type == "edit":
            birthday_entry.set_text(self.contact[self.selected_contact][2])
        birthday_entry.show()
        self.birthday_entry=birthday_entry
        website_entry=GtkEntry()
        table1.attach(website_entry, 1, 2, 4, 5, EXPAND, 0, 0, 0)
        website_entry.set_flags(CAN_FOCUS)
        website_entry.set_usize(170, -1)
        website_entry.set_editable(TRUE)
        website_entry.set_visibility(TRUE)
        website_entry.set_max_length(0)
        if type == "edit":
            website_entry.set_text(self.contact[self.selected_contact][5])
        website_entry.show()
        self.website_entry=website_entry
        phone_entry=GtkEntry()
        table1.attach(phone_entry, 1, 2, 5, 6, EXPAND, 0, 0, 0)
        phone_entry.set_flags(CAN_FOCUS)
        phone_entry.set_usize(170, -1)
        phone_entry.set_editable(TRUE)
        phone_entry.set_visibility(TRUE)
        phone_entry.set_max_length(0)
        if type == "edit":
            phone_entry.set_text(self.contact[self.selected_contact][6])
        phone_entry.show()
        self.phone_entry=phone_entry
        scrolledwindow1=GtkScrolledWindow()
        table1.attach(scrolledwindow1, 1, 2, 6, 7, FILL, FILL, 0, 0)
        scrolledwindow1.set_usize(170, 60)
        scrolledwindow1.set_policy(POLICY_NEVER, POLICY_AUTOMATIC)
        address_text=GtkText()
        scrolledwindow1.add(address_text)
        address_text.set_flags(CAN_FOCUS)
        address_text.set_usize(170, 60)
        address_text.set_editable(TRUE)
        if type == "edit":
            address_text.insert(None,None,None,self.contact[self.selected_contact][3])
        address_text.show()
        self.address_text=address_text
        scrolledwindow1.show()
        self.scrolledwindow1=scrolledwindow1
        scrolledwindow2=GtkScrolledWindow()
        table1.attach(scrolledwindow2, 1, 2, 7, 8, FILL, FILL, 0, 0)
        scrolledwindow2.set_usize(170, 60)
        scrolledwindow2.set_policy(POLICY_NEVER, POLICY_AUTOMATIC)
        notes_text=GtkText()
        scrolledwindow2.add(notes_text)
        notes_text.set_flags(CAN_FOCUS)
        notes_text.set_usize(170, 60)
        notes_text.set_editable(TRUE)
        if type == "edit":
            notes_text.insert(None,None,None,self.contact[self.selected_contact][7])
        notes_text.show()
        self.notes_text=notes_text
        scrolledwindow2.show()
        self.scrolledwindow2=scrolledwindow2
        label1=GtkLabel()
        table1.attach(label1, 0, 1, 0, 1, FILL, 0, 0, 0)
        label1.set_usize(-1, -1)
        label1.set_text("Name")
        label1.set_justify(JUSTIFY_CENTER)
        label1.set_alignment(0, 0.5)
        label1.set_padding(0, 0)
        label1.show()
        self.label1=label1
        table1.show()
        self.table1=table1
    
    def update_xml(self):
        file = open(self.bankpath + '/data/contacts.xml', 'w')
        x = 0
        while x < len(self.contact):
            file.write('<contact>\n<name>' + self.contact[x][0] + '</name>\n<nickname>' + self.contact[x][1] + '</nickname>\n<dob>' + self.contact[x][2] + '</dob>\n<address>' + self.contact[x][3] + '</address>\n<email>' + self.contact[x][4] + '</email>\n<website>' + self.contact[x][5] + '</website>\n<phone>' + self.contact[x][6] + '</phone>\n<notes>' + self.contact[x][7] + '</notes>\n</contact>\n\n')
            x = x + 1
        file.close
    
