#!/usr/bin/env python

# $Id: money.py,v 1.3 2002/04/22 17:07:39 cvsd Exp $

from gtk import *
import string, os, account, category, contact, time, GtkExtra, XmlParse

class Money:
    def __init__(self, parent):
        self.parent = parent
        self.config = self.parent.config
        self.dateformat = self.parent.dateformat
        self.bankpath = self.parent.bankpath
        self.window = self.parent.window
        self.cmap = self.window.get_colormap()

        frame = GtkVBox()
        frame.show()
        
        hbox1 = GtkHBox()
        frame.pack_start(hbox1, expand=FALSE)
        hbox1.show()
        
        account = GtkButton()
        hbox1.pack_start(account, FALSE, FALSE, 2)
        lbaccount = GtkLabel()
        account.add(lbaccount)
        lbaccount.set_usize(150, -1)
        lbaccount.set_text("Select an account")
        lbaccount.set_justify(JUSTIFY_CENTER)
        lbaccount.show()
        self.lbaccount=lbaccount
        account.set_usize(150, -1)
        account.connect("clicked",self.select_account)
        account.show()
        self.account = account
        
        hsep = GtkHSeparator()
        hbox1.pack_start(hsep)
        hsep.show()
        
        vbox = GtkVBox()
        frame.pack_start(vbox)
        vbox.show()
        
        # make the toobar
        toolbar = GtkToolbar(ORIENTATION_HORIZONTAL, TOOLBAR_ICONS)
        toolbar.set_button_relief(RELIEF_NONE)
        toolbar.set_space_size(10)
        vbox.pack_start(toolbar, expand=FALSE)
        toolbar.show()
        # add the evolution pixmaps to the toolbar
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/new.xpm")
        toolbar.append_item(None, 'Create a new operation', None, GtkPixmap(pix, mask), self.new_operation)
        
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/edit.xpm")
        toolbar.append_item(None, 'Edit the selected operation', None, GtkPixmap(pix, mask), self.edit_operation)
        
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/trash.xpm")
        toolbar.append_item(None, 'Delete the selected operation', None, GtkPixmap(pix, mask), self.delete_operation)
        
        
        cscroll = GtkScrolledWindow()
        cscroll.set_policy(POLICY_AUTOMATIC, POLICY_AUTOMATIC)
        vbox.pack_start(cscroll)
        cscroll.show()
        
        clist=GtkCList(4)
        cscroll.add(clist)
        clist.connect("select_row" , self.select_operation)
        clist.set_flags(CAN_FOCUS)
        clist.set_usize(-1, 87)
        clist.set_column_title(0, "Total")
        clist.set_column_title(1, "In/Out")
        clist.set_column_title(2, "Date")
        clist.set_column_title(3, "Description")
        clist.set_column_width(0, 50)
        clist.set_column_width(1, 50)
        clist.set_column_width(2, 60)
        clist.set_column_width(3, 80)
        clist.set_selection_mode(SELECTION_SINGLE)
        clist.column_titles_show()
        clist.show()
        self.clist=clist
        frame.show()
        self.frame=frame
        
        xml = XmlParse.XmlParse()
        self.xml_operations = xml.parse_xml_file(self.bankpath + '/data/operations.xml', 'operation')
        self.current_type=''
        self.operation = []
        for xml_operation in self.xml_operations:
            self.operation.append([xml.xml_get_text(xml_operation, "account"), xml.xml_get_text(xml_operation, "number"), xml.xml_get_text(xml_operation, "description"), xml.xml_get_text(xml_operation, "categorie"), xml.xml_get_text(xml_operation, "contact"), xml.xml_get_text(xml_operation, "type"), xml.xml_get_text(xml_operation, "date"), xml.xml_get_text(xml_operation, "value"), xml.xml_get_text(xml_operation, "notes"), xml.xml_get_text(xml_operation, "transfert")])
        self.update_list(self.clist)
        
    def update_list(self, clist):
        x = 0
        v = 0
        i=0
        total=0
        clist_color = self.cmap.alloc("grey87");
        clist_colorneg = self.cmap.alloc("red");
        #self.operation.sort(lambda x, y: cmp(x[6], y[6]))
        self.operation.sort(lambda x, y: cmp(float(x[6]),float( y[6])))
        clist.clear()
        while x < len(self.operation):
            if self.lbaccount.get() == self.operation[x][0] or self.lbaccount.get() == self.operation[x][9] :
                value=0
                if self.operation[x][5] =='Card':
                    value=-float(self.operation[x][7])
                if self.operation[x][5] =='Cash':
                    value=-float(self.operation[x][7])
                if self.operation[x][5] =='Cheque':
                    value=-float(self.operation[x][7])
                if self.operation[x][5] =='Debit':
                    value=-float(self.operation[x][7])
                if self.operation[x][5] =='Deposit':
                    value=float(self.operation[x][7])
                if self.operation[x][5] =='Transfert':
                    value=-float(self.operation[x][7])
                if self.lbaccount.get() == self.operation[x][0]:
                    total=total+value
                    headers = ["%.2f" %total,"%.2f" %value,time.strftime(self.dateformat,(time.localtime(float(self.operation[x][6])))),self.operation[x][2]]
                    clist.append(headers)
                    if v == 0:
                        clist.set_background(i, clist_color)
                        v = 1
                    else:
                        v = 0
                    if total <0:
                        clist.set_foreground(i, clist_colorneg)
                    i=i+1
                if self.lbaccount.get() == self.operation[x][9]:
                    value=-value
                    total=total+value
                    headers = ["%.2f" %total,"%.2f" %value,time.strftime(self.dateformat,(time.localtime(float(self.operation[x][6])))),self.operation[x][2]]
                    clist.append(headers)
                    if v == 0:
                        clist.set_background(i, clist_color)
                        v = 1
                    else:
                        v = 0
                    if total <0:
                        clist.set_foreground(i, clist_colorneg)
                    i=i+1
                 
            x = x + 1
    
    def select_account(self, *args):
        accounts=account.Accounts(self)
        window = GtkWindow(WINDOW_TOPLEVEL)
        self.account_window1 = window
        window.connect("delete_event", window.hide)
        window.set_title("Bank - Accounts")
        wscr=screen_width()
        hscr=screen_height()
        
        if wscr>350:
            wscr=350
        if hscr>350:
            hscr=350
        window.set_usize(wscr,hscr)
        vbox = GtkVBox()
        window.add(vbox)
        vbox.show()
        window.show()
        vbox.pack_start(accounts.frame)

        btnok = GtkButton("Ok")
        vbox.pack_start(btnok,expand=FALSE)
        btnok.set_usize(150, -1)
        btnok.connect("clicked",accounts.get_account_name)
        btnok.show()
        self.btnok = btnok

    def set_selected_account(self,name):
        self.account_window1.hide()
        if self.current_type=="Transfert":
            self.lbto04.set_text("" + name)
        else:
            self.lbaccount.set_text(""+name)

            xml = XmlParse.XmlParse()
            self.xml_operations = xml.parse_xml_file(self.bankpath + '/data/operations.xml', 'operation')
            self.current_type=''
            self.operation = []
            for xml_operation in self.xml_operations:
                self.operation.append([xml.xml_get_text(xml_operation, "account"), xml.xml_get_text(xml_operation, "number"), xml.xml_get_text(xml_operation, "description"), xml.xml_get_text(xml_operation, "categorie"), xml.xml_get_text(xml_operation, "contact"), xml.xml_get_text(xml_operation, "type"), xml.xml_get_text(xml_operation, "date"), xml.xml_get_text(xml_operation, "value"), xml.xml_get_text(xml_operation, "notes"), xml.xml_get_text(xml_operation, "transfert")])

            self.update_list(self.clist)



    def select_operation(self, *args):
        x=0
        i=0
        while x < len(self.operation):
            if self.lbaccount.get() == self.operation[x][0] or self.lbaccount.get() == self.operation[x][9]:
                if self.lbaccount.get() == self.operation[x][0]:
                    if i == args[1]:
                        self.selected_operation = x
                    i=i+1
                if self.lbaccount.get() == self.operation[x][9]:
                    if i == args[1]:
                        self.selected_operation = x
                    i=i+1
            
            x = x + 1

    def select_type(self, *args):
        self.current_type = args[1]
        self.current_type_menuitem.remove_submenu()
        self.current_type_menuitem.hide()
        self.current_type_menuitem = GtkMenuItem(self.current_type)
        self.menubar.append(self.current_type_menuitem)
        self.current_type_menuitem.show()
        self.current_type_menuitem.set_submenu(self.types_menu)
        if self.current_type=="Card":
            self.notebook.set_page(0)
        if self.current_type=="Cash":
            self.notebook.set_page(0)
        if self.current_type=="Cheque":
            self.notebook.set_page(2)
        if self.current_type=="Debit":
            self.notebook.set_page(3)
        if self.current_type=="Deposit":
            self.notebook.set_page(4)
        if self.current_type=="Transfert":
            self.notebook.set_page(5)

    def select_category(self, *args):
        categories = category.Categories(self)
        window = GtkWindow(WINDOW_TOPLEVEL)
        self.category_window1 = window
        window.connect("delete_event", window.hide)
        window.set_title("Bank - Categories")
        window.set_usize(240, 200)
        vbox = GtkVBox()
        window.add(vbox)
        vbox.show()
        window.show()
        vbox.pack_start(categories.frame)

        btnok = GtkButton("Ok")
        vbox.pack_start(btnok,expand=FALSE)
        btnok.set_usize(150, -1)
        btnok.connect("clicked",categories.get_category_name)
        btnok.show()
        self.btnok = btnok

    def set_selected_category(self,name):
        self.category_window1.hide()
        if self.current_type=="Card":
            self.lbcategory.set_text("" + name)
        if self.current_type=="Cash":
            self.lbcategory.set_text("" + name)
        if self.current_type=="Cheque":
            self.lbcategory1.set_text("" + name)
        if self.current_type=="Debit":
            self.lbcategory2.set_text("" + name)
        if self.current_type=="Deposit":
            self.lbcategory3.set_text("" + name)
        if self.current_type=="Transfert":
            self.lbcategory4.set_text("" + name)
    
    def select_contact(self, *args):
        contacts = contact.Contacts(self)
        window = GtkWindow(WINDOW_TOPLEVEL)
        self.contact_window1 = window
        window.connect("delete_event", window.hide)
        window.set_title("Bank - Contacts")
        window.set_usize(240, 200)
        vbox = GtkVBox()
        window.add(vbox)
        vbox.show()
        window.show()
        vbox.pack_start(contacts.frame)

        btnok = GtkButton("Ok")
        vbox.pack_start(btnok,expand=FALSE)
        btnok.set_usize(150, -1)
        btnok.connect("clicked",contacts.get_contact_name)
        btnok.show()
        self.btnok = btnok

    def set_selected_contact(self,name):
        self.contact_window1.hide()
        if self.current_type=="Card":
            i=0
        if self.current_type=="Cash":
            i=0
        if self.current_type=="Cheque":
            self.lbto01.set_text("" + name)
        if self.current_type=="Debit":
            self.lbto02.set_text("" + name)
        if self.current_type=="Deposit":
            self.lbto03.set_text("" + name)
        if self.current_type=="Transfert":
            i=0

    def new_operation(self, *args):
        if self.lbaccount.get() != "Select an account":
            self.do_operation("new")
        else:
            dlg=GtkExtra.message_box("Error",
                         "You must select an account",("OK",))
    
    def edit_operation(self, *args):
        if self.lbaccount.get() != "Select an account":
            self.do_operation("edit")
        else:
            dlg=GtkExtra.message_box("Error",
                         "You must select an account",("OK",))
    
    def delete_operation(self, *args):
        del self.operation[self.selected_operation]
        self.update_list(self.clist)
        self.update_xml()
    
    def select_date(self, *args):
        window = GtkWindow(WINDOW_TOPLEVEL)
        self.date_window1 = window
        window.connect("delete_event", window.hide)
        window.set_title("Bank - Date")
        window.set_usize(150, 150)
        vbox = GtkVBox()
        window.add(vbox)
        vbox.show()
        window.show()
        date1 = GtkCalendar()
        vbox.pack_start(date1)
        date1.show()
        self.date_window=date1
        btnok = GtkButton("Ok")
        vbox.pack_start(btnok,expand=FALSE)
        btnok.set_usize(150, -1)
        btnok.connect("clicked",self.set_selected_date)
        btnok.show()
        self.btnok = btnok

    def set_selected_date(self,*args):
        self.year,self.month,self.day = self.date_window.get_date()
        ladate = time.mktime(time.strptime("%02d/%02d/%d" % (self.day,self.month+1,self.year),"%d/%m/%Y"))
        if self.current_type=="Card":
            self.lbdate.set_text(time.strftime(self.dateformat,(time.localtime(ladate))))
        if self.current_type=="Cash":
            self.lbdate.set_text(time.strftime(self.dateformat,(time.localtime(ladate))))
        if self.current_type=="Cheque":
            self.lbdate1.set_text(time.strftime(self.dateformat,(time.localtime(ladate))))
        if self.current_type=="Debit":
            self.lbdate2.set_text(time.strftime(self.dateformat,(time.localtime(ladate))))
        if self.current_type=="Deposit":
            self.lbdate3.set_text(time.strftime(self.dateformat,(time.localtime(ladate))))
        if self.current_type=="Transfert":
            self.lbdate4.set_text(time.strftime(self.dateformat,(time.localtime(ladate))))
        self.date_window1.hide()

    def save_operation(self, *args): 
        if self.current_type=="Card":
            ladate = time.mktime(time.strptime(self.lbdate.get(),self.dateformat))
            self.operation.append([self.lbaccount.get(), '' ,self.description_entry.get_text(), self.lbcategory.get(),'',self.current_type,"%f" % ladate,self.value_entry.get_text(),self.notes_text.get_chars(0, -1), ''])
        if self.current_type=="Cash":
            ladate = time.mktime(time.strptime(self.lbdate.get(),self.dateformat))
            self.operation.append([self.lbaccount.get(), '' ,self.description_entry.get_text(), self.lbcategory.get(),'',self.current_type,"%f" % ladate,self.value_entry.get_text(),self.notes_text.get_chars(0, -1), ''])
        if self.current_type=="Cheque": 
            ladate = time.mktime(time.strptime(self.lbdate1.get(),self.dateformat))
            self.operation.append([self.lbaccount.get(), self.number1_entry.get_text(),self.description1_entry.get_text(), self.lbcategory1.get(),self.lbto01.get(),self.current_type,"%f" % ladate,self.value1_entry.get_text(),self.notes1_text.get_chars(0, -1), ''])
        if self.current_type=="Debit":
            ladate = time.mktime(time.strptime(self.lbdate2.get(),self.dateformat))
            self.operation.append([self.lbaccount.get(), '',self.description2_entry.get_text(), self.lbcategory2.get(),self.lbto02.get(),self.current_type,"%f" % ladate,self.value2_entry.get_text(),self.notes2_text.get_chars(0, -1), ''])
        if self.current_type=="Deposit":
            ladate = time.mktime(time.strptime(self.lbdate3.get(),self.dateformat))
            self.operation.append([self.lbaccount.get(), '',self.description3_entry.get_text(), self.lbcategory3.get(),self.lbto03.get(),self.current_type,"%f" % ladate,self.value3_entry.get_text(),self.notes3_text.get_chars(0, -1), ''])
        if self.current_type=="Transfert":
            ladate = time.mktime(time.strptime(self.lbdate4.get(),self.dateformat))
            self.operation.append([self.lbaccount.get(), '',self.description4_entry.get_text(), self.lbcategory4.get(),'',self.current_type,"%f" % ladate,self.value4_entry.get_text(),self.notes4_text.get_chars(0, -1), self.lbto04.get()])
        self.update_list(self.clist)
        self.current_type =''
        self.operation_window.hide()
        self.update_xml()
    
    def save_edited_operation(self, *args):
        self.operation[self.selected_operation][5] = self.current_type
        if self.current_type=="Card": 
            ladate = time.mktime(time.strptime(self.lbdate.get(),self.dateformat))
            self.operation[self.selected_operation][1] = ''
            self.operation[self.selected_operation][2] = self.description_entry.get_text()
            self.operation[self.selected_operation][3] = self.lbcategory.get()
            self.operation[self.selected_operation][4] = ''
            self.operation[self.selected_operation][6] = "%f" % ladate
            self.operation[self.selected_operation][7] = self.value_entry.get_text()
            self.operation[self.selected_operation][8] = self.notes_text.get_chars(0, -1)
            self.operation[self.selected_operation][9] = ''
        if self.current_type=="Cash":
            ladate = time.mktime(time.strptime(self.lbdate.get(),self.dateformat))
            self.operation[self.selected_operation][1] = ''
            self.operation[self.selected_operation][2] = self.description_entry.get_text()
            self.operation[self.selected_operation][3] = self.lbcategory.get()
            self.operation[self.selected_operation][4] = ''
            self.operation[self.selected_operation][6] = "%f" % ladate
            self.operation[self.selected_operation][7] = self.value_entry.get_text()
            self.operation[self.selected_operation][8] = self.notes_text.get_chars(0, -1)
            self.operation[self.selected_operation][9] = ''
        if self.current_type=="Cheque":
            ladate = time.mktime(time.strptime(self.lbdate1.get(),self.dateformat))
            self.operation[self.selected_operation][1] = self.number1_entry.get_text()
            self.operation[self.selected_operation][2] = self.description1_entry.get_text()
            self.operation[self.selected_operation][3] = self.lbcategory1.get()
            self.operation[self.selected_operation][4] = self.lbto01.get()
            self.operation[self.selected_operation][6] = "%f" % ladate
            self.operation[self.selected_operation][7] = self.value1_entry.get_text()
            self.operation[self.selected_operation][8] = self.notes1_text.get_chars(0, -1)
            self.operation[self.selected_operation][9] = ''
        if self.current_type=="Debit":
            ladate = time.mktime(time.strptime(self.lbdate2.get(),self.dateformat))
            self.operation[self.selected_operation][1] = ''
            self.operation[self.selected_operation][2] = self.description2_entry.get_text()
            self.operation[self.selected_operation][3] = self.lbcategory2.get()
            self.operation[self.selected_operation][4] = self.lbto02.get()
            self.operation[self.selected_operation][6] = "%f" % ladate
            self.operation[self.selected_operation][7] = self.value2_entry.get_text()
            self.operation[self.selected_operation][8] = self.notes2_text.get_chars(0, -1)
            self.operation[self.selected_operation][9] = ''
        if self.current_type=="Deposit":
            ladate = time.mktime(time.strptime(self.lbdate3.get(),self.dateformat))
            self.operation[self.selected_operation][1] = ''
            self.operation[self.selected_operation][2] = self.description3_entry.get_text()
            self.operation[self.selected_operation][3] = self.lbcategory3.get()
            self.operation[self.selected_operation][4] = self.lbto03.get()
            self.operation[self.selected_operation][6] = "%f" % ladate
            self.operation[self.selected_operation][7] = self.value3_entry.get_text()
            self.operation[self.selected_operation][8] = self.notes3_text.get_chars(0, -1)
            self.operation[self.selected_operation][9] = ''
        if self.current_type=="Transfert":
            ladate = time.mktime(time.strptime(self.lbdate4.get(),self.dateformat))
            self.operation[self.selected_operation][1] = ''
            self.operation[self.selected_operation][2] = self.description4_entry.get_text()
            self.operation[self.selected_operation][3] = self.lbcategory4.get()
            self.operation[self.selected_operation][4] = ''
            self.operation[self.selected_operation][6] = "%f" % ladate
            self.operation[self.selected_operation][7] = self.value4_entry.get_text()
            self.operation[self.selected_operation][8] = self.notes4_text.get_chars(0, -1)
            self.operation[self.selected_operation][9] = self.lbto04.get()
        self.update_list(self.clist)
        self.select_operation(None, self.selected_operation)
        self.current_type =''
        self.operation_window.hide()
        self.update_xml()

    def close_operation (self, *args):
        self.current_type =''
        self.operation_window.hide()
    
    def do_operation(self, type, cname='', cemail=''):
        # our main gtk window
        window = GtkWindow(WINDOW_TOPLEVEL)
        self.operation_window = window
        window.connect("delete_event", self.close_operation)
        window.set_title("Bank - Operation")
        wscr=screen_width()
        hscr=screen_height()
        
        if wscr>350:
            wscr=350
        if hscr>350:
            hscr=350
        window.set_usize(wscr,hscr)
        window.show()
    
        vbox = GtkVBox()
        window.add(vbox)
        vbox.show()
        
        # make the toobar
        toolbar = GtkToolbar(ORIENTATION_HORIZONTAL, TOOLBAR_ICONS)
        toolbar.set_button_relief(RELIEF_NONE)
        toolbar.set_space_size(10)
        vbox.pack_start(toolbar, expand=FALSE)
        toolbar.show()
        # add the evolution pixmaps to the toolbar
        if type == "edit":
            pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/save.xpm")
            toolbar.append_item(None, 'Save the current operation', None, GtkPixmap(pix, mask), self.save_edited_operation)
        else:
            pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/save.xpm")
            toolbar.append_item(None, 'Save the current operation', None, GtkPixmap(pix, mask), self.save_operation)
    
        pix, mask = create_pixmap_from_xpm(self.window, None, self.bankpath + "/pixmaps/cancel.xpm")
        toolbar.append_item(None, 'Close this window', None, GtkPixmap(pix, mask), self.close_operation)
        
        hbox1 = GtkHBox()
        vbox.pack_start(hbox1, expand=FALSE)
        hbox1.show()
    
        self.menubar = GtkMenuBar()
        self.menubar.set_shadow_type(SHADOW_NONE)
        hbox1.pack_start(self.menubar, FALSE, FALSE, 2)
        self.menubar.show()
    
        self.current_type_menuitem = GtkMenuItem("Debit")
        self.menubar.append(self.current_type_menuitem)
        self.current_type_menuitem.show()
        self.current_type="Debit"

        
        self.types_menu = GtkMenu()
        self.current_type_menuitem.set_submenu(self.types_menu)
        self.types_menu.show()
        
        self.type_menuitem = GtkMenuItem("Card")
        self.type_menuitem.connect("activate", self.select_type, "Card")
        self.types_menu.append(self.type_menuitem)
        self.type_menuitem.show()

        self.type_menuitem = GtkMenuItem("Cash")
        self.type_menuitem.connect("activate", self.select_type, "Cash")
        self.types_menu.append(self.type_menuitem)
        self.type_menuitem.show()

        self.type_menuitem = GtkMenuItem("Cheque")
        self.type_menuitem.connect("activate", self.select_type, "Cheque")
        self.types_menu.append(self.type_menuitem)
        self.type_menuitem.show()

        self.type_menuitem = GtkMenuItem("Debit")
        self.type_menuitem.connect("activate", self.select_type, "Debit")
        self.types_menu.append(self.type_menuitem)
        self.type_menuitem.show()

        self.type_menuitem = GtkMenuItem("Deposit")
        self.type_menuitem.connect("activate", self.select_type, "Deposit")
        self.types_menu.append(self.type_menuitem)
        self.type_menuitem.show()

        self.type_menuitem = GtkMenuItem("Transfert")
        self.type_menuitem.connect("activate", self.select_type, "Transfert")
        self.types_menu.append(self.type_menuitem)
        self.type_menuitem.show()

        hsep = GtkHSeparator()
        hbox1.pack_start(hsep)
        hsep.show()
        
        notebook = GtkNotebook()
        vbox.pack_start(notebook)
        notebook.show()
        notebook.set_show_tabs(FALSE)
        notebook.set_show_border(FALSE)
        self.notebook=notebook

        # Card
        table1=GtkTable(8, 2)
        notebook.add(table1)
        table1.set_usize(-1, -1)
        table1.set_row_spacings(0)
        table1.set_col_spacings(0)
        label1=GtkLabel()
        table1.attach(label1, 0, 1, 0, 1, FILL, 0, 0, 0)
        label1.set_usize(-1, -1)
        label1.set_text("Description :")
        label1.set_justify(JUSTIFY_CENTER)
        label1.set_alignment(0, 0.5)
        label1.set_padding(0, 0)
        label1.show()
        self.label1=label1

        label2=GtkLabel()
        table1.attach(label2, 0, 1, 2, 3, FILL, 0, 0, 0)
        label2.set_usize(-1, -1)
        label2.set_text("Category :")
        label2.set_justify(JUSTIFY_CENTER)
        label2.set_alignment(0, 0.5)
        label2.set_padding(0, 0)
        label2.show()
        self.label2=label2

        label3=GtkLabel()
        table1.attach(label3, 0, 1, 3, 4, FILL, 0, 0, 0)
        label3.set_usize(-1, -1)
        label3.set_text("Date :")
        label3.set_justify(JUSTIFY_CENTER)
        label3.set_alignment(0, 0.5)
        label3.set_padding(0, 0)
        label3.show()
        self.label3=label3

        label4=GtkLabel()
        table1.attach(label4, 0, 1, 4,5, FILL, 0, 0, 0)
        label4.set_usize(-1, -1)
        label4.set_text("Value :")
        label4.set_justify(JUSTIFY_CENTER)
        label4.set_alignment(0, 0.5)
        label4.set_padding(0, 0)
        label4.show()
        self.label4=label4

        label5=GtkLabel()
        table1.attach(label5, 0, 1, 5, 6, FILL, 0, 0, 0)
        label5.set_usize(-1, -1)
        label5.set_text("Notes :")
        label5.set_justify(JUSTIFY_CENTER)
        label5.set_alignment(0, 0.5)
        label5.set_padding(0, 0)
        label5.show()
        self.label5=label5
        description_entry=GtkEntry()
        table1.attach(description_entry, 1, 2, 0, 1, EXPAND, 0, 0, 0)
        description_entry.set_flags(CAN_FOCUS)
        description_entry.set_usize(170, -1)
        description_entry.set_editable(TRUE)
        description_entry.set_visibility(TRUE)
        description_entry.set_max_length(0)
        if type == "edit":
            description_entry.set_text(self.operation[self.selected_operation][2])
        description_entry.show()
        self.description_entry=description_entry

        
        category_button = GtkButton()
        table1.attach(category_button, 1, 2, 2, 3, EXPAND, 0, 0, 0)
        lbcategory = GtkLabel()
        category_button.add(lbcategory)
        lbcategory.set_usize(170, -1)
        lbcategory.set_text("Select a category")
        lbcategory.set_justify(JUSTIFY_CENTER)
        if type == "edit":
            lbcategory.set_text(self.operation[self.selected_operation][3])
        lbcategory.show()
        self.lbcategory=lbcategory
        category_button.set_usize(170, -1)
        category_button.connect("clicked",self.select_category)
        category_button.show()
        self.category_button = category_button

        date_button = GtkButton()
        table1.attach(date_button, 1, 2, 3, 4, EXPAND, 0, 0, 0)
        lbdate = GtkLabel()
        date_button.add(lbdate)
        lbdate.set_usize(170, -1)
        lbdate.set_text("Select a date")
        lbdate.set_justify(JUSTIFY_CENTER)
        if type == "edit":
            lbdate.set_text(time.strftime(self.dateformat,(time.localtime(float(self.operation[self.selected_operation][6])))))
        lbdate.show()
        self.lbdate=lbdate
        date_button.set_usize(170, -1)
        date_button.connect("clicked",self.select_date)
        date_button.show()
        self.date_button = date_button

        value_entry=GtkEntry()
        table1.attach(value_entry, 1, 2, 4, 5, EXPAND, 0, 0, 0)
        value_entry.set_flags(CAN_FOCUS)
        value_entry.set_usize(170, -1)
        value_entry.set_editable(TRUE)
        value_entry.set_visibility(TRUE)
        value_entry.set_max_length(0)
        if type == "edit":
            value_entry.set_text(self.operation[self.selected_operation][7])
        value_entry.show()
        self.value_entry=value_entry
        
        scrolledwindow2=GtkScrolledWindow()
        table1.attach(scrolledwindow2, 1, 2, 5, 6, FILL, FILL, 0, 0)
        scrolledwindow2.set_usize(170, 60)
        scrolledwindow2.set_policy(POLICY_NEVER, POLICY_AUTOMATIC)
        notes_text=GtkText()
        scrolledwindow2.add(notes_text)
        notes_text.set_flags(CAN_FOCUS)
        notes_text.set_usize(170, 60)
        notes_text.set_editable(TRUE)
        if type == "edit":
            notes_text.insert(None,None,None,self.operation[self.selected_operation][8])
        notes_text.show()
        self.notes_text=notes_text
        scrolledwindow2.show()
        self.scrolledwindow2=scrolledwindow2
        table1.show()
        self.table1=table1

        # Cash
        table2=GtkTable(8, 2)
        notebook.add(table2)
        table2.show()
        self.table2=table2
        # Cheque
        table3=GtkTable(8, 2)
        notebook.add(table3)

        label7=GtkLabel()
        table3.attach(label7, 0, 1, 0, 1, FILL, 0, 0, 0)
        label7.set_usize(-1, -1)
        label7.set_text("Description :")
        label7.set_justify(JUSTIFY_CENTER)
        label7.set_alignment(0, 0.5)
        label7.set_padding(0, 0)
        label7.show()
        self.label7=label7

        label6=GtkLabel()
        table3.attach(label6, 0, 1, 1, 2, FILL, 0, 0, 0)
        label6.set_usize(-1, -1)
        label6.set_text("To :")
        label6.set_justify(JUSTIFY_CENTER)
        label6.set_alignment(0, 0.5)
        label6.set_padding(0, 0)
        label6.show()
        self.label6=label6


        label8=GtkLabel()
        table3.attach(label8, 0, 1, 2, 3, FILL, 0, 0, 0)
        label8.set_usize(-1, -1)
        label8.set_text("Category :")
        label8.set_justify(JUSTIFY_CENTER)
        label8.set_alignment(0, 0.5)
        label8.set_padding(0, 0)
        label8.show()
        self.label8=label8

        label9=GtkLabel()
        table3.attach(label9, 0, 1, 3, 4, FILL, 0, 0, 0)
        label9.set_usize(-1, -1)
        label9.set_text("Date :")
        label9.set_justify(JUSTIFY_CENTER)
        label9.set_alignment(0, 0.5)
        label9.set_padding(0, 0)
        label9.show()
        self.label9=label9

        label10=GtkLabel()
        table3.attach(label10, 0, 1, 4,5, FILL, 0, 0, 0)
        label10.set_usize(-1, -1)
        label10.set_text("Value :")
        label10.set_justify(JUSTIFY_CENTER)
        label10.set_alignment(0, 0.5)
        label10.set_padding(0, 0)
        label10.show()
        self.label10=label10

        label11=GtkLabel()
        table3.attach(label11, 0, 1, 5, 6, FILL, 0, 0, 0)
        label11.set_usize(-1, -1)
        label11.set_text("Number :")
        label11.set_justify(JUSTIFY_CENTER)
        label11.set_alignment(0, 0.5)
        label11.set_padding(0, 0)
        label11.show()
        self.label11=label11

        label12=GtkLabel()
        table3.attach(label12, 0, 1, 6, 7, FILL, 0, 0, 0)
        label12.set_usize(-1, -1)
        label12.set_text("Notes :")
        label12.set_justify(JUSTIFY_CENTER)
        label12.set_alignment(0, 0.5)
        label12.set_padding(0, 0)
        label12.show()
        self.label12=label12

        description1_entry=GtkEntry()
        table3.attach(description1_entry, 1, 2, 0, 1, EXPAND, 0, 0, 0)
        description1_entry.set_flags(CAN_FOCUS)
        description1_entry.set_usize(170, -1)
        description1_entry.set_editable(TRUE)
        description1_entry.set_visibility(TRUE)
        description1_entry.set_max_length(0)
        if type == "edit":
            description1_entry.set_text(self.operation[self.selected_operation][2])
        description1_entry.show()
        self.description1_entry=description1_entry

                             
        to1_button = GtkButton()
        table3.attach(to1_button, 1, 2, 1, 2, EXPAND, 0, 0, 0)
        lbto01 = GtkLabel()
        to1_button.add(lbto01)
        lbto01.set_usize(170, -1)
        lbto01.set_text("Select a contact")
        lbto01.set_justify(JUSTIFY_CENTER)
        if type == "edit":
            lbto01.set_text(self.operation[self.selected_operation][4])
        lbto01.show()
        self.lbto01=lbto01
        to1_button.set_usize(170, -1)
        to1_button.connect("clicked",self.select_contact)
        to1_button.show()
        self.to1_button = to1_button
        
        category1_button = GtkButton()
        table3.attach(category1_button, 1, 2, 2, 3, EXPAND, 0, 0, 0)
        lbcategory1 = GtkLabel()
        category1_button.add(lbcategory1)
        lbcategory1.set_usize(170, -1)
        lbcategory1.set_text("Select a category")
        lbcategory1.set_justify(JUSTIFY_CENTER)
        if type == "edit":
            lbcategory1.set_text(self.operation[self.selected_operation][3])
        lbcategory1.show()
        self.lbcategory1=lbcategory1
        category1_button.set_usize(170, -1)
        category1_button.connect("clicked",self.select_category)
        category1_button.show()
        self.category1_button = category1_button

        date1_button = GtkButton()
        table3.attach(date1_button, 1, 2, 3, 4, EXPAND, 0, 0, 0)
        lbdate1 = GtkLabel()
        date1_button.add(lbdate1)
        lbdate1.set_usize(170, -1)
        lbdate1.set_text("Select a date")
        lbdate1.set_justify(JUSTIFY_CENTER)
        if type == "edit":
            lbdate1.set_text(time.strftime(self.dateformat,(time.localtime(float(self.operation[self.selected_operation][6])))))
        lbdate1.show()
        self.lbdate1=lbdate1
        date1_button.set_usize(170, -1)
        date1_button.connect("clicked",self.select_date)
        date1_button.show()
        self.date1_button = date1_button

        value1_entry=GtkEntry()
        table3.attach(value1_entry, 1, 2, 4, 5, EXPAND, 0, 0, 0)
        value1_entry.set_flags(CAN_FOCUS)
        value1_entry.set_usize(170, -1)
        value1_entry.set_editable(TRUE)
        value1_entry.set_visibility(TRUE)
        value1_entry.set_max_length(0)
        if type == "edit":
            value1_entry.set_text(self.operation[self.selected_operation][7])
        value1_entry.show()
        self.value1_entry=value1_entry
        
        number1_entry=GtkEntry()
        table3.attach(number1_entry, 1, 2, 5, 6, EXPAND, 0, 0, 0)
        number1_entry.set_flags(CAN_FOCUS)
        number1_entry.set_usize(170, -1)
        number1_entry.set_editable(TRUE)
        number1_entry.set_visibility(TRUE)
        number1_entry.set_max_length(0)
        if type == "edit":
            number1_entry.set_text(self.operation[self.selected_operation][1])
        number1_entry.show()
        self.number1_entry=number1_entry
        
        scrolledwindow3=GtkScrolledWindow()
        table3.attach(scrolledwindow3, 1, 2, 6, 7, FILL, FILL, 0, 0)
        scrolledwindow3.set_usize(170, 60)
        scrolledwindow3.set_policy(POLICY_NEVER, POLICY_AUTOMATIC)
        notes1_text=GtkText()
        scrolledwindow3.add(notes1_text)
        notes1_text.set_flags(CAN_FOCUS)
        notes1_text.set_usize(170, 60)
        notes1_text.set_editable(TRUE)
        if type == "edit":
            notes1_text.insert(None,None,None,self.operation[self.selected_operation][8])
        notes1_text.show()
        self.notes1_text=notes1_text
        scrolledwindow3.show()
        self.scrolledwindow3=scrolledwindow3
        table3.show()
        self.table3=table3
        # Debit
        table4=GtkTable(8, 2)
        notebook.add(table4)
        label13=GtkLabel()
        table4.attach(label13, 0, 1, 0, 1, FILL, 0, 0, 0)
        label13.set_usize(-1, -1)
        label13.set_text("Description :")
        label13.set_justify(JUSTIFY_CENTER)
        label13.set_alignment(0, 0.5)
        label13.set_padding(0, 0)
        label13.show()
        self.label13=label13

        label14=GtkLabel()
        table4.attach(label14, 0, 1, 1, 2, FILL, 0, 0, 0)
        label14.set_usize(-1, -1)
        label14.set_text("To :")
        label14.set_justify(JUSTIFY_CENTER)
        label14.set_alignment(0, 0.5)
        label14.set_padding(0, 0)
        label14.show()
        self.label14=label14

        label15=GtkLabel()
        table4.attach(label15, 0, 1, 2, 3, FILL, 0, 0, 0)
        label15.set_usize(-1, -1)
        label15.set_text("Category :")
        label15.set_justify(JUSTIFY_CENTER)
        label15.set_alignment(0, 0.5)
        label15.set_padding(0, 0)
        label15.show()
        self.label15=label15

        label16=GtkLabel()
        table4.attach(label16, 0, 1, 3, 4, FILL, 0, 0, 0)
        label16.set_usize(-1, -1)
        label16.set_text("Date :")
        label16.set_justify(JUSTIFY_CENTER)
        label16.set_alignment(0, 0.5)
        label16.set_padding(0, 0)
        label16.show()
        self.label16=label16

        label17=GtkLabel()
        table4.attach(label17, 0, 1, 4,5, FILL, 0, 0, 0)
        label17.set_usize(-1, -1)
        label17.set_text("Value :")
        label17.set_justify(JUSTIFY_CENTER)
        label17.set_alignment(0, 0.5)
        label17.set_padding(0, 0)
        label17.show()
        self.label17=label17

        label18=GtkLabel()
        table4.attach(label18, 0, 1, 6, 7, FILL, 0, 0, 0)
        label18.set_usize(-1, -1)
        label18.set_text("Notes :")
        label18.set_justify(JUSTIFY_CENTER)
        label18.set_alignment(0, 0.5)
        label18.set_padding(0, 0)
        label18.show()
        self.label18=label18

        description2_entry=GtkEntry()
        table4.attach(description2_entry, 1, 2, 0, 1, EXPAND, 0, 0, 0)
        description2_entry.set_flags(CAN_FOCUS)
        description2_entry.set_usize(170, -1)
        description2_entry.set_editable(TRUE)
        description2_entry.set_visibility(TRUE)
        description2_entry.set_max_length(0)
        if type == "edit":
            description2_entry.set_text(self.operation[self.selected_operation][2])
        description2_entry.show()
        self.description2_entry=description2_entry

                             
        to2_button = GtkButton()
        table4.attach(to2_button, 1, 2, 1, 2, EXPAND, 0, 0, 0)
        lbto02 = GtkLabel()
        to2_button.add(lbto02)
        lbto02.set_usize(170, -1)
        lbto02.set_text("Select a contact")
        lbto02.set_justify(JUSTIFY_CENTER)
        if type == "edit":
            lbto02.set_text(self.operation[self.selected_operation][4])
        lbto02.show()
        self.lbto02=lbto02
        to2_button.set_usize(170, -1)
        to2_button.connect("clicked",self.select_contact)
        to2_button.show()
        self.to2_button = to2_button
        
        category2_button = GtkButton()
        table4.attach(category2_button, 1, 2, 2, 3, EXPAND, 0, 0, 0)
        lbcategory2 = GtkLabel()
        category2_button.add(lbcategory2)
        lbcategory2.set_usize(170, -1)
        lbcategory2.set_text("Select a category")
        lbcategory2.set_justify(JUSTIFY_CENTER)
        if type == "edit":
            lbcategory2.set_text(self.operation[self.selected_operation][3])
        lbcategory2.show()
        self.lbcategory2=lbcategory2
        category2_button.set_usize(170, -1)
        category2_button.connect("clicked",self.select_category)
        category2_button.show()
        self.category2_button = category2_button

        date2_button = GtkButton()
        table4.attach(date2_button, 1, 2, 3, 4, EXPAND, 0, 0, 0)
        lbdate2 = GtkLabel()
        date2_button.add(lbdate2)
        lbdate2.set_usize(170, -1)
        lbdate2.set_text("Select a date")
        lbdate2.set_justify(JUSTIFY_CENTER)
        if type == "edit":
            lbdate2.set_text(time.strftime(self.dateformat,(time.localtime(float(self.operation[self.selected_operation][6])))))
        lbdate2.show()
        self.lbdate2=lbdate2
        date2_button.set_usize(170, -1)
        date2_button.connect("clicked",self.select_date)
        date2_button.show()
        self.date2_button = date2_button

        value2_entry=GtkEntry()
        table4.attach(value2_entry, 1, 2, 4, 5, EXPAND, 0, 0, 0)
        value2_entry.set_flags(CAN_FOCUS)
        value2_entry.set_usize(170, -1)
        value2_entry.set_editable(TRUE)
        value2_entry.set_visibility(TRUE)
        value2_entry.set_max_length(0)
        if type == "edit":
            value2_entry.set_text(self.operation[self.selected_operation][7])
        value2_entry.show()
        self.value2_entry=value2_entry
        
        scrolledwindow4=GtkScrolledWindow()
        table4.attach(scrolledwindow4, 1, 2, 6, 7, FILL, FILL, 0, 0)
        scrolledwindow4.set_usize(170, 60)
        scrolledwindow4.set_policy(POLICY_NEVER, POLICY_AUTOMATIC)
        notes2_text=GtkText()
        scrolledwindow4.add(notes2_text)
        notes2_text.set_flags(CAN_FOCUS)
        notes2_text.set_usize(170, 60)
        notes2_text.set_editable(TRUE)
        if type == "edit":
            notes2_text.insert(None,None,None,self.operation[self.selected_operation][8])
        notes2_text.show()
        self.notes2_text=notes2_text
        scrolledwindow4.show()
        self.scrolledwindow4=scrolledwindow4
        table4.show()
        self.table4=table4
        # Deposit
        table5=GtkTable(8, 2)
        notebook.add(table5)
        label19=GtkLabel()
        table5.attach(label19, 0, 1, 0, 1, FILL, 0, 0, 0)
        label19.set_usize(-1, -1)
        label19.set_text("Description :")
        label19.set_justify(JUSTIFY_CENTER)
        label19.set_alignment(0, 0.5)
        label19.set_padding(0, 0)
        label19.show()
        self.label19=label19

        label20=GtkLabel()
        table5.attach(label20, 0, 1, 1, 2, FILL, 0, 0, 0)
        label20.set_usize(-1, -1)
        label20.set_text("From :")
        label20.set_justify(JUSTIFY_CENTER)
        label20.set_alignment(0, 0.5)
        label20.set_padding(0, 0)
        label20.show()
        self.label20=label20

        label21=GtkLabel()
        table5.attach(label21, 0, 1, 2, 3, FILL, 0, 0, 0)
        label21.set_usize(-1, -1)
        label21.set_text("Category :")
        label21.set_justify(JUSTIFY_CENTER)
        label21.set_alignment(0, 0.5)
        label21.set_padding(0, 0)
        label21.show()
        self.label21=label21

        label22=GtkLabel()
        table5.attach(label22, 0, 1, 3, 4, FILL, 0, 0, 0)
        label22.set_usize(-1, -1)
        label22.set_text("Date :")
        label22.set_justify(JUSTIFY_CENTER)
        label22.set_alignment(0, 0.5)
        label22.set_padding(0, 0)
        label22.show()
        self.label22=label22

        label23=GtkLabel()
        table5.attach(label23, 0, 1, 4,5, FILL, 0, 0, 0)
        label23.set_usize(-1, -1)
        label23.set_text("Value :")
        label23.set_justify(JUSTIFY_CENTER)
        label23.set_alignment(0, 0.5)
        label23.set_padding(0, 0)
        label23.show()
        self.label23=label23

        label24=GtkLabel()
        table5.attach(label24, 0, 1, 6, 7, FILL, 0, 0, 0)
        label24.set_usize(-1, -1)
        label24.set_text("Notes :")
        label24.set_justify(JUSTIFY_CENTER)
        label24.set_alignment(0, 0.5)
        label24.set_padding(0, 0)
        label24.show()
        self.label24=label24

        description3_entry=GtkEntry()
        table5.attach(description3_entry, 1, 2, 0, 1, EXPAND, 0, 0, 0)
        description3_entry.set_flags(CAN_FOCUS)
        description3_entry.set_usize(170, -1)
        description3_entry.set_editable(TRUE)
        description3_entry.set_visibility(TRUE)
        description3_entry.set_max_length(0)
        if type == "edit":
            description3_entry.set_text(self.operation[self.selected_operation][2])
        description3_entry.show()
        self.description3_entry=description3_entry

                             
        to3_button = GtkButton()
        table5.attach(to3_button, 1, 2, 1, 2, EXPAND, 0, 0, 0)
        lbto03 = GtkLabel()
        to3_button.add(lbto03)
        lbto03.set_usize(170, -1)
        lbto03.set_text("Select a contact")
        lbto03.set_justify(JUSTIFY_CENTER)
        if type == "edit":
            lbto03.set_text(self.operation[self.selected_operation][4])
        lbto03.show()
        self.lbto03=lbto03
        to3_button.set_usize(170, -1)
        to3_button.connect("clicked",self.select_contact)
        to3_button.show()
        self.to3_button = to3_button
        
        category3_button = GtkButton()
        table5.attach(category3_button, 1, 2, 2, 3, EXPAND, 0, 0, 0)
        lbcategory3 = GtkLabel()
        category3_button.add(lbcategory3)
        lbcategory3.set_usize(170, -1)
        lbcategory3.set_text("Select a category")
        lbcategory3.set_justify(JUSTIFY_CENTER)
        if type == "edit":
            lbcategory3.set_text(self.operation[self.selected_operation][3])
        lbcategory3.show()
        self.lbcategory3=lbcategory3
        category3_button.set_usize(170, -1)
        category3_button.connect("clicked",self.select_category)
        category3_button.show()
        self.category3_button = category3_button

        date3_button = GtkButton()
        table5.attach(date3_button, 1, 2, 3, 4, EXPAND, 0, 0, 0)
        lbdate3 = GtkLabel()
        date3_button.add(lbdate3)
        lbdate3.set_usize(170, -1)
        lbdate3.set_text("Select a date")
        lbdate3.set_justify(JUSTIFY_CENTER)
        if type == "edit":
            lbdate3.set_text(time.strftime(self.dateformat,(time.localtime(float(self.operation[self.selected_operation][6])))))
        lbdate3.show()
        self.lbdate3=lbdate3
        date3_button.set_usize(170, -1)
        date3_button.connect("clicked",self.select_date)
        date3_button.show()
        self.date3_button = date3_button

        value3_entry=GtkEntry()
        table5.attach(value3_entry, 1, 2, 4, 5, EXPAND, 0, 0, 0)
        value3_entry.set_flags(CAN_FOCUS)
        value3_entry.set_usize(170, -1)
        value3_entry.set_editable(TRUE)
        value3_entry.set_visibility(TRUE)
        value3_entry.set_max_length(0)
        if type == "edit":
            value3_entry.set_text(self.operation[self.selected_operation][7])
        value3_entry.show()
        self.value3_entry=value3_entry
        
        scrolledwindow5=GtkScrolledWindow()
        table5.attach(scrolledwindow5, 1, 2, 6, 7, FILL, FILL, 0, 0)
        scrolledwindow5.set_usize(170, 60)
        scrolledwindow5.set_policy(POLICY_NEVER, POLICY_AUTOMATIC)
        notes3_text=GtkText()
        scrolledwindow5.add(notes3_text)
        notes3_text.set_flags(CAN_FOCUS)
        notes3_text.set_usize(170, 60)
        notes3_text.set_editable(TRUE)
        if type == "edit":
            notes3_text.insert(None,None,None,self.operation[self.selected_operation][8])
        notes3_text.show()
        self.notes3_text=notes3_text
        scrolledwindow5.show()
        self.scrolledwindow5=scrolledwindow5
        table5.show()
        self.table5=table5
        # Transfert
        table6=GtkTable(8, 2)
        notebook.add(table6)
        label25=GtkLabel()
        table6.attach(label25, 0, 1, 0, 1, FILL, 0, 0, 0)
        label25.set_usize(-1, -1)
        label25.set_text("Description :")
        label25.set_justify(JUSTIFY_CENTER)
        label25.set_alignment(0, 0.5)
        label25.set_padding(0, 0)
        label25.show()
        self.label25=label25

        label31=GtkLabel()
        table6.attach(label31, 0, 1, 1, 2, FILL, 0, 0, 0)
        label31.set_usize(-1, -1)
        label31.set_text("Transfer from :")
        label31.set_justify(JUSTIFY_CENTER)
        label31.set_alignment(0, 0.5)
        label31.set_padding(0, 0)
        label31.show()
        self.label31=label31

        label26=GtkLabel()
        table6.attach(label26, 0, 1, 2, 3, FILL, 0, 0, 0)
        label26.set_usize(-1, -1)
        label26.set_text("Transfer to :")
        label26.set_justify(JUSTIFY_CENTER)
        label26.set_alignment(0, 0.5)
        label26.set_padding(0, 0)
        label26.show()
        self.label26=label26

        label27=GtkLabel()
        table6.attach(label27, 0, 1, 3, 4, FILL, 0, 0, 0)
        label27.set_usize(-1, -1)
        label27.set_text("Category :")
        label27.set_justify(JUSTIFY_CENTER)
        label27.set_alignment(0, 0.5)
        label27.set_padding(0, 0)
        label27.show()
        self.label27=label27

        label28=GtkLabel()
        table6.attach(label28, 0, 1, 4, 5, FILL, 0, 0, 0)
        label28.set_usize(-1, -1)
        label28.set_text("Date :")
        label28.set_justify(JUSTIFY_CENTER)
        label28.set_alignment(0, 0.5)
        label28.set_padding(0, 0)
        label28.show()
        self.label28=label28

        label29=GtkLabel()
        table6.attach(label29, 0, 1, 5, 6, FILL, 0, 0, 0)
        label29.set_usize(-1, -1)
        label29.set_text("Value :")
        label29.set_justify(JUSTIFY_CENTER)
        label29.set_alignment(0, 0.5)
        label29.set_padding(0, 0)
        label29.show()
        self.label29=label29

        label30=GtkLabel()
        table6.attach(label30, 0, 1, 6, 7, FILL, 0, 0, 0)
        label30.set_usize(-1, -1)
        label30.set_text("Notes :")
        label30.set_justify(JUSTIFY_CENTER)
        label30.set_alignment(0, 0.5)
        label30.set_padding(0, 0)
        label30.show()
        self.label30=label30

        description4_entry=GtkEntry()
        table6.attach(description4_entry, 1, 2, 0, 1, EXPAND, 0, 0, 0)
        description4_entry.set_flags(CAN_FOCUS)
        description4_entry.set_usize(170, -1)
        description4_entry.set_editable(TRUE)
        description4_entry.set_visibility(TRUE)
        description4_entry.set_max_length(0)
        if type == "edit":
            description4_entry.set_text(self.operation[self.selected_operation][2])
        description4_entry.show()
        self.description4_entry=description4_entry

        label32=GtkLabel()
        table6.attach(label32, 1, 2, 1, 2, EXPAND, 0, 0, 0)
        label32.set_usize(-1, -1)
        label32.set_text(self.lbaccount.get())
        if type=="edit":
            label32.set_text(self.operation[self.selected_operation][0])
        label32.set_justify(JUSTIFY_CENTER)
        label32.set_alignment(0, 0.5)
        label32.set_padding(0, 0)
        label32.show()
        self.label32=label32
                             
        to4_button = GtkButton()
        table6.attach(to4_button, 1, 2, 2, 3, EXPAND, 0, 0, 0)
        lbto04 = GtkLabel()
        to4_button.add(lbto04)
        lbto04.set_usize(170, -1)
        lbto04.set_text("Select an account")
        lbto04.set_justify(JUSTIFY_CENTER)
        if type == "edit":
            lbto04.set_text(self.operation[self.selected_operation][9])
        lbto04.show()
        self.lbto04=lbto04
        to4_button.set_usize(170, -1)
        to4_button.connect("clicked",self.select_account)
        to4_button.show()
        self.to4_button = to4_button
        
        category4_button = GtkButton()
        table6.attach(category4_button, 1, 2, 3, 4, EXPAND, 0, 0, 0)
        lbcategory4 = GtkLabel()
        category4_button.add(lbcategory4)
        lbcategory4.set_usize(170, -1)
        lbcategory4.set_text("Select a category")
        lbcategory4.set_justify(JUSTIFY_CENTER)
        if type == "edit":
            lbcategory4.set_text(self.operation[self.selected_operation][3])
        lbcategory4.show()
        self.lbcategory4=lbcategory4
        category4_button.set_usize(170, -1)
        category4_button.connect("clicked",self.select_category)
        category4_button.show()
        self.category4_button = category4_button

        date4_button = GtkButton()
        table6.attach(date4_button, 1, 2, 4, 5, EXPAND, 0, 0, 0)
        lbdate4 = GtkLabel()
        date4_button.add(lbdate4)
        lbdate4.set_usize(170, -1)
        lbdate4.set_text("Select a date")
        lbdate4.set_justify(JUSTIFY_CENTER)
        if type == "edit":
            lbdate4.set_text(time.strftime(self.dateformat,(time.localtime(float(self.operation[self.selected_operation][6])))))
        lbdate4.show()
        self.lbdate4=lbdate4
        date4_button.set_usize(170, -1)
        date4_button.connect("clicked",self.select_date)
        date4_button.show()
        self.date4_button = date4_button

        value4_entry=GtkEntry()
        table6.attach(value4_entry, 1, 2, 5, 6, EXPAND, 0, 0, 0)
        value4_entry.set_flags(CAN_FOCUS)
        value4_entry.set_usize(170, -1)
        value4_entry.set_editable(TRUE)
        value4_entry.set_visibility(TRUE)
        value4_entry.set_max_length(0)
        if type == "edit":
            value4_entry.set_text(self.operation[self.selected_operation][7])
        value4_entry.show()
        self.value4_entry=value4_entry
        
        scrolledwindow6=GtkScrolledWindow()
        table6.attach(scrolledwindow6, 1, 2, 6, 7, FILL, FILL, 0, 0)
        scrolledwindow6.set_usize(170, 60)
        scrolledwindow6.set_policy(POLICY_NEVER, POLICY_AUTOMATIC)
        notes4_text=GtkText()
        scrolledwindow6.add(notes4_text)
        notes4_text.set_flags(CAN_FOCUS)
        notes4_text.set_usize(170, 60)
        notes4_text.set_editable(TRUE)
        if type == "edit":
            notes4_text.insert(None,None,None,self.operation[self.selected_operation][8])
        notes4_text.show()
        self.notes4_text=notes4_text
        scrolledwindow6.show()
        self.scrolledwindow6=scrolledwindow6
        table6.show()
        self.table6=table6
        self.notebook.set_page(3)
        if type == "edit":
            self.select_type(self,self.operation[self.selected_operation][5])
            if self.current_type=="Card":
                self.notebook.set_page(0)
            if self.current_type=="Cash":
                self.notebook.set_page(0)
            if self.current_type=="Cheque":
                self.notebook.set_page(2)
            if self.current_type=="Debit":
                self.notebook.set_page(3)
            if self.current_type=="Deposit":
                self.notebook.set_page(4)
            if self.current_type=="Transfert":
                self.notebook.set_page(5)
    
    def update_xml(self):
        file = open(self.bankpath + '/data/operations.xml', 'w')
        x = 0
        while x < len(self.operation):
            file.write('<operation>\n<account>' + self.operation[x][0] + '</account>\n<number>' + self.operation[x][1] + '</number>\n<description>' + self.operation[x][2] + '</description>\n<categorie>' + self.operation[x][3] + '</categorie>\n<contact>' + self.operation[x][4] + '</contact>\n<type>' + self.operation[x][5] + '</type>\n<date>' + self.operation[x][6] + '</date>\n<value>' + self.operation[x][7] + '</value>\n<notes>' + self.operation[x][8] + '</notes>\n<transfert>' + self.operation[x][9] + '</transfert>\n</operation>\n\n')
            x = x + 1
        file.close
    

