#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <gdk_imlib.h>

#include "globals.h"

/* i'm lazy and this is a tiny application. */
/* globals are bad. don't do this at home.  */
struct _app_globals app_globals;

void cache_widgets(GladeXML *xml) {
  app_globals.xml = xml;
  app_globals.win_main = glade_xml_get_widget (xml, "win_main");
  app_globals.win_newfile = glade_xml_get_widget (xml, "win_new_file");
  app_globals.win_promptdel = glade_xml_get_widget (xml, "win_promptdel");
  app_globals.win_properties = glade_xml_get_widget (xml, "win_properties");
  app_globals.win_open_with = glade_xml_get_widget (xml, "win_open_with");
  app_globals.win_run_cmd = glade_xml_get_widget (xml, "win_run_cmd");
  app_globals.label_newfile = glade_xml_get_widget (xml, "label_newfile");
  app_globals.entry_newfile = glade_xml_get_widget (xml, "entry_newfile");
  app_globals.entry_run_cmd = glade_xml_get_widget (xml, "entry_run_cmd");
  app_globals.clist_files = glade_xml_get_widget (xml, "clist_files");
  app_globals.clist_runwith = glade_xml_get_widget (xml, "clist_runwith");

  /* property dialog widgets - seperated because there are a lot of them */
  app_globals.img_prop_type = glade_xml_get_widget (xml, "img_prop_type");
  app_globals.entry_prop_name = glade_xml_get_widget (xml, "entry_prop_name");
	app_globals.label_prop_attrib = 
		glade_xml_get_widget (xml, "label_prop_attrib");
	app_globals.combo_user = glade_xml_get_widget (xml, "combo_user");
	app_globals.combo_group = glade_xml_get_widget (xml, "combo_group");
	app_globals.perms[0x0] = glade_xml_get_widget (xml, "box_OX");
	app_globals.perms[0x1] = glade_xml_get_widget (xml, "box_OW");
	app_globals.perms[0x2] = glade_xml_get_widget (xml, "box_OR");
	app_globals.perms[0x3] = glade_xml_get_widget (xml, "box_GX");
	app_globals.perms[0x4] = glade_xml_get_widget (xml, "box_GW");
	app_globals.perms[0x5] = glade_xml_get_widget (xml, "box_GR");
	app_globals.perms[0x6] = glade_xml_get_widget (xml, "box_UX");
	app_globals.perms[0x7] = glade_xml_get_widget (xml, "box_UW");
	app_globals.perms[0x8] = glade_xml_get_widget (xml, "box_UR");
	app_globals.perms[0x9] = glade_xml_get_widget (xml, "box_sticky");
	app_globals.perms[0xA] = glade_xml_get_widget (xml, "box_gid");
	app_globals.perms[0xB] = glade_xml_get_widget (xml, "box_uid");
}


void load_icons() {
	GladeXML *xml = app_globals.xml;
	GdkPixmap *pm;
	GdkBitmap *bm;
	GtkWidget *pixmap;
	GtkWidget *w;

	gdk_imlib_load_file_to_pixmap("home.png", &pm, &bm); 
	pixmap = gtk_pixmap_new(pm, bm);
	w = glade_xml_get_widget (xml, "b_home");
	gtk_container_add(GTK_CONTAINER(w), pixmap);
	gtk_widget_show(pixmap);

	gdk_imlib_load_file_to_pixmap("copy.png", &pm, &bm); 
	pixmap = gtk_pixmap_new(pm, bm);
	w = glade_xml_get_widget (xml, "b_copy");
	gtk_container_add(GTK_CONTAINER(w), pixmap);
	gtk_widget_show(pixmap);

	gdk_imlib_load_file_to_pixmap("cut.png", &pm, &bm); 
	pixmap = gtk_pixmap_new(pm, bm);
	w = glade_xml_get_widget (xml, "b_cut");
	gtk_container_add(GTK_CONTAINER(w), pixmap);
	gtk_widget_show(pixmap);

	gdk_imlib_load_file_to_pixmap("paste.png", &pm, &bm); 
	pixmap = gtk_pixmap_new(pm, bm);
	w = glade_xml_get_widget (xml, "b_paste");
	gtk_container_add(GTK_CONTAINER(w), pixmap);
	gtk_widget_show(pixmap);

	gdk_imlib_load_file_to_pixmap("del.png", &pm, &bm); 
	pixmap = gtk_pixmap_new(pm, bm);
	w = glade_xml_get_widget (xml, "b_del");
	gtk_container_add(GTK_CONTAINER(w), pixmap);
	gtk_widget_show(pixmap);

  /* load pixmaps that we will need */
	gdk_imlib_load_file_to_pixmap("dir.png",
									&app_globals.img_dir, &app_globals.img_dir_mask);

	gdk_imlib_load_file_to_pixmap("lnk.xpm",
									&app_globals.img_lnk, &app_globals.img_lnk_mask);

	gdk_imlib_load_file_to_pixmap("file.png",
									&app_globals.img_file, &app_globals.img_file_mask);

	gdk_imlib_load_file_to_pixmap("fifo.xpm",
									&app_globals.img_fifo, &app_globals.img_fifo_mask);

	gdk_imlib_load_file_to_pixmap("dev.xpm",
									&app_globals.img_dev, &app_globals.img_dev_mask);
}


int
main (int argc, char **argv)
{
  GladeXML *xml;

  /* change to our application's catch-all directory */
  /* holds pixmaps and our .glade file */
#ifdef DEVBOX
  chdir ("/tmp/dfmtest");	/* I don't install on my devbox */
  printf ("DEVBOX Build. Do not use!\n");
#else
  chdir ("/usr/share/dfm");
#endif

  gtk_init (&argc, &argv);
  glade_init ();
	gdk_imlib_init();

  xml = glade_xml_new ("dfm.glade", NULL);

  if (!xml) {
    g_warning ("couldn't load glade interface");
    return 1;
  }

	cache_widgets(xml);
	load_icons();

  /* FIXME - workaround for a strange glade(?) bug */
  /* window decorations hide, but not children of the widget */
  /* after forced updates / queue flush in busy I/O loop */
  new_prog_win ();

  /* set our current directory */
  app_globals.c_dir = g_strdup (getenv ("HOME"));
  if (app_globals.c_dir == NULL)
    app_globals.c_dir = g_strdup ("/");

  /* make our selection list "empty" */
  app_globals.sel_list = NULL;
  app_globals.sel_all = FALSE;
  app_globals.sel_path = NULL;

  /* flag transient windows as transient for win_main */
  gtk_window_set_transient_for(
   GTK_WINDOW(app_globals.win_newfile), GTK_WINDOW(app_globals.win_main));
  gtk_window_set_transient_for(
   GTK_WINDOW(app_globals.win_promptdel), GTK_WINDOW(app_globals.win_main));
  gtk_window_set_transient_for(
   GTK_WINDOW(app_globals.win_properties), GTK_WINDOW(app_globals.win_main));
  gtk_window_set_transient_for(
   GTK_WINDOW(app_globals.win_open_with), GTK_WINDOW(app_globals.win_main));
  gtk_window_set_transient_for(
   GTK_WINDOW(app_globals.win_run_cmd), GTK_WINDOW(app_globals.win_main));

  /* force our main window to show up, while we load */
  gtk_widget_show(app_globals.win_main); 
  while (gtk_events_pending ())
	  gtk_main_iteration ();

  /* show our home directory */
  change_directory (app_globals.c_dir);
  display_directory ();

  glade_xml_signal_autoconnect (xml);

  /* populate properties window from /etc/passwd and /etc/groups */
  populate_uid_gid();

  /* load our mime mappings */
  load_mime_mappings ();

  gtk_main ();
}
