#!/usr/bin/python2.1

import sys, os
from glob import glob
import commands
import ipkg

pkg_dir=sys.argv[1]

if ( not pkg_dir ):
	sys.stderr.write("Usage: ipkg-make-index <package_directory>\n")
	sys.exit(1)

packages = {}

sys.stderr.write("Reading in all the package info from %s\n" % (pkg_dir, ))
files=glob(pkg_dir + '/*.ipk')
files.sort()
for filename in files:
	sys.stderr.write("Reading info for package %s\n" % (filename,))
	pkg = ipkg.Package(filename)
	name = pkg.package
	if (not packages.has_key(name)):
		packages[name] = pkg
        if (commands.getstatus("ipkg-compare-versions %s '>' %s" % (pkg.version, packages[name].version))):
		packages[name] = pkg

sys.stderr.write("Generate Packages file")
names = packages.keys()
names.sort()
for name in names:
	sys.stderr.write("Writing info for package %s\n" % (name,))
	print packages[name]
