/* pkg_depends.h - the itsy package management system

   Steven M. Ayer
   
   Copyright (C) 2002 Compaq Computer Corporation

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#ifndef PKG_DEPENDS_H
#define PKG_DEPENDS_H

#include "pkg.h"
#include "pkg_hash.h"

enum depend_type {
    PREDEPEND,
    DEPEND,
    CONFLICTS,
    GREEDY_DEPEND,
    RECOMMEND,
    SUGGEST
};
typedef enum depend_type depend_type_t;

enum version_constraint {
    NONE,
    EARLIER,
    EARLIER_EQUAL,
    EQUAL,
    LATER_EQUAL,
    LATER
};
typedef enum version_constraint version_constraint_t;

struct depend{
    version_constraint_t constraint;
    char * version;
    abstract_pkg_t * pkg;
};
typedef struct depend depend_t;
    
struct compound_depend{
    depend_type_t type;
    int possibility_count;
    struct depend ** possibilities;
};
typedef struct compound_depend compound_depend_t;

#include "hash_table.h"

void buildProvides(hash_table_t * hash, abstract_pkg_t * ab_pkg, pkg_t * pkg);
void buildConflicts(hash_table_t * hash, abstract_pkg_t * ab_pkg, pkg_t * pkg);
void buildReplaces(hash_table_t * hash, abstract_pkg_t * ab_pkg, pkg_t * pkg);
void buildDepends(hash_table_t * hash, pkg_t * pkg);
void buildDependedUponBy(pkg_t * pkg, abstract_pkg_t * ab_pkg);
void freeDepends(pkg_t *pkg);
void printDepends(pkg_t * pkg);
int version_constraints_satisfied(depend_t * depends, pkg_t * pkg);
int pkg_hash_fetch_unsatisfied_dependencies(ipkg_conf_t *conf, pkg_t * pkg, pkg_vec_t *depends, char *** unresolved);
pkg_vec_t * pkg_hash_fetch_conflicts(hash_table_t * hash, pkg_t * pkg);
int pkg_dependence_satisfiable(ipkg_conf_t *conf, depend_t *depend);
int pkg_dependence_satisfied(ipkg_conf_t *conf, depend_t *depend);

#endif
