/* file.c - convenience routines for common stat operations

   Carl D. Worth

   Copyright (C) 2001 University of Southern California

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "file.h"

int file_exists(char *file_name)
{
    int err;
    struct stat stat_buf;

    err = stat(file_name, &stat_buf);
    if (err == 0) {
	return 1;
    } else {
	return 0;
    }
}

int file_is_dir(char *file_name)
{
    int err;
    struct stat stat_buf;

    err = stat(file_name, &stat_buf);
    if (err) {
	return 0;
    }

    return S_ISDIR(stat_buf.st_mode);
}



