/* strndup.c - duplicate the first n bytes of a string

   Copyright (C) 2001 Carl D. Worth

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#ifndef HAVE_STRNDUP

char *strndup(const char *s, size_t size)
{
    char *new;

    new = strdup(s);

    if (strlen(new) <= size) {
	return new;
    }

    new[size] = '\0';
    new = realloc(new, size + 1);
    return new;
}

#endif
