#include "stdafx.h"
#include "tester1.h"
#include <commctrl.h>
#include <aygshell.h>
#include <sipapi.h>
#include "setup.h"


/* TO DO: Detect whether we're running on an AXIM or an iPAQ at runtime,
   and set accordingly. */

#ifdef AXIM
#  define FB_ADR	0x14042000
#else
#  define FB_ADR	0xA0051000
#endif



#define SET 0xffffffff
#define LCD_X_RES 240
#define LCD_Y_RES 320
UINT16 *fb;


void init_fb()
{
	fb=(UINT16*)VirtualAlloc((void*)0x0,LCD_X_RES*LCD_Y_RES*2, MEM_RESERVE,PAGE_READWRITE);
	VirtualCopy((void*)fb,(void *) (FB_ADR/256),LCD_X_RES*LCD_Y_RES*2, PAGE_READWRITE|PAGE_NOCACHE|PAGE_PHYSICAL);
}

void try_fb()
{
//	fb[1]=SET;
}

Image ReadBMP(char FileName[30])
{
 FILE *stream;
 char buff[29];
 UINT32 x,y;
 unsigned char red,green,blue;
 unsigned long offset;
 UINT16 *p,c;
 Image image={NULL};
 stream=fopen(FileName,"rb");
 if(!stream) return image;
 fread(buff,26,1,stream);

 offset=(unsigned char)buff[13]*16777216+(unsigned char)buff[12]*65536+(unsigned char)buff[11]*256+(unsigned char)buff[10];
 x=(unsigned char)buff[21]*256*256*256+(unsigned char)buff[20]*256*256+(unsigned char)buff[19]*256+(unsigned char)buff[18];
 y=(unsigned char)buff[25]*256*256*256+(unsigned char)buff[24]*256*256+(unsigned char)buff[23]*256+(unsigned char)buff[22];
// offset=54;
 UINT32 imgx=x,imgy=y;
 if(x<32) x=32;
 if(y<32) y=32;
 p=image.p=(UINT16*)malloc(x*y*2);
 if(!image.p) return(image);
 fseek(stream,offset,SEEK_SET);
 p+=(x*y+x);

for(UINT32 zz=0;zz<y;zz++)
 {
 p-=2*x;

 for(UINT32 yy=0;yy<x;yy++)
  {
   blue=fgetc(stream);
   green=fgetc(stream);
   red=fgetc(stream);
   c=(red/8)*2048+(green/4)*32+blue/8;
   *p=c;
   p++;

  }

}
//image.p=p;
image.x=imgx;
image.y=imgy-1;
fclose(stream);
return(image);
}

// shows picture pointed to by p, with res (x by y), at (x_pos, y_pos)
void ShowImage(UINT16 *p, int x, int y,int x_pos,int y_pos)
{
	UINT16 *fb=::fb;
	if(!p) return;
	fb+=y_pos*LCD_X_RES+x_pos;
	for(int yy=0;yy<y;yy++)
	{
		for(int xx=0;xx<x;xx++)
		{
			*fb=*p;
		fb++;
		p++;
		}
		if(x<LCD_X_RES) fb+=LCD_X_RES-x;
	}
}
