/***************************************************************************
/*	Copyright 2000 Compaq Computer Corporation.                            */
/*                                                                         */
/*	Copying or modifying this code for any purpose is permitted,           */
/*	provided that this copyright notice is preserved in its entirety       */
/*	in all copies or modifications.                                        */
/*                                                                         */
/*	COMPAQ COMPUTER CORPORATION MAKES NO WARRANTIES, EXPRESSED OR          */
/*	IMPLIED, AS TO THE USEFULNESS OR CORRECTNESS OF THIS CODE OR           */
/*	ITS FITNESS FOR ANY PARTICULAR PURPOSE.                                */
/***************************************************************************/

/*+*************************************************************************
  MODULE NAME:	arm-sa11xx.c
  ABSTRACT:     Final phase of loading booting Linux

  AUTHORS:      Dirk van Hennekeler,   Compaq Computer Corporation.
				<dirk.vanhennekeler@compaq.com>
  CREATED:		29 November 2000
**************************************************************************-*/

#include <windows.h>
#include "../pbsdboot/pbsdboot.h"

void asm_code_begin_sa11xx();
void asm_code_end_sa11xx();

extern void StartProg(DWORD dwPhysAddr, DWORD dwICMRReg, DWORD dwArg0);
extern void SA11xxAssemblyCodeHolder(VOID);
extern void Exec(DWORD dwExecutePhysAddr, DWORD dwICMRVirtAddr);

int startprog_intel_sa11xx(caddr_t map)
{
  int i;
  unsigned long *mem;
  unsigned long *icmr;
  unsigned long PhysMem;
  unsigned long *codep = (unsigned long *)SA11xxAssemblyCodeHolder;
  int			code_len = 4*1024; // TODO: use pagesize();
  

  // Allocate physical memory.
  if ((mem = (unsigned long *)vmem_alloc()) == NULL)
  {
    debug_printf(TEXT ("Cannot allocate final page.\n"));
 	msg_printf(MSG_ERROR, _T("Error"), TEXT("Cannot allocate root page.\n"));
    return -1;
  }

  // Copy startup program code.
  for (i = 0, code_len /= sizeof(unsigned long); i < code_len; i++)
    mem[i] = *codep++;


  // Set map address.
  // mem[0] is the branch instruction, skip it.
  mem[1] = (unsigned long)map; // store the address of the map structure

  // Construct start instruction.
  PhysMem = (unsigned long) vtophysaddr((unsigned char *)mem);

  // Map the interrupt vector.
  icmr = (unsigned long *) VirtualAlloc(0, 0x400, MEM_RESERVE, PAGE_NOACCESS);
  VirtualCopy ((LPVOID) icmr, (LPVOID) (0x90050000 >> 8),
	  0x400, PAGE_READWRITE | PAGE_NOCACHE | PAGE_PHYSICAL);

  // Go!!!
  Exec(PhysMem, (unsigned long)&icmr[1]);
	
  // We should not get here.
  return 0;
}

/*
 void
 startprog_test(register struct map_s *map)
 {
   register unsigned long *addr;
   register unsigned long *p;
   register int i;
 
   addr = map->base;
   i = 0;
   while (p = map->leaf[i / map->leafsize][i % map->leafsize]) {
     register unsigned char *pe = p + map->pagesize;
     while (p < pe) {
       *addr++ = *p++;
     }
     i++;
   }
 }
*/
/*
void SA11xxAssemblyCodeHolder (void)
{
/*
 * void
 * startprog(register struct map_s *map)
 * {
 *   register unsigned char *addr;
 *   register unsigned char *p;
 *   register int i;
 * 
 *   addr = map->base;
 *   i = 0;
 *   while (p = map->leaf[i / map->leafsize][i % map->leafsize]) {
 *     register unsigned char *pe = p + map->pagesize;
 *     while (p < pe) {
 *       *addr++ = *p++;
 *     }
 *     i++;
 *   }
 * }
 *
 *  register assignment:
 *    struct map_s *map		a0
 *    unsigned char *addr	a1
 *    unsigned char *p		a2
 *    unsigned char *pe		a3
 *    int i			t0
 *
 * struct map_s {
 *   caddr_t entry;	+0
 *   caddr_t base;	+4
 *   int pagesize;	+8
 *   int leafsize;	+12
 *   int nleaves;	+16
 *   caddr_t arg0;	+20

 *   caddr_t arg1;  +24

 *   caddr_t arg2;	+28

 *   caddr_t arg3;	+32

 *   caddr_t *leaf[32];	+36
 *
 
*

  TODO: put the instructions in an array called SA11xxAssemblyCodeHolder
  so we don't need special compiler commands to compile the code.
}
*/