/*
 * loader.h
 *
 * Copyright (C) 1999 Steve Hill <sjhill@plutonium.net>
 * Copyright (C) 1999 Bradley D. LaRonde <brad@ltc.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */
/*
 *  MODIFICATIONS: 
 *  11-Dec-2000  - added a function to return cpu specific settings
 *               - added a structure to hold the cpu settings
 *               - removed some enums and member functions that weren't 
 *                 needed because of above
 *
 *               Dirk <dirk.vanhennekeler@compaq.com>
 */

class BootConfig;
class ImageSection;

typedef struct _CPUSETTINGS {
	DWORD			nPID;			/* processor id */
	unsigned int	ppStartAddr;	/* start address */
	startprog_t		pfnStartProg;	/* startprog function address */
	BOOL			bSupported;		/* TRUE = we support it */
} CPUSETTINGS;


class Loader
{
	private:
		int m_nVerboseLevel;

	CPUSETTINGS* Loader::CPUSettings() const;
	BOOL GetProcessorSpecificSettings(unsigned int& pps, startprog_t& psp) const;
	void Load(ImageSection* pSection, LPCTSTR pszParameters);
	void GetSystemProcessorInfo(LPTSTR psz);
	BOOL VerifyProcessorSupport();

public:
	int Main();
};
