//=================================================================
//
//        swapper.c
//
//        Byte swapper for tx39 flash programming
//
//=================================================================
//####COPYRIGHTBEGIN####
//-------------------------------------------
// Copyright (C) 1998 Cygnus Solutions.
//
// This is copyrighted software that may only
// be reproduced, modified, or distributed
// under license from Cygnus Solutions.
//-------------------------------------------
//####COPYRIGHTEND####
//=================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):     ctarpy, nickg
// Contact(s):    ctarpy
// Date:          1998/6/3
// Version:       0.00
// Description:   Byte swaps (for tx39 binaries)
//
//
//####DESCRIPTIONEND####


#include <stdio.h>


// Input on argv[1], output on argv[2]
int main(int argc, char **argv)
{
    FILE* ip;
    FILE* op;

    if ( argc!=3 ) {
        printf("Please provide source and destination filenames\n");
        return 0;
    }

    // Open binary ip for reading
    if ((ip = fopen(argv[1], "rb")) == NULL) {
        printf("Cannot open input file:%s\n", argv[1]);
        return 0;
    }

    // Create binary file for writing
    if ((op = fopen(argv[2], "wb")) == NULL) {
        printf("Cannot create output file:%s\n", argv[2]);
        fclose(ip);
        return 0;
    }

    for(;;)
    {
        int c1 = getc(ip);
        int c2,c3,c4;

        if ( c1 == EOF ) break;

        c2 = getc(ip);
        c3 = getc(ip);
        c4 = getc(ip);
        putc(c4, op);
        putc(c3, op);
        putc(c2, op);
        putc(c1, op);
    }
    fclose(ip);
    fclose(op);
    return 0;
}


// EOF swapper.c
