/*
 * XSOLDIER, a video-oriented game
 * Copyright (C) 1997, Yuusuke HASHIMOTO
 *                     s945750@educ.info.kanagawa-u.ac.jp
 *
 * ܥץˤ copyleft ŬѤƤޤCONDITION ե򻲾Ȥ
 * Ƥ
 */

#include <X11/Xlib.h>
#include <X11/xpm.h>

#include "image.h"
#include "xsoldier.h"
#include "manage.h"
#include "common.h"
#include "enemyshot.h"
#include "callback.h"
#include "boss.h"
#include "enemy.h"
#include "extern.h"
#include "sin.h"

/*
 *   ƥ֥
 *      ؿ
 *      ؿ
 *      ؿ
 *
 *      ؿǡɽؿϿ뤳
 */

int NewBoss1(void)
{
    manage->New.Data.hitAtt = MEnemy;
    manage->New.Data.hitMask = MPlayer | MPShot;

    manage->New.Data.X = FieldW/2;
#ifdef PDA
    manage->New.Data.Y = -140;
#else
    manage->New.Data.Y = -90;
#endif

    manage->New.Data.HP = 300 + 50*manage->Loop;
    manage->New.Data.Point = 5000;
    manage->New.Data.EnemyAtt = BossDel;

    manage->New.Data.Width = 150;
    manage->New.Data.Height = 150;

    manage->New.Data.Cnt[0] = 0;
    manage->New.Data.Cnt[1] = 200; /*** ̵Ũ ***/
    manage->New.Data.Cnt[2] = 0; /*** image counter***/
    manage->New.Data.Cnt[3] = 10; /*** x move ***/
    manage->New.Data.Cnt[4] = 0; /*** y move ***/
    manage->New.Data.Cnt[5] = 0;  /*** laser counter ***/

    manage->New.Grp.image = Boss1Image;
    return NewObj(MEnemy,BossAct1,BossHit1,DrawImage);
}

DelAtt BossAct1(ObjData *my)
{
    if (my->Cnt[0] < my->Cnt[1])
    {/*** äо ***/
	my->Y++;
	my->Cnt[0]++;
	return NoneDel;
    }

    if (my->shotTime >= ShotTiming)
    {
        ShotToAngle(my->X, my->Y, 50, 10);
        ShotToAngle(my->X, my->Y, 70, 10);
        ShotToAngle(my->X, my->Y, 90, 10);
        ShotToAngle(my->X, my->Y, 110, 10);
        ShotToAngle(my->X, my->Y, 130, 10);

	my->shotTime = my->startTime;
    }
    else
	my->shotTime++;

    if (my->Cnt[5] >= (25-manage->Loop*3))
    {
	LaserShot(my->X-30,my->Y,20);
	LaserShot(my->X+30,my->Y,20);
	LaserShot(my->X-80,my->Y,20);
	LaserShot(my->X+80,my->Y,20);

	my->Cnt[5] = 0;
    }
    else
	my->Cnt[5]++;

    if ((my->X+my->Cnt[3]>FieldW) || (my->X+my->Cnt[3]<0))
	my->Cnt[3] = my->Cnt[3]*(-1);

    my->X += my->Cnt[3];

    return NoneDel;
}

DelAtt BossHit1(ObjData *my, ObjData *your)
{
    if (my->Cnt[0] < my->Cnt[1])
	return NoneDel;

    my->HP -= your->Attack;
    if (my->HP <= 0)
    {
        NewBomb(my->X,my->Y);
        NewBomb(my->X+random()%100-50,my->Y+random()%100-50);
        NewBomb(my->X+random()%100-50,my->Y+random()%100-50);
        NewBomb(my->X+random()%100-50,my->Y+random()%100-50);
        NewBomb(my->X+random()%100-50,my->Y+random()%100-50);
        NewBomb(my->X+random()%100-50,my->Y+random()%100-50);
        NewBomb(my->X+random()%100-50,my->Y+random()%100-50);
        return my->EnemyAtt;
    }
    else
        return NoneDel;
}

int NewBoss2(void)
{
    manage->New.Data.hitAtt = MEnemy;
    manage->New.Data.hitMask = MPlayer | MPShot;

    manage->New.Data.X = FieldW/2;
#ifdef PDA
    manage->New.Data.Y = -160;
#else
    manage->New.Data.Y = -60;
#endif

    manage->New.Data.HP = 300 + 50*manage->Loop;
    manage->New.Data.Point = 5000;
    manage->New.Data.EnemyAtt = BossDel;

    manage->New.Data.Width = 90;
    manage->New.Data.Height = 130;

    manage->New.Data.Cnt[0] = 0;
    manage->New.Data.Cnt[1] = 200; /*** ̵Ũ ***/
    manage->New.Data.Cnt[2] = 0; /*** image counter***/

    manage->New.Data.Cnt[3] = 0;
    manage->New.Data.Cnt[4] = 0;
    
    manage->New.Grp.image = Boss2Image;
    return NewObj(MEnemy,BossAct2,BossHit1,DrawImage);
}

DelAtt BossAct2(ObjData *my)
{
    if (my->Cnt[0] < my->Cnt[1])
    {/*** äо ***/
	my->Y++;
	my->Cnt[0]++;
	return NoneDel;
    }

    if (manage->Loop > 2)
    {
	if (my->shotTime >= ShotTiming)
	{
	    ShotToPoint(my->X+40,my->Y,manage->player[0]->Data.X,manage->player[0]->Data.Y,random()%3 + 5);
	    ShotToPoint(my->X   ,my->Y,manage->player[0]->Data.X,manage->player[0]->Data.Y,8);
	    ShotToPoint(my->X-40,my->Y,manage->player[0]->Data.X,manage->player[0]->Data.Y,random()%5 + 3);
	    my->shotTime = my->startTime;
	}
	else
	    my->shotTime++;
    }

    if (my->Cnt[3] >= (15-manage->Loop*3))
    {
	HomingShot(my->X-20,my->Y-10,-10,-10);
	HomingShot(my->X-20,my->Y-10, 10,-10);
	my->Cnt[3] = 0;
    }
    else
	my->Cnt[3]++;

    if (my->X > manage->player[0]->Data.X)
    {
	if (my->X - manage->player[0]->Data.X > 20)
	{
	    my->X -= 10;
	}
	else
	{
	    my->Cnt[4]++;
	    my->X --;
	}

	if (my->Cnt[4] > 10)
	{
	    LaserShot(my->X-40,my->Y,30);
	    LaserShot(my->X+40,my->Y,30);
	    my->Cnt[4] = 0;
	}
    }
    else
    {
	if (manage->player[0]->Data.X - my->X > 20)
	{
	    my->X += 10;
	}
	else
	{
	    my->Cnt[4]++;
	    my->X ++;
	}

	if (my->Cnt[4] > 10)
	{
	    LaserShot(my->X-40,my->Y,30);
	    LaserShot(my->X+40,my->Y,30);
	    my->Cnt[4] = 0;
	}
    }

    return NoneDel;
}

int NewBoss3(void)
{
    manage->New.Data.hitAtt = MEnemy;
    manage->New.Data.hitMask = MPlayer | MPShot;

    manage->New.Data.X = FieldW/2;
#ifdef PDA
    manage->New.Data.Y = -160;
#else
    manage->New.Data.Y = -80;
#endif

    manage->New.Data.HP = 330 + 50*manage->Loop;
    manage->New.Data.Point = 6000;
    manage->New.Data.EnemyAtt = BossDel;

    manage->New.Data.Width = 130;
    manage->New.Data.Height = 130;

    manage->New.Data.Cnt[0] = 0;
    manage->New.Data.Cnt[1] = 200; /*** ̵Ũ ***/
    manage->New.Data.Cnt[2] = 0; /*** image counter***/
    manage->New.Data.Cnt[3] = 10; /*** x move ***/
    manage->New.Data.Cnt[4] = 0; /*** y move ***/
    manage->New.Data.Cnt[5] = 0;  /*** laser counter ***/

    manage->New.Grp.image = Boss3Image;
    return NewObj(MEnemy,BossAct3,BossHit1,DrawImage);
}

DelAtt BossAct3(ObjData *my)
{
    if (my->Cnt[0] < my->Cnt[1])
    {/*** äо ***/
	my->Y++;
	my->Cnt[0]++;
	return NoneDel;
    }

    if (my->shotTime >= ShotTiming)
    {
	HomingShot(my->X,my->Y,0,10);
	HomingShot(my->X,my->Y,10,0);
	HomingShot(my->X,my->Y,0,-10);
	HomingShot(my->X,my->Y,-10,0);
	HomingShot(my->X,my->Y,10,10);
	HomingShot(my->X,my->Y,-10,10);
	HomingShot(my->X,my->Y,10,-10);
	HomingShot(my->X,my->Y,-10,-10);

	my->shotTime = my->startTime;
    }
    else
	my->shotTime++;

    if (my->Cnt[5] >= (25 - manage->Loop*2))
    {
	LaserShot(my->X-30,my->Y,25);
	LaserShot(my->X+30,my->Y,25);
	LaserShot(my->X-60,my->Y,25);
	LaserShot(my->X+60,my->Y,25);

	my->Cnt[5] = 0;
    }
    else
	my->Cnt[5]++;

    if ((my->X+my->Cnt[3]>FieldW) || (my->X+my->Cnt[3]<0))
	my->Cnt[3] = my->Cnt[3]*(-1);

    my->X += my->Cnt[3];

    return NoneDel;
}

int NewBoss4(void)
{
    manage->New.Data.hitAtt = MEnemy;
    manage->New.Data.hitMask = MPlayer | MPShot;

    manage->New.Data.X = FieldW/2;
#ifdef PDA
    manage->New.Data.Y = -140;
#else
    manage->New.Data.Y = -90;
#endif

    manage->New.Data.inertX = 0;
    manage->New.Data.inertY = 0;

    manage->New.Data.HP = 340 + 50*manage->Loop;
    manage->New.Data.Point = 6000;
    manage->New.Data.EnemyAtt = BossDel;

    manage->New.Data.Width = 300;
    manage->New.Data.Height = 100;

    manage->New.Data.Cnt[0] = 0;
    manage->New.Data.Cnt[1] = 200; /*** ̵Ũ ***/
    manage->New.Data.Cnt[2] = 0; /*** image counter***/
    manage->New.Data.Cnt[3] = 1; /*** x move ***/
    manage->New.Data.Cnt[4] = 0; /*** y move ***/
    manage->New.Data.Cnt[5] = 0;  /*** laser counter ***/

    manage->New.Grp.image = Boss4Image;
    return NewObj(MEnemy,BossAct4,BossHit1,DrawImage);
}

DelAtt BossAct4(ObjData *my)
{
    if (my->Cnt[0] < my->Cnt[1])
    {/*** äо ***/
	my->Y++;
	my->Cnt[0]++;
	return NoneDel;
    }

    if (my->Cnt[5] >= (8-manage->Loop))
    {
	LaserShot(my->X + random()%600-300, my->Y, 20);
	LaserShot(my->X + random()%300-150, my->Y, 20);
	LaserShot(my->X + random()%150-70, my->Y, 20);
	my->Cnt[5] = 0;
    }
    else
	my->Cnt[5]++;

    if (my->X < manage->player[0]->Data.X)
    {
        if (my->inertX <= 8)
            my->inertX++;
    }
    if (my->X > manage->player[0]->Data.X)
    {
        if (my->inertX >= -8)
            my->inertX--;
    }

    my->X += my->inertX;

    return NoneDel;
}

int NewBoss5(void)
{
    manage->New.Data.hitAtt = MEnemy;
    manage->New.Data.hitMask = MPlayer | MPShot;

    manage->New.Data.X = FieldW/2;
#ifdef PDA
    manage->New.Data.Y = -150;
#else
    manage->New.Data.Y = -128;
#endif

    manage->New.Data.HP = 350 + 50*manage->Loop;
    manage->New.Data.Point = 7000;
    manage->New.Data.EnemyAtt = BossDel;

    manage->New.Data.Width = 120;
    manage->New.Data.Height = 120;

    manage->New.Data.Cnt[0] = 0;
    manage->New.Data.Cnt[1] = 200; /*** ̵Ũ ***/
    manage->New.Data.Cnt[2] = 0; /*** image counter***/
    manage->New.Data.Cnt[3] = manage->player[0]->Data.X; /*** x move ***/
    manage->New.Data.Cnt[4] = manage->player[0]->Data.Y; /*** y move ***/
    manage->New.Data.Cnt[5] = 0;  /*** shot counter ***/
    manage->New.Data.Cnt[6] = 0;  /*** angle counter ***/

    manage->New.Grp.image = Boss5Image;
    return NewObj(MEnemy,BossAct5,BossHit1,DrawImage);
}

DelAtt BossAct5(ObjData *my)
{
    if (my->Cnt[0] < my->Cnt[1])
    {/*** äо ***/
	my->Y++;
	my->Cnt[0]++;
	return NoneDel;
    }

    if (my->Cnt[5] > (120-manage->Loop*10))
    {
	my->Cnt[3] = manage->player[0]->Data.X;
	my->Cnt[4] = manage->player[0]->Data.Y;
	my->Cnt[5] = 0;
    }
    else if (abs(my->X-my->Cnt[3]) > 5 || abs(my->Y-my->Cnt[4]) > 5)
    {
	if (my->X < my->Cnt[3])
	{
	    if (my->Cnt[3]-my->X > 50)
		my->X += 20;
	    else if (my->Cnt[3]-my->X > 30)
		my->X += 10;
	    else if (my->Cnt[3]-my->X > 20)
		my->X += 5;
	    else
		my->X ++;
	}
	else
	{
	    if (my->X-my->Cnt[3] > 50)
		my->X -= 20;
	    else if (my->X-my->Cnt[3] > 30)
		my->X -= 10;
	    else if (my->X-my->Cnt[3] > 20)
		my->X -= 5;
	    else
		my->X --;
	}

	if (my->Y < my->Cnt[4])
	{
	    if (my->Cnt[4]-my->Y > 50)
		my->Y += 20;
	    else if (my->Cnt[4]-my->Y > 30)
		my->Y += 10;
	    else if (my->Cnt[4]-my->Y > 20)
		my->Y += 5;
	    else
		my->Y ++;
	}
	else
	{
	    if (my->Y-my->Cnt[4] > 50)
		my->Y -= 20;
	    else if (my->Y-my->Cnt[4] > 30)
		my->Y -= 10;
	    else if (my->Y-my->Cnt[4] > 20)
		my->Y -= 5;
	    else
		my->Y --;
	}
    }
    else
    {
	my->Cnt[6] += 13;
	if (my->Cnt[6] >= 360)
	    my->Cnt[6] -= 360;
	ShotToAngle(my->X,my->Y,my->Cnt[6],8);
	my->Cnt[5]++;
    }

    return NoneDel;
}

int NewBoss6(void)
{
    manage->New.Data.hitAtt = MEnemy;
    manage->New.Data.hitMask = MPlayer | MPShot;

    manage->New.Data.X = FieldW/2;
#ifdef PDA
    manage->New.Data.Y = -130;
#else
    manage->New.Data.Y = -64;
#endif

    manage->New.Data.HP = 400 + 50*manage->Loop;
    manage->New.Data.Point = 9000;
    manage->New.Data.EnemyAtt = BossDel;

    manage->New.Data.Width = 300;
    manage->New.Data.Height = 100;

    manage->New.Data.Cnt[0] = 0;
    manage->New.Data.Cnt[1] = 200; /*** ̵Ũ ***/
    manage->New.Data.Cnt[2] = 0; /*** image counter***/

    manage->New.Data.Cnt[3] = 0; /*** stealth ***/
    manage->New.Data.Cnt[4] = 0;  /*** shot counter ***/

    manage->New.Grp.image = Boss6Image;
    return NewObj(MEnemy,BossAct6,BossHit1,DrawImage);
}

DelAtt BossAct6(ObjData *my)
{
    if (my->Cnt[0] < my->Cnt[1])
    {/*** äо ***/
	my->Y++;
	my->Cnt[0]++;
	return NoneDel;
    }

    if (my->Cnt[3] == 0)
    {
	my->hitAtt = MEnemy;
	my->image = 0;
	switch (my->Cnt[4]%10)
	{
	  case 0:
	    if (manage->Loop > 2)
	    {
		RingToPoint(my->X-128,my->Y+32,manage->player[0]->Data.X,manage->player[0]->Data.Y,random()%5+3);
		RingToPoint(my->X-128,my->Y+32,manage->player[0]->Data.X,manage->player[0]->Data.Y,random()%8+3);
		RingToPoint(my->X-128,my->Y+32,manage->player[0]->Data.X,manage->player[0]->Data.Y,random()%3+5);
	    }
	    RingToAngle(my->X-128,my->Y+32,80,8);
	    RingToAngle(my->X-128,my->Y+32,90,8);
	    RingToAngle(my->X-128,my->Y+32,100,8);
	    break;
	  case 2:
	    RingToAngle(my->X,my->Y+32,80,8);
	    RingToAngle(my->X,my->Y+32,90,8);
	    RingToAngle(my->X,my->Y+32,100,8);
	    break;
	  case 4:
	    if (manage->Loop > 2)
	    {
		RingToPoint(my->X+128,my->Y+32,manage->player[0]->Data.X,manage->player[0]->Data.Y,random()%5+3);
		RingToPoint(my->X+128,my->Y+32,manage->player[0]->Data.X,manage->player[0]->Data.Y,random()%8+3);
		RingToPoint(my->X+128,my->Y+32,manage->player[0]->Data.X,manage->player[0]->Data.Y,random()%3+5);
	    }
	    RingToAngle(my->X+128,my->Y+32,80,8);
	    RingToAngle(my->X+128,my->Y+32,90,8);
	    RingToAngle(my->X+128,my->Y+32,100,8);
	    break;
	  case 6:
	    HomingShot(my->X-90,my->Y-20,-15,-10);
	    HomingShot(my->X-60,my->Y-20,0,-10);
	    HomingShot(my->X+60,my->Y-20,0,-10);
	    HomingShot(my->X+90,my->Y-20,15,-10);
	    break;
	  case 8:
	    LaserShot(my->X-120,my->Y,20);
	    LaserShot(my->X-30,my->Y,20);
	    LaserShot(my->X+30,my->Y,20);
	    LaserShot(my->X+120,my->Y,20);
	    break;
	}
	my->Cnt[4]++;
    }
    else
    {
	my->Cnt[3]--;
	if (my->Cnt[3] < 20)
	{
	    if (my->Cnt[3]%2 == 0)
		my->image = 0;
	    else
		my->image = 1;
	}
    }

    if (my->Cnt[4] >= 50)
    {
	my->Cnt[3] = 100;
	my->Cnt[4] = 0;
	my->hitAtt = 0;
	my->image = 1;

	my->X = random()%FieldW;
	my->Y = random()%FieldH;
    }

    return NoneDel;
}

int NewBoss7(void)
{
    manage->New.Data.hitAtt = MEnemy;
    manage->New.Data.hitMask = MPlayer | MPShot;

    manage->New.Data.X = FieldW/2;
    manage->New.Data.Y = 0;

    manage->New.Data.HP = 150 + 30*manage->Loop;
    manage->New.Data.Point = 8000;
    manage->New.Data.EnemyAtt = BossDel;

    manage->New.Data.Width = 32;
    manage->New.Data.Height = 32;

    manage->New.Data.Cnt[0] = 0;
    manage->New.Data.Cnt[1] = 0; /*** ̵Ũ ***/
    manage->New.Data.Cnt[2] = 0; /*** image counter***/

    do {
	manage->New.Data.Cnt[3] = random()%30 - 15; /*** x move ***/
    }while (abs(manage->New.Data.Cnt[3]) < 5);
    do {
	manage->New.Data.Cnt[4] = random()%30 - 15; /*** y move ***/
    }while (abs(manage->New.Data.Cnt[4]) < 5);

    manage->New.Data.Cnt[5] = 0;  /*** shot counter ***/

    manage->New.Grp.image = EBoundImage;
    return NewObj(MEnemy,BossAct7,BossHit1,DrawImage);
}

DelAtt BossAct7(ObjData *my)
{
    my->image++;
    if (my->image >= 8)
        my->image = 0;

    if (my->Cnt[5] >= 20)
    {
	BoundShot(my->X,my->Y,random()%30-15,random()%30-15,3*manage->Loop);
	my->Cnt[5] = 0;
    }
    else
	my->Cnt[5]++;

    if ((my->X+my->Cnt[3]>FieldW) || (my->X+my->Cnt[3]<0))
        my->Cnt[3] = my->Cnt[3]*(-1);
    if ((my->Y+my->Cnt[4]>FieldH) || (my->Y+my->Cnt[4]<0))
        my->Cnt[4] = my->Cnt[4]*(-1);

    my->X += my->Cnt[3];
    my->Y += my->Cnt[4];

    return NoneDel;
}

int NewBoss8(void)
{
    manage->New.Data.hitAtt = MEnemy;
    manage->New.Data.hitMask = MPlayer | MPShot;

    manage->New.Data.X = FieldW/2;
#ifdef PDA
    manage->New.Data.Y = -130;
#else
    manage->New.Data.Y = -80;
#endif

    manage->New.Data.HP = 600 + 100*manage->Loop;
    manage->New.Data.Point = 10000;
    manage->New.Data.EnemyAtt = BossDel;

    manage->New.Data.Width = 230;
    manage->New.Data.Height = 180;

    manage->New.Data.Cnt[0] = 0;
    manage->New.Data.Cnt[1] = 200; /*** ̵Ũ ***/
    manage->New.Data.Cnt[2] = 0; /*** image counter***/
    manage->New.Data.Cnt[3] = 10; /*** x move ***/
    manage->New.Data.Cnt[4] = 0; /*** y move ***/
    manage->New.Data.Cnt[5] = 0;  /*** shot counter ***/
    manage->New.Data.Cnt[6] = 0; /*** mode ***/
    manage->New.Data.Cnt[7] = 0; /*** mode counter ***/
    manage->New.Data.Cnt[8] = 0; /*** ˴ ***/

    manage->New.Grp.image = Boss7Image;
    return NewObj(MEnemy,BossAct8,BossHit8,DrawImage);
}

DelAtt BossAct8(ObjData *my)
{
    if (my->Cnt[0] < my->Cnt[1])
    {/*** äо ***/
	my->Y++;
	my->Cnt[0]++;
	return NoneDel;
    }

    if (my->kill == True)
    {
        NewLargeBomb(my->X+random()%230-115,my->Y+random()%180-90);
        NewLargeBomb(my->X+random()%230-115,my->Y+random()%180-90);
	my->Cnt[8]++;

	if (my->Cnt[8] > 100)
	{
	    int i,j;
	    for (i=0; i<=10; i++)
		for (j=0; j<=10; j++)
		    NewLargeBomb(50*i,65*j);
	    return my->EnemyAtt;
	}
	else
	    return NoneDel;
    }

    if (my->Cnt[5] > 8)
	my->Cnt[5] = 0;
    else
	my->Cnt[5]++;

    if (my->Cnt[5]%2==0 && my->Cnt[6]!=4)
    {
	RingToAngle(my->X, my->Y-60, random()%50+70, random()%15+5);
	RingToAngle(my->X, my->Y-60, random()%20+80, random()%10+10);
	if (manage->Loop > 2)
	    RingToAngle(my->X, my->Y-60, random()%20+80, random()%5+15);
    }

    if (my->Cnt[6] == 0)
    {
	if (my->Cnt[5]%5 == 0)
	{
	    ShotToAngle(my->X-60, my->Y-60, random()%50 + 70, random()%5+5);
	    ShotToPoint(my->X-60,my->Y-60,manage->player[0]->Data.X,manage->player[0]->Data.Y,random()%5+3);
	}
	
	if (my->Cnt[7] > 100)
	{
	    my->Cnt[6] = 1;
	    my->Cnt[7] = 0;
	}
	else
	    my->Cnt[7]++;
    }
    else if (my->Cnt[6] == 1)
    {
	if (my->Cnt[5]%3 == 0)
	    RingToPoint(my->X-60, my->Y+10, manage->player[0]->Data.X,manage->player[0]->Data.Y,random()%10+5);

	if (my->Cnt[7] > 100)
	{
	    my->Cnt[6] = 2;
	    my->Cnt[7] = 0;
	}
	else
	    my->Cnt[7]++;
    }
    else if (my->Cnt[6] == 2)
    {
	if (my->Cnt[5] == 0)
	    BoundShot(my->X+60,my->Y-60,random()%20-10,random()%4+10,manage->Loop);

	if (my->Cnt[7] > 100)
	{
	    my->Cnt[6] = 3;
	    my->Cnt[7] = 0;
	}
	else
	    my->Cnt[7]++;
    }
    else if (my->Cnt[6] == 3)
    {
	if (my->Cnt[5] == 0)
	{
	    HomingShot(my->X+60,my->Y-10,-20,-10);
	    HomingShot(my->X+60,my->Y-10, 20,-10);
	    if (manage->Loop > 2)
	    {
		HomingShot(my->X+60,my->Y-10,-10,-10);
		HomingShot(my->X+60,my->Y-10, 10,-10);
	    }
	}
	if (my->Cnt[7] > 100)
	{
	    my->Cnt[6] = 4;
	    my->Cnt[7] = 0;
	}
	else
	    my->Cnt[7]++;
    }
    else if (my->Cnt[6] == 4)
    {
	if (my->Cnt[7] == 40)
	{
	    int i;
	    for (i=0; i<24; i++)
		ShotToAngle(my->X,my->Y,i*15,15);
	}
	if (my->Cnt[7] == 45)
	{
	    int i;
	    for (i=0; i<24; i++)
		ShotToAngle(my->X,my->Y,i*15+7,20);
	}
	if (my->Cnt[7] > 45)
	{
	    LaserShot(my->X-120,my->Y-60,35);
	    LaserShot(my->X-80 ,my->Y-60,35);
	    LaserShot(my->X-40 ,my->Y-60,35);
	    LaserShot(my->X    ,my->Y-60,35);
	    LaserShot(my->X+40 ,my->Y-60,35);
	    LaserShot(my->X+80 ,my->Y-60,35);
	    LaserShot(my->X+120,my->Y-60,35);
	}
	if (my->Cnt[7] > 50)
	{
	    my->Cnt[6] = 0;
	    my->Cnt[7] = 0;
	}
	my->Cnt[7]++;
    }

    if (my->Cnt[6] != 4)
    {
	if (my->X>manage->player[0]->Data.X && my->X>my->HarfW)
	    my->X--;
	else if (my->X<manage->player[0]->Data.X && my->X<(FieldW-my->HarfW))
	    my->X++;
    }

    return NoneDel;
}

DelAtt BossHit8(ObjData *my, ObjData *your)
{
    if (my->Cnt[0] < my->Cnt[1])
	return NoneDel;
    if (my->Cnt[6] == 4)
	return NoneDel;
    /*** ξ̵֤Ũ ***/

    my->HP -= your->Attack;
    if (my->HP <= 0)
	my->kill = True;

    return NoneDel;
}
