/*
 * XSOLDIER, a video-oriented game
 * Copyright (C) 1997, Yuusuke HASHIMOTO
 *                     s945750@educ.info.kanagawa-u.ac.jp
 *
 * ܥץˤ copyleft ŬѤƤޤCONDITION ե򻲾Ȥ
 * Ƥ
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include "image.h"
#include "xsoldier.h"
#include "extern.h"
#include "key.h"
#include "star.h"

#ifdef JSTK
#include "joystick.h"
#endif

void Ending(void)
{
    char stuff[][2][32] = 
    {
    {"XSoldier stuff",      ""},
    {"Producer",            "Y.Hashimoto"},
    {"Program",             "R.Masuda"},
    {"",                    "Y.Hashimoto"},
    {"Character Algorithm", "K.Inomata"},
    {"",                    "H.Yokobori"},
    {"",                    "M.Nakayama"},
    {"",                    "Y.Hashimoto"},
    {"Character Design",    "H.Hayakawa"},
    {"",                    "Y.Hashimoto"},
    {"Special Thanks",      "N.Oohashi"},
    {"",                    "T.Yamada"},
    {"",                    "T.Igari"},
    {"",                    "RAKI all members"},
    {"",                    ".... and YOU."},
    };

    char msg[][32] = 
    {
	"Try Next Stage!!",
	"You are great soldier!!!",
	"crazy ........"
    };

    int stfnumber = 15; /*** åտ ***/
    int count = 0;
#ifdef PDA
    int time = (stfnumber + 6) * 50;
#else
    int time = (stfnumber + 6) * 100;
#endif
    int len;
    int i;

    while (1)
    {
        if (waittime && (signal_delivered==0))
	    pause();
        signal_delivered = 0;

	if (count < time)
	    count++;

	while(XPending(dpy))
	{
	    XNextEvent(dpy,&event);
	    switch(event.type)
	    {
	      case EnterNotify:
		XAutoRepeatOff(dpy);
		break;
	      case LeaveNotify:
		XAutoRepeatOn(dpy);
		break;
	      case KeyPress:
                if (XLookupKeysym(&(event.xkey),0) == XK_space)
                {
		    if (count >= time)
			return;
		}
	    }
	}
	
#ifdef JSTK
	readJS();
	if ((joymask&Shot) || (joymask&SpeedUP))	
	{
	    if (count >= time)
		return;
	}
#endif

	XFillRectangle(dpy,WorkPixmap,BackGC,0,0,FieldW,FieldH);
	DrawStar(StarPtn1);
	DrawStar(StarPtn2);

	for (i=0; i<stfnumber; i++)
	{
	    if (i == 0)
	    {
#ifdef PDA
		XDrawString(dpy,WorkPixmap,FontGC,85,FieldH - count + 50*i,stuff[i][0],strlen(stuff[i][0]));
		XDrawString(dpy,WorkPixmap,FontGC,180,FieldH - count + 50*i,stuff[i][1],strlen(stuff[i][1]));
#else
		XDrawString(dpy,WorkPixmap,FontGC,210,FieldH - count + 100*i,stuff[i][0],strlen(stuff[i][0]));
		XDrawString(dpy,WorkPixmap,FontGC,450,FieldH - count + 100*i,stuff[i][1],strlen(stuff[i][1]));
#endif
	    }
	    else
	    {
#ifdef PDA
		XDrawString(dpy,WorkPixmap,FontGC,35,FieldH - count + 50*i,stuff[i][0],strlen(stuff[i][0]));
		XDrawString(dpy,WorkPixmap,FontGC,120,FieldH - count + 50*i + 20,stuff[i][1],strlen(stuff[i][1]));
#else
		XDrawString(dpy,WorkPixmap,FontGC,100,FieldH - count + 100*i,stuff[i][0],strlen(stuff[i][0]));
		XDrawString(dpy,WorkPixmap,FontGC,300,FieldH - count + 100*i + 30,stuff[i][1],strlen(stuff[i][1]));
#endif
	    }
	}
	
	if (count > time-30)
	{
	    len = count - (time-30);

	    if (manage->Loop < 3)
	    {
		if (len > strlen(msg[manage->Loop-1]))
		    len = strlen(msg[manage->Loop-1]);
#ifdef PDA
		XDrawString(dpy,WorkPixmap,FontGC,63,150,msg[manage->Loop-1],len);
#else
		XDrawString(dpy,WorkPixmap,FontGC,200,400,msg[manage->Loop-1],len);
#endif
	    }
	    else
	    {
		if (len > strlen(msg[2]))
		    len = strlen(msg[2]);
#ifdef PDA
		XDrawString(dpy,WorkPixmap,FontGC,63,150,msg[2],len);
#else
		XDrawString(dpy,WorkPixmap,FontGC,200,400,msg[2],len);
#endif
	    }
	}

	XCopyArea(dpy,WorkPixmap,win,BackGC,0,0,FieldW,FieldH,0,0);

	XFlush(dpy);
	XSync(dpy,False);
    }
}
