/*
 * XSOLDIER, a video-oriented game
 * Copyright (C) 1997, Yuusuke HASHIMOTO
 *                     s945750@educ.info.kanagawa-u.ac.jp
 *
 * ܥץˤ copyleft ŬѤƤޤCONDITION ե򻲾Ȥ
 * Ƥ
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

#include "image.h"
#include "xsoldier.h"
#include "player.h"
#include "boss.h"
#include "enemy.h"
#include "extern.h"
#include "key.h"
#include "star.h"

#ifdef JSTK
#include "joystick.h"
#endif

/*** ؿ ***/
static void DrawInfo(void);
static void SetKeyMask(KeySym key);
static void UnsetKeyMask(KeySym key);

int mainLoop(void)
{
    int obj; /*** 롼ץ ***/
    int target; /*** 롼ץ󥿤2 ***/

    int ocheck; /*** 롼׺Ѥߥ֥ȥ ***/
    int tcheck; /*** ֥ȥ󥿤2 ***/
    int DelFlag; /*** Ƚե饰 ***/

    int oneUp = 0; /*** 1up Ƚ & ɸ ***/

    int (*NewEnemy[])(int x, int y) = 
    {
	NewEnemy1,NewEnemy2,NewEnemy3,NewEnemy4,NewEnemy5,
	NewEnemy6,NewEnemy7,NewEnemy8,NewEnemy9
    };/*** Ũνиؿ󡤤襤¤٤ ***/
    
    int (*NewBoss[])(void) =
    {
	NewBoss1,NewBoss2,NewBoss3,NewBoss4,NewBoss5,
	NewBoss6,NewBoss7,NewBoss8
    };/*** ܥνиؿ ***/
    
    int StageObj[] = 
    {
	80,80,100,100,120,120,140,140
    };/*** ơΥи ***/

    char StageName[][16] = 
    {
	"Stage 1","Stage 2","Stage 3","Stage 4","Stage 5",
	"Stage 6","Stage 7","Final Stage",
	"All Clear!"
    };
    
    /*** ץ쥤䡼Ͽ ***/
    NewPlayer(FieldW/2,FieldH - 32);
    
    XFlush(dpy);
    
    while (1)
    {
        if (waittime && (signal_delivered==0))
	    pause();
        signal_delivered = 0;

	while(XPending(dpy))
        {
            XNextEvent(dpy,&event);
            switch(event.type)
            {
              case Expose:
		if (event.xexpose.count == 0)
		    XCopyArea(dpy,WorkPixmap,win,BackGC,0,0,FieldW,FieldH,0,0);
		break;
              case EnterNotify:
                XAutoRepeatOff(dpy);
                break;
              case LeaveNotify:
                XAutoRepeatOn(dpy);
		if (manage->player[0]->Data.used==False && player->Ships==0)
		    return 0;
		else
		{
		    keymask = 0;
		    keymask |= Pause;
		}
                break;
              case KeyPress:
		if (manage->player[0]->Data.used==False && player->Ships==0)
		    return 0;/*** ४и奭 ***/
		else
		    SetKeyMask(XLookupKeysym(&(event.xkey),0));

		if ((keymask&Pause) && (keymask&Quit))
		    return 0;
		break;
              case KeyRelease:
                UnsetKeyMask(XLookupKeysym(&(event.xkey),0));
                break;
            }
        }
	
#ifdef JSTK
	readJS();
	if ((manage->player[0]->Data.used==False && player->Ships==0) && (joymask&Shot || joymask&SpeedUP))
	    return 0;/*** ४и奭 ***/
#endif

	if (keymask & Pause)
	{
#ifdef PDA
	    XDrawString(dpy,WorkPixmap,FontGC,100,130,"Pause",strlen("Pause"));
	    XDrawString(dpy,WorkPixmap,FontGC,40,150,"Press [",strlen("Press ["));
	    XDrawString(dpy,WorkPixmap,FontGC,88,150,pauseKey,strlen(pauseKey));
	    XDrawString(dpy,WorkPixmap,FontGC,100,150,"] to restart game",strlen("] to restart game"));
#else
	    XDrawString(dpy,WorkPixmap,FontGC,235,280,"Pause",strlen("Pause"));
	    XDrawString(dpy,WorkPixmap,FontGC,180,300,"Press [",strlen("Press ["));
	    XDrawString(dpy,WorkPixmap,FontGC,230,300,pauseKey,strlen(pauseKey));
	    XDrawString(dpy,WorkPixmap,FontGC,245,300,"] to restart game",strlen("] to restart game"));
#endif
	    XCopyArea(dpy,WorkPixmap,win,BackGC,0,0,FieldW,FieldH,0,0);
	    continue;
	}

	if (manage->Stage>MaxStage && manage->Appear>0)
	    break;
	
	if (manage->player[0]->Data.used == False)
	{/*** 줿! ***/
	    player->Rec[0].loop = manage->Loop;
	    player->Rec[0].stage = manage->Stage;
	    if (player->Ships > 0)
	    {
		player->Ships--;
		RestartPlayer(FieldW/2,FieldH - 32);
	    }
	}
	
	if (manage->BossKill == True)
	{/*** ܤ˴ ***/
	    player->Percent = (manage->StageShotDown/(double)manage->StageEnemy) * 100;

	    manage->Stage++;

	    manage->Level += 5;
	    if (manage->Level >= 100)
		manage->Level = 90;

	    player->Rec[0].score += player->Percent*100/2;
	    if (player->Percent >= 100)
		player->Rec[0].score += 5000*manage->Stage;

	    ClearManage(manage);

	    ChangeStarParameter(StarPtn1,20);
	    ChangeStarParameter(StarPtn2,25);
	}

	if (manage->Appear >= 100)
	{
	    if ((manage->StageEnemy>StageObj[manage->Stage-1]) && (manage->BossApp==False))
	    {/*** ܤо ***/
		if (NewBoss[manage->Stage-1]() != -1)
		{
		    if (manage->Loop < 2)
			manage->ZakoApp = False;
		    manage->BossApp = True;
		    manage->StageEnemy++;
		}
	    }
	    else if (manage->ZakoApp == True)
	    {/***  ***/
		if (NewEnemy[random()%(manage->Stage+1)]((random()%FieldW)+1,0) != -1)
		{
		    manage->StageEnemy++;
		}
	    }
	    /*** ŨνиΨ Ĵ;Ϥ? ***/
	    if (manage->BossApp == True) /*** ܥ֤Ͼܤ˽и ***/
		manage->Appear = 65 + manage->Stage*3;
	    else
		manage->Appear = 90 + manage->Stage/4 + manage->Loop;
	}
	else
	    manage->Appear++;

	for (obj=manage->PlayerMax-1,ocheck=0; (obj>=0 && ocheck<manage->PlayerNum); obj--)
	{/***  ***/
	    if (manage->player[obj]->Data.used == True)
	    {
		/*** ĤäƤʤä
		manage->player[obj]->Data.oldX = manage->player[obj]->Data.X;
		manage->player[obj]->Data.oldY = manage->player[obj]->Data.Y;
		/*** ɸԡ ***/

		if (manage->player[obj]->Action(&(manage->player[obj]->Data)) == NullDel)
		    DelObj(manage->player[obj]);
		else /*** η̡Ǥʤ褦ʤ饫 ***/
		    ocheck++; /*** Ѥߥ֥ȿ ***/
	    }
	}
	
	for (obj=0,ocheck=0; (obj<manage->EnemyMax && ocheck<manage->EnemyNum); obj++)
	{/***  ***/
	    if (manage->enemy[obj]->Data.used == True)
	    {
		/***
		manage->enemy[obj]->Data.oldX = manage->enemy[obj]->Data.X;
		manage->enemy[obj]->Data.oldY = manage->enemy[obj]->Data.Y;
		/*** ɸԡ ***/

		DelFlag = manage->enemy[obj]->Action(&(manage->enemy[obj]->Data));
		switch (DelFlag)
		{
		  case NoneDel:
		    ocheck++;
		    break;
		    /*** Ѥߥ֥ȿ ***/
		  case BossDel:
		    manage->BossKill = True;
		  case ZakoDel:
		    player->Rec[0].score += manage->enemy[obj]->Data.Point;
		    manage->StageShotDown++;
		  case NullDel:
		    DelObj(manage->enemy[obj]);
		}
	    }
	}
	
	for (obj=0; (obj<manage->PlayerMax); obj++)
	{/*** Ƚ ***/
	    if (manage->player[obj]->Data.used == False)
		continue;
	    if (manage->player[obj]->Data.kill == True)
		continue;

	    for (target=0; (target<manage->EnemyMax); target++)
	    {
		if (manage->enemy[target]->Data.used == False)
		    continue;
		if (manage->enemy[target]->Data.kill == True)
		    continue;

		if (manage->player[obj]->Data.hitMask & manage->enemy[target]->Data.hitAtt)
		{
		    if (abs(manage->player[obj]->Data.X-manage->enemy[target]->Data.X)
			> manage->player[obj]->Data.HarfW+manage->enemy[target]->Data.HarfW)
			continue;
		    if (abs(manage->player[obj]->Data.Y-manage->enemy[target]->Data.Y)
			> manage->player[obj]->Data.HarfH+manage->enemy[target]->Data.HarfH)
			continue;

		    /*** ꤣ ***/
		    if (manage->player[obj]->Hit(&(manage->player[obj]->Data),&(manage->enemy[target]->Data)) == NullDel)
			DelObj(manage->player[obj]);

		    DelFlag = manage->enemy[target]->Hit(&(manage->enemy[target]->Data),&(manage->player[obj]->Data));
		    switch (DelFlag)
		    {
		      case BossDel:
			manage->BossKill = True;
		      case ZakoDel:
			player->Rec[0].score += manage->enemy[target]->Data.Point;
			manage->StageShotDown++;
		      case NullDel:
			DelObj(manage->enemy[target]);
		    }
		}
	    }
	}

	/*** 1up ʤ? ***/
	if (player->Rec[0].score >= player->Next)
	{
	    player->Next += EVERY1UP;
	    player->Ships++;

	    oneUp = 1; /*** 1UP ɽ ***/
	}

	/*** ǥХå饦ɤŽ ***/
	XFillRectangle(dpy,WorkPixmap,BackGC,0,0,FieldW,FieldH);
	DrawStar(StarPtn1);
	DrawStar(StarPtn2);
	/*** ˥ĥդ ***/
	for (obj=0,ocheck=0; (obj<manage->EnemyMax && ocheck<manage->EnemyNum); obj++)
	{
	    if (manage->enemy[obj]->Data.used == True)
	    {
		manage->enemy[obj]->Realize(&(manage->enemy[obj]->Data),&(manage->enemy[obj]->Grp));
		ocheck++;
	    }
	}
	for (obj=manage->PlayerMax-1,ocheck=0; (obj>=0 && ocheck<manage->PlayerNum); obj--)
	{
	    if (manage->player[obj]->Data.used == True)
	    {
		manage->player[obj]->Realize(&(manage->player[obj]->Data),&(manage->player[obj]->Grp));
		ocheck++;
	    }
	}
	/*** Ǹ˥Ȥ ***/
	DrawInfo();

	/*** ¾˱ƽ ***/
	if (oneUp != 0)
	{
	    if (oneUp%4 > 1)
#ifdef PDA
		XDrawString(dpy,WorkPixmap,FontGC,210,276,"1UP",strlen("1UP"));
#else
		XDrawString(dpy,WorkPixmap,FontGC,440,620,"1UP",strlen("1UP"));
#endif
	    oneUp++;
	    if (oneUp > 50)
		oneUp = 0;
	}

	if (manage->player[0]->Data.kill==True && player->Ships==0)
#ifdef PDA
	    XDrawString(dpy,WorkPixmap,FontGC,88,140,"Game Over",strlen("Game Over"));
#else
	    XDrawString(dpy,WorkPixmap,FontGC,230,300,"Game Over",strlen("Game Over"));
#endif
	if (manage->Appear < 0)
	{
	    char Percent[32];
	    char Bonus[32];
	    char Perfect[32];

	    if (manage->Stage != 1)
	    {/*** Ψɽ ***/
		sprintf(Percent,"shoot down %02d%%",player->Percent);
#ifdef PDA
		XDrawString(dpy,WorkPixmap,FontGC,85,170,Percent,strlen(Percent));
#else
		XDrawString(dpy,WorkPixmap,FontGC,210,370,Percent,strlen(Percent));
#endif

		sprintf(Bonus,"Bonus %d pts",player->Percent*100/2);
#ifdef PDA
		XDrawString(dpy,WorkPixmap,FontGC,85 + manage->Appear*3 ,200,Bonus,strlen(Bonus));
#else
		XDrawString(dpy,WorkPixmap,FontGC,260 + manage->Appear*3 ,400,Bonus,strlen(Bonus));
#endif

		if (player->Percent >= 100)
		{
		    sprintf(Perfect,"Perfect!! %4d pts",5000*manage->Stage);
#ifdef PDA
		    XDrawString(dpy,WorkPixmap,FontGC,85 - manage->Appear*3 ,220,Perfect,strlen(Perfect));
#else
		    XDrawString(dpy,WorkPixmap,FontGC,170 - manage->Appear*3 ,420,Perfect,strlen(Perfect));
#endif
		}
	    }
#ifdef PDA
	    XDrawString(dpy,WorkPixmap,FontGC,95,240,StageName[manage->Stage-1],strlen(StageName[manage->Stage-1]));
#else
	    XDrawString(dpy,WorkPixmap,FontGC,230,320,StageName[manage->Stage-1],strlen(StageName[manage->Stage-1]));
#endif
	}
	if (manage->Appear == 0)
	{
	    ChangeStarParameter(StarPtn1,5);
	    ChangeStarParameter(StarPtn2,10);
	}

	XCopyArea(dpy,WorkPixmap,win,BackGC,0,0,FieldW,FieldH,0,0);
	/*** 夬򥦥ɥ ***/
	
	XFlush(dpy);
	XSync(dpy,False);
    }

    return 1;
    /*** ending ***/
}

static void DrawInfo(void)
{/*** ʤɤɽ ***/
    static char Score[64];
    static char Hiscore[64];
    static char Ships[16];
    static char Stage[16];
#ifdef DEBUG
    static char ObjectP[32];
    static char ObjectE[32];
    static char Loop[16];
    static char Level[16];
    static char Weapon[16];
    static char Pow[16];
    static char Speed[16];
    static char Enemy[16];
    static char EnemyKill[16];
#endif

    if (player->Rec[0].score > player->Rec[1].score)
	sprintf(Hiscore,"Hi %08d",player->Rec[0].score);
    else
	sprintf(Hiscore,"Hi %08d",player->Rec[1].score);
    sprintf(Score,"Score %08d",player->Rec[0].score);
    sprintf(Stage,"Stage %2d",manage->Stage);
    sprintf(Ships,"Ships %3d",player->Ships);
#ifdef DEBUG
    sprintf(ObjectE,"Enemy Object %3d",manage->EnemyNum);
    sprintf(ObjectP,"Player Object %3d",manage->PlayerNum);
    sprintf(Loop,"Loop %2d",manage->Loop);
    sprintf(Level,"Level %3d",manage->Level);
    sprintf(Weapon,"Weapon %d",manage->player[0]->Data.Cnt[5]);
    sprintf(Pow,"Pow %02d",manage->player[0]->Data.Cnt[6]);
    sprintf(Speed,"Speed %02d",manage->player[0]->Data.Speed);
    sprintf(Enemy,"Enemy %3d",manage->StageEnemy);
    sprintf(EnemyKill,"EnemyKill %3d",manage->StageShotDown);
#endif

#ifdef PDA
    XDrawString(dpy,WorkPixmap,FontGC,3,288,Hiscore,strlen(Hiscore));
    XDrawString(dpy,WorkPixmap,FontGC,3,12,Score,strlen(Score));
    XDrawString(dpy,WorkPixmap,FontGC,176,12,Stage,strlen(Stage));
    XDrawString(dpy,WorkPixmap,FontGC,174,288,Ships,strlen(Ships));
#else
    XDrawString(dpy,WorkPixmap,FontGC,230,20,Hiscore,strlen(Hiscore));
    XDrawString(dpy,WorkPixmap,FontGC,10,20,Score,strlen(Score));
    XDrawString(dpy,WorkPixmap,FontGC,430,20,Stage,strlen(Stage));
    XDrawString(dpy,WorkPixmap,FontGC,430,640,Ships,strlen(Ships));
#endif
#ifdef DEBUG
    XDrawString(dpy,WorkPixmap,FontGC,10,40,ObjectE,strlen(ObjectE));
    XDrawString(dpy,WorkPixmap,FontGC,10,60,ObjectP,strlen(ObjectP));
    XDrawString(dpy,WorkPixmap,FontGC,10,80,Level,strlen(Level));
    XDrawString(dpy,WorkPixmap,FontGC,10,100,Enemy,strlen(Enemy));
    XDrawString(dpy,WorkPixmap,FontGC,10,120,EnemyKill,strlen(EnemyKill));
    XDrawString(dpy,WorkPixmap,FontGC,430,40,Loop,strlen(Loop));
    XDrawString(dpy,WorkPixmap,FontGC,430,580,Weapon,strlen(Weapon));
    XDrawString(dpy,WorkPixmap,FontGC,430,600,Pow,strlen(Pow));
    XDrawString(dpy,WorkPixmap,FontGC,430,620,Speed,strlen(Speed));
#endif
}

static void SetKeyMask(KeySym key)
{
    switch(key)
    {
      case UpKey:        keymask |= Up;        break;
      case DownKey:      keymask |= Down;      break;
      case LeftKey:      keymask |= Left;      break;
      case RightKey:     keymask |= Right;     break;
      case ShotKey:      keymask |= Shot;      break;
      case SpeedUPKey:   keymask |= SpeedUP;   break;
      case SpeedDOWNKey: keymask |= SpeedDOWN; break;
      case PauseKey:     keymask ^= Pause;     break;
	/*** ٤˥ե饰ȿž ***/
      case QuitKey:      keymask |= Quit;      break;
#ifdef DEBUG
      case XK_w:
	if (manage->player[0]->Data.Cnt[5] == 3)
	    manage->player[0]->Data.Cnt[5] = 0;
	manage->player[0]->Data.Cnt[5]++;
	break;
#endif
    }
}

static void UnsetKeyMask(KeySym key)
{
    switch(key)
    {
      case UpKey:        keymask &= ~Up;        break;
      case DownKey:      keymask &= ~Down;      break;
      case LeftKey:      keymask &= ~Left;      break;
      case RightKey:     keymask &= ~Right;     break;
      case ShotKey:      keymask &= ~Shot;      break;
      case SpeedUPKey:   keymask &= ~SpeedUP;   break;
      case SpeedDOWNKey: keymask &= ~SpeedDOWN; break;

      case QuitKey:      keymask &= ~Quit;      break;
    }
}
