#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "tetris.h"

#ifdef BIGBLOCKS
#include "big_blocks.xpm"
#else
#include "blocks.xpm"
#endif

GtkWidget *main_window;
GtkWidget *score_label;
GtkWidget *level_label;
GtkWidget *lines_label;
GtkWidget *menu_game_quick;
GtkWidget *menu_game_start;
GtkWidget *menu_game_stop;
GtkWidget *menu_game_pause;
GtkWidget *menu_game_show_next_block;
GtkWidget *spin_level;
GtkWidget *spin_noise_level;
GtkWidget *spin_noise_height;
GtkWidget *spin_noise_height;
GtkWidget *new_game_window;
gint timer;

int level_speeds[NUM_LEVELS] = 
	{1000,886,785,695,616,546,483,428,379,336,298,264,234,207,183,162,144,127,113,100};	

void update_game_values()
{
	char dummy[20] = "";

	sprintf(dummy,"Score:\n%lu",current_score);
	set_label(score_label,dummy);
	sprintf(dummy,"Level:\n%d",current_level);
	set_label(level_label,dummy);
	sprintf(dummy,"Lines:\n%d",current_lines);
	set_label(lines_label,dummy);
}

gint keyboard_event_handler(GtkWidget *widget,GdkEventKey *event,gpointer data)
{
	int dropbonus = 0;
	
	if(game_over || game_pause)
		return TRUE;
	
	switch(event->keyval)
	{
		case GDK_x: case GDK_X: move_block(0,0,1); break;
		case GDK_w: case GDK_W: case GDK_Up: move_block(0,0,-1); break;
		case GDK_s: case GDK_S: case GDK_Down: move_down(); break;
		case GDK_a: case GDK_A: case GDK_Left: move_block(-1,0,0); break;
		case GDK_d: case GDK_D: case GDK_Right: move_block(1,0,0); break;
		case GDK_space:
			while(move_down())
				dropbonus++;
			current_score += dropbonus*(current_level+1);
			update_game_values();
			break;
	}
	return TRUE;
}

gint game_area_expose_event(GtkWidget *widget, GdkEventExpose *event)
{	
	if(!game_over)
	{
		from_virtual();
		move_block(0,0,0); 
	}
	else
		gdk_draw_rectangle(widget->window,
			widget->style->black_gc,
			TRUE,
			0,0,
			widget->allocation.width,
			widget->allocation.height);
	return FALSE;
}

gint next_block_area_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
	gdk_draw_rectangle(widget->window,
		widget->style->black_gc,
		TRUE,
		0,0,
		widget->allocation.width,
		widget->allocation.height);
	if(!game_over && show_next_block)
		draw_block(0,0,next_block,next_frame,FALSE,TRUE);
	return FALSE;
}

int game_loop()
{
	if(!game_over)
	{
		timer = gtk_timeout_add(level_speeds[current_level],(GtkFunction)game_loop,NULL);
		move_down();
	}
	return FALSE;
}

void game_set_pause()
{
	if(game_over)
	{
		gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(menu_game_pause),FALSE);
		return;
	}
	game_pause = !game_pause;
	if(game_pause)
		gtk_timeout_remove(timer);
	else
		timer = gtk_timeout_add(level_speeds[current_level],(GtkFunction)game_loop,NULL);
}

void game_over_init()
{
	int high_dummy;
	read_highscore();
	if(current_score && (high_dummy = addto_highscore((char *)getenv("USER"),current_score)))
	{
		write_highscore();
		show_highscore(high_dummy);
	}
	
	game_over = TRUE;
	gdk_draw_rectangle(game_area->window,
		game_area->style->black_gc,
		TRUE,
		0,0,
		game_area->allocation.width,
		game_area->allocation.height);

	gdk_draw_rectangle(next_block_area->window,
		next_block_area->style->black_gc,
		TRUE,
		0,0,
		next_block_area->allocation.width,
		next_block_area->allocation.height);
	game_set_pause();
	gtk_widget_set_sensitive(menu_game_quick,TRUE);
	gtk_widget_set_sensitive(menu_game_start,TRUE);
	gtk_widget_set_sensitive(menu_game_stop,FALSE);
	gtk_timeout_remove(timer);
}

void game_start_stop(GtkWidget *widget,gpointer *data)
{
	gtk_widget_set_sensitive(widget, FALSE);
	if(data)
	{
		gtk_widget_set_sensitive(menu_game_stop,TRUE);
		gtk_widget_set_sensitive(menu_game_start,FALSE);
		game_init();
		timer = gtk_timeout_add(level_speeds[current_level],(GtkFunction)game_loop,NULL);
	}
	else
	{
		game_over_init();
		gtk_widget_set_sensitive(menu_game_quick,TRUE);
		gtk_widget_set_sensitive(menu_game_start,TRUE);
	}
}

void show_about()
{
	GtkWidget *about_window;
	GtkWidget *about_label;
	GtkWidget *about_border;
	GtkWidget *v_box;
	
	about_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(about_window),"About");
	gtk_window_set_policy(GTK_WINDOW(about_window),FALSE,FALSE,TRUE);
	gtk_window_set_position(GTK_WINDOW(about_window),GTK_WIN_POS_CENTER);
	gtk_container_border_width(GTK_CONTAINER(about_window),1);
	
	about_border = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(about_border),GTK_SHADOW_OUT);
	gtk_container_add(GTK_CONTAINER(about_window),about_border);
	
	v_box = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(about_border),v_box);
		
	about_label = gtk_label_new(	"\nJust another GTK Tetris v0.5\n\n"
					"(c)1999,2000 Mattias Wadman\n"
					"napolium@sudac.org\n\n"
					"Modified for PDA screen by"
					"Chester Kuo (C) 2001\n"
					"This program is distributed under the terms of GPL.\n");
	gtk_box_pack_start(GTK_BOX(v_box),about_label,FALSE,FALSE,0);
	
	gtk_widget_show_all(about_window);
}

void show_help()
{
	GtkWidget *help_window;
	GtkWidget *help_label;
	GtkWidget *help_border;
	GtkWidget *hbox;
	
	help_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(help_window),"Help");
	gtk_window_set_policy(GTK_WINDOW(help_window),FALSE,FALSE,TRUE);
	gtk_window_set_position(GTK_WINDOW(help_window),GTK_WIN_POS_CENTER);
	gtk_container_border_width(GTK_CONTAINER(help_window),1);
	
	help_border = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(help_border),GTK_SHADOW_OUT);
	gtk_container_add(GTK_CONTAINER(help_window),help_border);

	hbox = gtk_hbox_new(FALSE,30);
	gtk_container_add(GTK_CONTAINER(help_border),hbox);

	help_label = gtk_label_new(	"Key:\n"
					"Right and \"a\"\n"
					"Left and \"d\"\n"
					"Down and \"s\"\n"
					"Up and \"w\"\n"
					"\"x\"\n"
					"Space\n\n"
					"Score: score*level\n"
					"Single\n"
					"Double\n"
					"Triple\n"
					"TETRIS\n\n"
					"Drop bonus: rows*level\n");
	gtk_misc_set_alignment(GTK_MISC(help_label),0,0);	
	gtk_label_set_justify(GTK_LABEL(help_label),GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(hbox),help_label,TRUE,TRUE,TRUE);

	help_label = gtk_label_new(	"\n"
					"move right\n"
					"move left\n"
					"move down\n"
					"rotate ccw\n"
					"rotate cw\n"
					"drop block\n\n\n"
					"40\n100\n"
					"300\n1200\n");
	gtk_misc_set_alignment(GTK_MISC(help_label),0,0);	
	gtk_label_set_justify(GTK_LABEL(help_label),GTK_JUSTIFY_LEFT);
	gtk_box_pack_start(GTK_BOX(hbox),help_label,TRUE,TRUE,TRUE);
	
	gtk_widget_show_all(help_window);
}

void game_new_wrapper()
{
	int new_level,new_noise_level,new_noise_height;

	new_level = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin_level));
	new_noise_level = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin_noise_level));
	new_noise_height = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin_noise_height));
	
	gtk_widget_set_sensitive(menu_game_quick,FALSE);
	gtk_widget_set_sensitive(menu_game_start,FALSE);
	gtk_widget_set_sensitive(menu_game_stop,TRUE);
	
	game_init();
	make_noise(new_noise_level,new_noise_height);
	from_virtual();
	move_block(0,0,0);
	current_level = new_level;
	update_game_values(0,current_level,0);
	timer = gtk_timeout_add(level_speeds[current_level],(GtkFunction)game_loop,NULL);
	gtk_widget_hide(new_game_window);
}

void show_new_game_close(int close)
{
	gtk_widget_set_sensitive(menu_game_start,TRUE);
	gtk_widget_set_sensitive(menu_game_quick,TRUE);
	if(close)
		gtk_widget_hide(new_game_window);
}


void show_new_game()
{
	GtkWidget *label;
	GtkWidget *frame;
	GtkWidget *vbox,*hbox;
	GtkWidget *table;
	GtkWidget *button;
	GtkAdjustment *adj;
	
	new_game_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	
	gtk_signal_connect(GTK_OBJECT(new_game_window),"destroy",
				GTK_SIGNAL_FUNC(show_new_game_close),GINT_TO_POINTER(FALSE));
	
	gtk_window_set_title(GTK_WINDOW(new_game_window),"New game");
	gtk_window_set_position(GTK_WINDOW(new_game_window),GTK_WIN_POS_CENTER);
	gtk_container_border_width(GTK_CONTAINER(new_game_window),3);
	
	vbox = gtk_vbox_new(FALSE,2);
	gtk_container_add(GTK_CONTAINER(new_game_window),vbox);
	
	frame = gtk_frame_new("Game settings:");
	gtk_box_pack_start(GTK_BOX(vbox),frame,TRUE,TRUE,TRUE);

	table = gtk_table_new(3,2,TRUE);
	gtk_container_add(GTK_CONTAINER(frame),table);
	
	label = gtk_label_new("Start level:");
	adj = (GtkAdjustment *)gtk_adjustment_new(0,0,NUM_LEVELS-1,1,1,0);
	spin_level = gtk_spin_button_new(adj,0,0);	
	gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,0,1);
	gtk_table_attach_defaults(GTK_TABLE(table),spin_level,1,2,0,1);
	
	label = gtk_label_new("Noise level:");
	adj = (GtkAdjustment *)gtk_adjustment_new(0,0,MAX_X-1,1,1,0);
	spin_noise_level = gtk_spin_button_new(adj,0,0);	
	gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,1,2);
	gtk_table_attach_defaults(GTK_TABLE(table),spin_noise_level,1,2,1,2);
	
	label = gtk_label_new("Noise height:");
	adj = (GtkAdjustment *)gtk_adjustment_new(0,0,MAX_Y-4,1,1,0);
	spin_noise_height = gtk_spin_button_new(adj,0,0);	
	gtk_table_attach_defaults(GTK_TABLE(table),label,0,1,2,3);
	gtk_table_attach_defaults(GTK_TABLE(table),spin_noise_height,1,2,2,3);
	
	hbox = gtk_hbox_new(TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,TRUE,0);
	
	button = gtk_button_new_with_label("Close");	
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
				GTK_SIGNAL_FUNC(show_new_game_close),GINT_TO_POINTER(TRUE));	
	gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,TRUE,0);
  	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
	
	button = gtk_button_new_with_label("Start game");	
	gtk_signal_connect(GTK_OBJECT(button),"clicked",
				GTK_SIGNAL_FUNC(game_new_wrapper),
				NULL);	
	gtk_box_pack_start(GTK_BOX(hbox),button,FALSE,TRUE,0);
  	GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
    	gtk_widget_grab_default (button);
		
	gtk_widget_set_usize(new_game_window,220,130);
	gtk_widget_show_all(new_game_window);
	gtk_widget_set_sensitive(menu_game_start,FALSE);
	gtk_widget_set_sensitive(menu_game_quick,FALSE);
}

void show_highscore_wrapper()
{
	read_highscore();
	show_highscore(0);
}

void game_show_next_block()
{
	show_next_block = !show_next_block;
	if(!game_over)
		if(!show_next_block)
			draw_block(0,0,next_block,next_frame,TRUE,TRUE);
		else
			draw_block(0,0,next_block,next_frame,FALSE,TRUE);
}


int main(int argc,char *argv[])
{	
	GtkWidget *v_box;
	GtkWidget *h_box;
	GtkWidget *right_side;
	GtkWidget *game_border;	
	GtkWidget *next_block_border;
	GdkBitmap *mask;	
	GtkAccelGroup *accel = gtk_accel_group_get_default();	
	GtkWidget *menu;
	GtkWidget *menu_bar;
	
	gtk_init(&argc,&argv);

	// init game values
	game_over = TRUE;
	game_pause = FALSE;
	current_x = current_y = 0;
	current_block = current_frame = 0;
	current_score = current_level = current_lines = 0;
	next_block = next_frame = 0;
	show_next_block = TRUE;
	
	// window
	main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_policy(GTK_WINDOW(main_window),FALSE,FALSE,TRUE);
	gtk_signal_connect(GTK_OBJECT(main_window),"delete_event",
			GTK_SIGNAL_FUNC(gtk_main_quit),NULL);
	gtk_window_set_title(GTK_WINDOW(main_window),"GTK Tetris");
	gtk_signal_connect(GTK_OBJECT(main_window),"key_press_event",
			GTK_SIGNAL_FUNC(keyboard_event_handler),NULL);
	
	// vertical box
	v_box = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(main_window),v_box);
	gtk_widget_show(v_box);
	
	// menu stuff
	menu_bar = gtk_menu_bar_new();
	gtk_widget_show(menu_bar);
	gtk_box_pack_start(GTK_BOX(v_box),menu_bar,FALSE,FALSE,0);
	menu = gtk_menu_new();	
	
	menu_game_quick = add_menu_item("Quick game",game_start_stop,GINT_TO_POINTER(TRUE),TRUE,menu);
#ifndef PDA
	gtk_widget_add_accelerator(menu_game_quick,"activate",accel,'Q',GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);	
	
#endif
	menu_game_start = add_menu_item("New game",show_new_game,GINT_TO_POINTER(TRUE),TRUE,menu);
#ifndef PDA
	gtk_widget_add_accelerator(menu_game_start,"activate",accel,'N',GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
		
#endif
	menu_game_stop = add_menu_item("Stop game",game_start_stop,GINT_TO_POINTER(FALSE),FALSE,menu);
#ifndef PDA
	gtk_widget_add_accelerator(menu_game_stop,"activate",accel,'S',GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
#endif
	
	menu_game_pause = add_menu_item_toggle("Pause",game_set_pause,NULL,FALSE,menu);
#ifndef PDA
	gtk_widget_add_accelerator(menu_game_pause,"activate",accel,'P',GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);
	
#endif
	menu_game_show_next_block = add_menu_item_toggle("Show next block",game_show_next_block,NULL,TRUE,menu);
	
	add_menu_item("",NULL,NULL,FALSE,menu);
#ifndef PDA
	gtk_widget_add_accelerator(add_menu_item("Quit",gtk_main_quit,NULL,TRUE,menu),
			"activate",accel,'X',GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE);	
#endif
	add_submenu("Game",menu,menu_bar,FALSE);
	menu = gtk_menu_new();
	add_menu_item("Help",show_help,NULL,TRUE,menu);	
	add_menu_item("Highscore",show_highscore_wrapper,NULL,TRUE,menu);	
	add_menu_item("",gtk_main_quit,NULL,TRUE,menu);	
	add_menu_item("About",show_about,NULL,TRUE,menu);
	add_submenu("Help",menu,menu_bar,TRUE);

	// horizontal box
	h_box = gtk_hbox_new(FALSE,1);
	gtk_widget_show(h_box);
	gtk_box_pack_start(GTK_BOX(v_box),h_box,FALSE,FALSE,0);
	
	// game_border
	game_border = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(game_border),GTK_SHADOW_IN);
	gtk_box_pack_start(GTK_BOX(h_box),game_border,FALSE,FALSE,1);
	gtk_widget_show(game_border);

	// game_area
	game_area = gtk_drawing_area_new();
	gtk_drawing_area_size(GTK_DRAWING_AREA(game_area),MAX_X*BLOCK_WIDTH,MAX_Y*BLOCK_HEIGHT);
	gtk_signal_connect(GTK_OBJECT(game_area), "expose_event",
			(GtkSignalFunc) game_area_expose_event, NULL);
	
	gtk_widget_set_events(game_area, GDK_EXPOSURE_MASK);
	gtk_container_add(GTK_CONTAINER(game_border),game_area);
	gtk_widget_show(game_area);

	// right_side
	right_side = gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(h_box),right_side,FALSE,FALSE,0);
	gtk_widget_show(right_side);
	
	// next_block_border
	next_block_border = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(next_block_border),GTK_SHADOW_IN);
	gtk_box_pack_start(GTK_BOX(right_side),next_block_border,FALSE,FALSE,0);
	gtk_widget_show(next_block_border);
	
	// next_block_area
	next_block_area = gtk_drawing_area_new();
	gtk_drawing_area_size(GTK_DRAWING_AREA(next_block_area),4*BLOCK_WIDTH,4*BLOCK_HEIGHT);
	gtk_signal_connect(GTK_OBJECT(next_block_area), "expose_event",
			(GtkSignalFunc) next_block_area_expose_event, NULL);
	
	gtk_widget_set_events(next_block_area, GDK_EXPOSURE_MASK);
	gtk_container_add(GTK_CONTAINER(next_block_border),next_block_area);
	gtk_widget_show(next_block_area);
	
	// the score,level and lines labels
	score_label = gtk_label_new("Score:\n0");
	gtk_label_set_justify(GTK_LABEL(score_label),GTK_JUSTIFY_RIGHT);
	gtk_widget_show(score_label);
	gtk_box_pack_start(GTK_BOX(right_side),score_label,FALSE,FALSE,3);

	level_label = gtk_label_new("Level:\n0");
	gtk_label_set_justify(GTK_LABEL(level_label),GTK_JUSTIFY_RIGHT);
	gtk_widget_show(level_label);
	gtk_box_pack_start(GTK_BOX(right_side),level_label,FALSE,FALSE,3);

	lines_label = gtk_label_new("Lines:\n0");
	gtk_label_set_justify(GTK_LABEL(lines_label),GTK_JUSTIFY_RIGHT);
	gtk_widget_show(lines_label);
	gtk_box_pack_start(GTK_BOX(right_side),lines_label,FALSE,FALSE,3);
	
	// show window widget
	gtk_widget_show(main_window);

	// Block images...
	blocks_pixmap = gdk_pixmap_create_from_xpm_d(game_area->window,
						&mask,
						NULL,
						(gchar **)blocks_xpm);	
	// seed random generator
	srandom(time(NULL));

	// gtk_main
	gtk_main();

	return 0; 
}
