/* Linux Commander
 * Copyright (C) 2000 Per Holmng.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "linuxcmd.h"

GtkWidget *ass_window;
GtkWidget *ass_new_window;
GtkWidget *entry1,*entry2,*entry3;
GtkWidget *clist;
GtkWidget *chkdefault;
GdkColor def_color;

gint assselectedrow = -1;
void write_associations();
void associations_dialog_close();
void associations_new();
void associations_edit();
void associations_remove();
void create_ass_new_dialog(gchar *title,gchar *txt1,gchar *txt2,gchar *txt3,gint row, gint def);
void cb_ass_new_ok(GtkWidget *wid, gint row);
void cb_ass_new_cancel(GtkWidget *wid,gint row);

void cb_ass_new_ok(GtkWidget *wid, gint row)
{
	gchar *buf[3];
	gint def;
	gint rownr; 
	
	def = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chkdefault));
	buf[0] = gtk_entry_get_text(GTK_ENTRY(entry1));
	buf[1] = gtk_entry_get_text(GTK_ENTRY(entry2));
	buf[2] = gtk_entry_get_text(GTK_ENTRY(entry3));
	
	if (row == -1)
	{
		rownr = gtk_clist_append(GTK_CLIST(clist),buf);
		if (def)
		{
			gtk_clist_set_foreground(GTK_CLIST(clist),rownr,&def_color);
			gtk_clist_set_row_data(GTK_CLIST(clist),rownr,(gpointer)1);
		}
		else
			gtk_clist_set_row_data(GTK_CLIST(clist),rownr,0);
	}
	else
	{
		gtk_clist_remove(GTK_CLIST(clist),row);
		gtk_clist_insert(GTK_CLIST(clist),row,buf);
		if (def)
		{
			gtk_clist_set_foreground(GTK_CLIST(clist),row,&def_color);
			gtk_clist_set_row_data(GTK_CLIST(clist),row,(gpointer)1);
		}
		else
			gtk_clist_set_row_data(GTK_CLIST(clist),row,0);
	}
	gtk_grab_remove(ass_new_window);
	gtk_widget_destroy(ass_new_window);
	gtk_main_quit();
	write_associations();
}

void cb_ass_new_cancel(GtkWidget *wid,gint row)
{
	gtk_grab_remove(ass_new_window);
	gtk_widget_destroy(ass_new_window);
	gtk_main_quit();
}

void create_ass_new_dialog(gchar *title,gchar *txt1,gchar *txt2,gchar *txt3,gint row,gint def)
{
	GtkWidget *label;
	GtkWidget *button;
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *hbox,*vbox;
	
	gint policy[3] = {0,0,0};

	ass_new_window = create_window(title,350,175,policy);
	gtk_signal_connect(GTK_OBJECT(ass_new_window),"delete-event",
						GTK_SIGNAL_FUNC(cb_delete_event),NULL);
	gtk_container_set_border_width(GTK_CONTAINER(ass_new_window),5);
	
	vbox = gtk_vbox_new(FALSE,5);
	gtk_container_add(GTK_CONTAINER(ass_new_window),vbox);
	gtk_widget_show(vbox);

	frame = gtk_frame_new(0);
	gtk_box_pack_start(GTK_BOX(vbox),frame,0,0,5);
	gtk_widget_show(frame);
	
	table = gtk_table_new(4,2,FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table),5);
	gtk_container_add(GTK_CONTAINER(frame),table);
	gtk_widget_show(table);
	
	label = gtk_label_new("Extension(s): ");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_RIGHT);
	gtk_table_attach(GTK_TABLE(table),label,0,1,0,1,GTK_FILL,0,5,0);
	gtk_widget_show(label);

	entry1 = create_entry(txt1,0,NULL,NULL);
	gtk_table_attach(GTK_TABLE(table),entry1,1,2,0,1,GTK_FILL | GTK_EXPAND,0,5,0);

	label = gtk_label_new("Name: ");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
	gtk_table_attach(GTK_TABLE(table),label,0,1,1,2,GTK_FILL,1,5,0);
	gtk_widget_show(label);

	entry2 = create_entry(txt2,0,NULL,NULL);
	gtk_table_attach(GTK_TABLE(table),entry2,1,2,1,2,GTK_FILL | GTK_EXPAND,0,5,0);

	label = gtk_label_new("Command: ");
	gtk_label_set_justify(GTK_LABEL(label),GTK_JUSTIFY_LEFT);
	gtk_table_attach(GTK_TABLE(table),label,0,1,2,3,GTK_FILL,1,5,0);
	gtk_widget_show(label);

	entry3 = create_entry(txt3,0,NULL,NULL);
	gtk_table_attach(GTK_TABLE(table),entry3,1,2,2,3,GTK_FILL | GTK_EXPAND,0,5,0);
	
	chkdefault = gtk_check_button_new_with_label("Default doubleclick action?");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chkdefault),def);
	gtk_table_attach(GTK_TABLE(table),chkdefault,0,2,3,4,GTK_FILL | GTK_EXPAND,0,5,5);
	gtk_widget_show(chkdefault);
		
	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,0);
	gtk_widget_show(hbox);

	button = create_button("OK",cb_ass_new_ok,(gpointer)row);
	gtk_box_pack_end(GTK_BOX(hbox),button,1,1,5);
	gtk_widget_grab_default(GTK_WIDGET(button));
	button = create_button("Cancel",cb_ass_new_cancel,(gpointer)row);
	gtk_box_pack_end(GTK_BOX(hbox),button,1,1,5);
	
	gtk_window_set_position (GTK_WINDOW (ass_new_window), GTK_WIN_POS_CENTER);
	gtk_widget_show(ass_new_window);
	gtk_window_set_transient_for (GTK_WINDOW (ass_new_window),GTK_WINDOW (app.main_window));
	gtk_grab_add(ass_new_window);
	
}

void associations_dialog_close()
{
	gtk_grab_remove(ass_window);
	gtk_widget_destroy(ass_window);
	gtk_main_quit();
}

void associations_new()
{
	create_ass_new_dialog("New assocation","","","",-1,0);
	gtk_main();
}

void associations_edit()
{
	gchar *buf1,*buf2,*buf3;
	gint def;

	def = (gint)gtk_clist_get_row_data(GTK_CLIST(clist),assselectedrow);
	
	
	gtk_clist_get_text(GTK_CLIST(clist),assselectedrow,0,&buf1);
	gtk_clist_get_text(GTK_CLIST(clist),assselectedrow,1,&buf2);
	gtk_clist_get_text(GTK_CLIST(clist),assselectedrow,2,&buf3);

	create_ass_new_dialog("Edit association",buf1,buf2,buf3,assselectedrow,def);
	gtk_main();
}

void associations_remove()
{
	gtk_clist_remove(GTK_CLIST(clist),assselectedrow);
	write_associations();
}

void cb_clist_click(GtkWidget *clist, gint row,gint column,GdkEvent *event, FileList *list)
{
	assselectedrow = row;
	if (event)
	{
		if (event->type == GDK_2BUTTON_PRESS)
		{
			associations_edit();
		}
	}
}

void write_associations()
{
	gint a;
	FILE *fp;
	gchar *ext,*name,*command;
	gint def;
	
	if ((fp = fopen(get_file_extensions_filename(),"w")))
	{
		for (a = 0; a < GTK_CLIST(clist)->rows; a++)
		{
			gtk_clist_get_text(GTK_CLIST(clist),a,0,&ext);
			gtk_clist_get_text(GTK_CLIST(clist),a,1,&name);
			gtk_clist_get_text(GTK_CLIST(clist),a,2,&command);
			def = (gint)gtk_clist_get_row_data(GTK_CLIST(clist),a);
			if (def)
				fprintf(fp,"%s;%s;%s;default\n",ext,name,command);
			else
				fprintf(fp,"%s;%s;%s\n",ext,name,command);
		}
		gtk_clist_set_column_width(GTK_CLIST(clist),0,gtk_clist_optimal_column_width(GTK_CLIST(clist),0));
		gtk_clist_set_column_width(GTK_CLIST(clist),1,gtk_clist_optimal_column_width(GTK_CLIST(clist),1));
		fclose(fp);
	}
}

void get_associations()
{
	FILE *fp;
	gchar buf[256];
	gchar *row[3];
	gchar *strip,*def;
	gint rownr = 0;
	
	gtk_clist_freeze(GTK_CLIST(clist));
	if ((fp = fopen(get_file_extensions_filename(),"r")))
	{
		while (fgets(buf,256,fp))
		{
			if ((strip = strchr(buf,'\n')))
				*strip = 0;
			row[0] = strtok(buf,";");
			row[1] = strtok(NULL,";");
			row[2] = strtok(NULL,";");
			def = strtok(NULL,";");
			gtk_clist_append(GTK_CLIST(clist),row);
			if (def)
			{
				gtk_clist_set_row_data(GTK_CLIST(clist),rownr,(gpointer)1);
				gtk_clist_set_foreground(GTK_CLIST(clist),rownr,&def_color);
			} 
			else gtk_clist_set_row_data(GTK_CLIST(clist),rownr,0);
			rownr++;
		}
		gtk_clist_set_column_width(GTK_CLIST(clist),0,gtk_clist_optimal_column_width(GTK_CLIST(clist),0));
		gtk_clist_set_column_width(GTK_CLIST(clist),1,gtk_clist_optimal_column_width(GTK_CLIST(clist),1));
		gtk_clist_set_column_width(GTK_CLIST(clist),2,gtk_clist_optimal_column_width(GTK_CLIST(clist),2));
		fclose(fp);
	}
	gtk_clist_thaw(GTK_CLIST(clist));
}

void create_associations_dialog()
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *scrolled_window;
	GtkWidget *button;
	
	gint policy[3] = {1,1,1};
	gchar *titles[3] = { "Extension(s)", "Name","Command" };
	
	gdk_color_parse("blue",&def_color);

	ass_window = create_window("Associations",450,400,policy);
	gtk_signal_connect(GTK_OBJECT(ass_window),"delete-event",
						GTK_SIGNAL_FUNC(cb_delete_event),NULL);
	gtk_container_set_border_width(GTK_CONTAINER(ass_window),5);
	
	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(ass_window),vbox);
	gtk_widget_show(vbox);

	scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_container_set_border_width(GTK_CONTAINER(scrolled_window),5);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
                                    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox),scrolled_window,1,1,0);
	gtk_widget_show(scrolled_window);
	
	clist = gtk_clist_new_with_titles(3,titles);
	gtk_signal_connect(GTK_OBJECT(clist),"select-row",cb_clist_click,NULL);
	gtk_container_add(GTK_CONTAINER(scrolled_window), clist);
	gtk_widget_show(clist);
	
	hbox = gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,0,0,5);
	gtk_widget_show(hbox);
	
	button = create_button("New...",associations_new,NULL);
	gtk_box_pack_start(GTK_BOX(hbox),button,1,1,5);
	gtk_widget_grab_default(GTK_WIDGET(button));
	button = create_button("Remove",associations_remove,NULL);
	gtk_box_pack_start(GTK_BOX(hbox),button,1,1,5);
	button = create_button("Edit",associations_edit,NULL);
	gtk_box_pack_start(GTK_BOX(hbox),button,1,1,5);
	button = create_button("Close",associations_dialog_close,NULL);
	gtk_box_pack_start(GTK_BOX(hbox),button,1,1,5);

	get_associations();
	gtk_window_set_position (GTK_WINDOW (ass_window), GTK_WIN_POS_CENTER);
	gtk_widget_show(ass_window);
	gtk_window_set_transient_for (GTK_WINDOW (ass_window),GTK_WINDOW (app.main_window));
	gtk_grab_add(ass_window);

}
